/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.stats;

import progress.message.broker.StatsManager;
import progress.message.broker.stats.ICounterProvider;
import progress.message.broker.stats.LongDataCollector;
import progress.message.broker.stats.StatsObj;

public class IntervalStatsObj
extends StatsObj {
    protected LongDataCollector data;

    public IntervalStatsObj() {
    }

    public IntervalStatsObj(int id, ICounterProvider provider) {
        super(id, provider);
    }

    public IntervalStatsObj(int facilityId, ICounterProvider provider, String statOutputName, int statType) {
        this(facilityId, provider);
        this.callOutputStatistic(statOutputName, statType);
    }

    private void callOutputStatistic(String statOutputName, int statType) {
        this.outputStatistic(statOutputName, statType);
    }

    public IntervalStatsObj(int facilityId, ICounterProvider provider, int statOutputId, int statType) {
        this(facilityId, provider);
        this.outputStatisticHelper(statOutputId, statType);
    }

    private void outputStatisticHelper(int statOutputId, int statType) {
        this.outputStatistic(statOutputId, statType);
    }

    public IntervalStatsObj(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void intervalEnd() {
        super.intervalEnd();
        IntervalStatsObj intervalStatsObj = this;
        synchronized (intervalStatsObj) {
            this.data.setNextDataValue(this.getLastDataValue());
        }
    }

    @Override
    public synchronized void init() {
        super.init();
        if (this.data == null) {
            this.data = new LongDataCollector();
            this.data.setNumDataValues((int)(StatsManager.STATS_COLLECTION_INTERVAL / StatsManager.STATS_REFRESH_INTERVAL));
        }
    }

    @Override
    public synchronized void reset() {
        super.reset();
        if (this.data == null) {
            this.data = new LongDataCollector();
            this.data.setNumDataValues((int)(StatsManager.STATS_COLLECTION_INTERVAL / StatsManager.STATS_REFRESH_INTERVAL));
        } else {
            this.data.resetDataValues(0L);
        }
    }

    protected synchronized void fill() {
        this.data.resetDataValues(this.data.getLastDataValue());
    }

    @Override
    public synchronized long getStatistic(int statType) {
        switch (statType) {
            case 2: {
                return this.data.getLastDataValue();
            }
            case 1: {
                return this.data.getTotal();
            }
            case 3: {
                return this.data.getMin();
            }
            case 4: {
                return this.data.getMax();
            }
            case 5: {
                return this.data.getAvg();
            }
            case 6: {
                return IntervalStatsObj.compute(this.data.getTotal(), StatsManager.getTimeKeeper().getStatistic(1), 1000);
            }
            case 7: {
                return IntervalStatsObj.compute(this.data.getMax(), StatsManager.STATS_REFRESH_INTERVAL, 1000);
            }
            case 8: {
                return IntervalStatsObj.compute(this.data.getTotal(), StatsManager.getTimeKeeper().getStatistic(1), 100);
            }
            case 9: {
                return IntervalStatsObj.compute(this.data.getMax(), StatsManager.STATS_REFRESH_INTERVAL, 100);
            }
            case 10: {
                return StatsManager.STATS_COLLECTION_INTERVAL / StatsManager.STATS_REFRESH_INTERVAL;
            }
        }
        return super.getStatistic(statType);
    }
}

