/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.stats;

import progress.message.broker.stats.ICounterProvider;
import progress.message.broker.stats.IntervalStatsObj;

public class LTotStatsObj
extends IntervalStatsObj
implements ICounterProvider {
    private long currentValue;
    private boolean useCounter;
    private LTotStatsObj counter;

    public LTotStatsObj() {
        this.setDifferenceMode(true);
        this.setCounterProvider(this);
    }

    public LTotStatsObj(int facilityId) {
        this.setDifferenceMode(true);
        this.setFacilityId(facilityId);
        this.setCounterProvider(this);
    }

    public LTotStatsObj(int facilityId, String statOutputName, int statType) {
        this(facilityId);
        this.outputStatistic(statOutputName, statType);
    }

    public LTotStatsObj(int facilityId, int statOutputId, int statType) {
        this(facilityId);
        this.outputStatistic(statOutputId, statType);
    }

    public LTotStatsObj(String name) {
        super(name);
        this.setDifferenceMode(true);
        this.setCounterProvider(this);
    }

    @Override
    public final void outputStatistic(int statOutputId, int statType) {
        if (statType == 5) {
            this.useCounter = true;
        }
        super.outputStatistic(statOutputId, statType);
    }

    @Override
    public synchronized long getCurrentValue() {
        return this.currentValue;
    }

    public synchronized void add(long increment) {
        this.add(increment, 1L);
    }

    public synchronized void add(long increment, long numObservations) {
        this.currentValue += increment;
        if (this.useCounter) {
            this.counter.add(numObservations);
        }
    }

    @Override
    public synchronized void intervalEnd() {
        super.intervalEnd();
        if (this.useCounter) {
            this.counter.intervalEnd();
        }
    }

    @Override
    public synchronized void init() {
        this.currentValue = 0L;
        super.init();
        if (this.useCounter) {
            this.counter = new LTotStatsObj();
            this.counter.init();
        }
    }

    @Override
    public synchronized void reset() {
        this.currentValue = 0L;
        super.reset();
        if (this.useCounter) {
            this.counter.reset();
        }
    }

    @Override
    public synchronized long getStatistic(int type) {
        long result = 0L;
        switch (type) {
            case 5: {
                if (this.useCounter) {
                    result = LTotStatsObj.compute(this.getStatistic(1), this.counter.getStatistic(1), 1);
                    break;
                }
                result = super.getStatistic(type);
                break;
            }
            case 10: {
                if (this.useCounter) {
                    result = this.counter.getStatistic(1);
                    break;
                }
                result = super.getStatistic(type);
                break;
            }
            default: {
                result = super.getStatistic(type);
            }
        }
        return result;
    }
}

