/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.stats;

import progress.message.broker.stats.ICounterProvider;
import progress.message.broker.stats.IntervalStatsObj;

public class LValueStatsObj
extends IntervalStatsObj
implements ICounterProvider {
    protected long currentValue;

    public LValueStatsObj() {
        this.setDifferenceMode(false);
        this.setCounterProvider(this);
    }

    public LValueStatsObj(String name) {
        super(name);
        this.setDifferenceMode(false);
        this.setCounterProvider(this);
    }

    public LValueStatsObj(int facilityId) {
        this.setDifferenceMode(false);
        this.setCounterProvider(this);
        this.setFacilityId(facilityId);
    }

    public LValueStatsObj(int facilityId, String statOutputName, int statType) {
        this(facilityId);
        this.callOutputStatistic(statOutputName, statType);
    }

    private void callOutputStatistic(String statOutputName, int statType) {
        this.outputStatistic(statOutputName, statType);
    }

    public LValueStatsObj(int facilityId, int statOutputId, int statType) {
        this(facilityId);
        this.outputStatisticHelper(statOutputId, statType);
    }

    private void outputStatisticHelper(int statOutputId, int statType) {
        this.outputStatistic(statOutputId, statType);
    }

    @Override
    public synchronized void init() {
        this.currentValue = 0L;
        super.init();
    }

    @Override
    public synchronized void reset() {
        this.currentValue = 0L;
        super.reset();
    }

    @Override
    public synchronized long getCurrentValue() {
        return this.currentValue;
    }

    public synchronized void add(long increment) {
        this.currentValue += increment;
        if (this.currentValue < 0L) {
            this.currentValue = 0L;
        }
    }

    public synchronized void update(long value) {
        this.currentValue = value;
    }

    @Override
    public synchronized long getStatistic(int statType) {
        switch (statType) {
            case 2: {
                return this.currentValue;
            }
        }
        return super.getStatistic(statType);
    }
}

