/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.stats;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import progress.message.broker.GetStats;
import progress.message.broker.StatsManager;
import progress.message.broker.StatsMetrics;
import progress.message.broker.stats.ICounterProvider;
import progress.message.broker.stats.IStatsProvider;
import progress.message.util.EAssertFailure;
import progress.message.zclient.Message;

public class StatsObj
implements IStatsProvider {
    public static final int STATTYPE_TOTAL = 1;
    public static final int STATTYPE_VALUE = 2;
    public static final int STATTYPE_MIN = 3;
    public static final int STATTYPE_MAX = 4;
    public static final int STATTYPE_AVG = 5;
    public static final int STATTYPE_PER_SECOND_RATE = 6;
    public static final int STATTYPE_PEAK_PER_SECOND_RATE = 7;
    public static final int STATTYPE_UTILIZATION = 8;
    public static final int STATTYPE_PEAK_UTILIZATION = 9;
    public static final int STATTYPE_COUNT = 10;
    private Vector outputTypes = new Vector();
    private Vector outputIds = new Vector();
    private int facilityId;
    private String statsName;
    private long lastObservedValue;
    private long lastDataValue;
    private ICounterProvider counterProvider;
    boolean differenceMode = false;

    public StatsObj() {
    }

    public StatsObj(String name) {
        this.statsName = name;
    }

    public StatsObj(int id, ICounterProvider provider) {
        this.facilityId = id;
        this.counterProvider = provider;
    }

    public StatsObj(int facilityId, ICounterProvider provider, String statOutputName, int statType) {
        this(facilityId, provider);
        this.outputStatisticHelper(statOutputName, statType);
    }

    private void outputStatisticHelper(String statOutputName, int statType) {
        this.outputStatistic(statOutputName, statType);
    }

    public StatsObj(int facilityId, ICounterProvider provider, int statOutputId, int statType) {
        this(facilityId, provider);
        this.outputStatisticHelper(statOutputId, statType);
    }

    private void outputStatisticHelper(int statOutputId, int statType) {
        this.outputStatistic(statOutputId, statType);
    }

    public final void outputStatistic(String desc, int statType) {
        if (desc != null) {
            int statId = GetStats.addMetric(desc, this.facilityId, statType);
            this.outputStatistic(statId, statType);
        }
    }

    public synchronized void outputStatistic(int displayId, int statType) {
        Integer id = new Integer(displayId);
        if (!this.outputIds.contains(id)) {
            this.outputIds.addElement(id);
            this.outputTypes.addElement(new Integer(statType));
            GetStats.addType(displayId, statType);
        }
    }

    public final void setCounterProvider(ICounterProvider provider) {
        this.counterProvider = provider;
    }

    public ICounterProvider getCounterProvider() {
        return this.counterProvider;
    }

    public final void setDifferenceMode(boolean on) {
        this.differenceMode = on;
    }

    public boolean getDifferenceMode() {
        return this.differenceMode;
    }

    protected synchronized long getLastDataValue() {
        return this.lastDataValue;
    }

    @Override
    public int getNumOutputValues() {
        return this.outputIds.size();
    }

    @Override
    public final void setFacilityId(int id) {
        this.facilityId = id;
    }

    @Override
    public int getFacilityId() {
        return this.facilityId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void intervalEnd() {
        long newDataValue = 0L;
        long newObservedValue = this.counterProvider.getCurrentValue();
        if (this.differenceMode) {
            newDataValue = newObservedValue - this.lastObservedValue;
            if (newDataValue < 0L) {
                newDataValue += Long.MAX_VALUE;
            }
        } else {
            newDataValue = newObservedValue;
        }
        StatsObj statsObj = this;
        synchronized (statsObj) {
            this.lastObservedValue = newObservedValue;
            this.lastDataValue = newDataValue;
        }
    }

    @Override
    public void write(Message msg) {
        Enumeration enumTypes = this.outputTypes.elements();
        Enumeration enumIds = this.outputIds.elements();
        while (enumTypes.hasMoreElements()) {
            int statid = (Integer)enumIds.nextElement();
            int type = (Integer)enumTypes.nextElement();
            long value = this.getStatistic(type);
            msg.writeInt(statid);
            msg.writeLong(value);
        }
    }

    @Override
    public void write(DataOutputStream dos) throws IOException {
        Enumeration enumTypes = this.outputTypes.elements();
        Enumeration enumIds = this.outputIds.elements();
        while (enumTypes.hasMoreElements()) {
            int statid = (Integer)enumIds.nextElement();
            int type = (Integer)enumTypes.nextElement();
            long value = this.getStatistic(type);
            dos.writeInt(statid);
            dos.writeLong(value);
        }
    }

    @Override
    public long[][] getStatistics() {
        long[][] out = new long[2][this.outputTypes.size()];
        Enumeration enumTypes = this.outputTypes.elements();
        Enumeration enumIds = this.outputIds.elements();
        int i = 0;
        while (enumTypes.hasMoreElements()) {
            int statid = (Integer)enumIds.nextElement();
            int type = (Integer)enumTypes.nextElement();
            out[0][i] = statid;
            out[1][i] = this.getStatistic(type);
            ++i;
        }
        return out;
    }

    @Override
    public synchronized void debugWrite(PrintStream ps) {
        Enumeration enumTypes = this.outputTypes.elements();
        Enumeration enumIds = this.outputIds.elements();
        while (enumTypes.hasMoreElements()) {
            int statid = (Integer)enumIds.nextElement();
            int type = (Integer)enumTypes.nextElement();
            long value = this.getStatistic(type);
            ps.println(StatsObj.getStatDesc(statid) + ": " + value);
        }
    }

    @Override
    public synchronized void write(PrintWriter ps) {
        Enumeration enumTypes = this.outputTypes.elements();
        Enumeration enumIds = this.outputIds.elements();
        while (enumTypes.hasMoreElements()) {
            int statid = (Integer)enumIds.nextElement();
            int type = (Integer)enumTypes.nextElement();
            long value = this.getStatistic(type);
            ps.println(statid);
            ps.println(value);
        }
    }

    @Override
    public synchronized void init() {
        this.lastObservedValue = 0L;
        this.lastDataValue = 0L;
    }

    @Override
    public synchronized void reset() {
        this.lastObservedValue = 0L;
        this.lastDataValue = 0L;
    }

    @Override
    public long getStatisticValue(int statId) {
        long value = 0L;
        int indx = this.outputIds.indexOf(new Integer(statId));
        if (indx > -1) {
            int type = (Integer)this.outputTypes.elementAt(indx);
            value = this.getStatistic(type);
        }
        return value;
    }

    @Override
    public int getStatisticType(int statId) {
        int type = -1;
        int indx = this.outputIds.indexOf(new Integer(statId));
        if (indx > -1) {
            type = (Integer)this.outputTypes.elementAt(indx);
        }
        return type;
    }

    @Override
    public Enumeration getStatisticsIds() {
        return this.outputIds.elements();
    }

    public synchronized long getStatistic(int statType) {
        switch (statType) {
            case 2: {
                return this.lastDataValue;
            }
            case 1: {
                return this.lastDataValue;
            }
            case 3: {
                return this.lastDataValue;
            }
            case 4: {
                return this.lastDataValue;
            }
            case 5: {
                return this.lastDataValue;
            }
            case 6: {
                return StatsObj.compute(this.lastDataValue, StatsManager.STATS_REFRESH_INTERVAL, 1000);
            }
            case 7: {
                return StatsObj.compute(this.lastDataValue, StatsManager.STATS_REFRESH_INTERVAL, 1000);
            }
            case 8: {
                return StatsObj.compute(this.lastDataValue, StatsManager.STATS_REFRESH_INTERVAL, 100);
            }
            case 9: {
                return StatsObj.compute(this.lastDataValue, StatsManager.STATS_REFRESH_INTERVAL, 100);
            }
            case 10: {
                return 1L;
            }
        }
        throw new EAssertFailure("Statistic Type not available " + statType);
    }

    public String toString() {
        String fac = StatsMetrics.getFacilityName(this.facilityId);
        StringBuffer result = new StringBuffer(fac + " StatsObject for: ");
        if (this.outputIds.isEmpty()) {
            if (this.statsName != null) {
                result.append(this.statsName);
            } else {
                result.append(super.toString());
            }
        } else {
            Enumeration enumIds = this.outputIds.elements();
            while (enumIds.hasMoreElements()) {
                int statid = (Integer)enumIds.nextElement();
                result.append(StatsObj.getStatDesc(statid));
                result.append(", ");
            }
        }
        return result.toString();
    }

    public static String getStatDesc(int id) {
        return (String)GetStats.metricCaptions.get(new Integer(id));
    }

    public static long compute(long n1, long n2, int scale) {
        if (n2 == 0L) {
            return 0L;
        }
        return Math.round((double)n1 / (double)n2 * (double)scale);
    }
}

