/*
 * Decompiled with CFR 0.152.
 */
package progress.message.crypto;

final class DesKey {
    private final byte[] keysced_ = new byte[128];
    private boolean is_weak_key_;
    private boolean is_parity_ok_;

    public final byte[] get_keysced() {
        return this.keysced_;
    }

    public final boolean is_weak_key() {
        return this.is_weak_key_;
    }

    public final boolean is_parity_ok() {
        return this.is_parity_ok_;
    }

    private boolean check_weak_key(byte[] key) {
        for (int i = 0; i < WeakKeysLazyHolder.weak_keys.length; ++i) {
            int j;
            for (j = 0; j < 8 && key[j] == WeakKeysLazyHolder.weak_keys[i][j]; ++j) {
            }
            if (j != 8) continue;
            this.is_weak_key_ = true;
            return true;
        }
        this.is_weak_key_ = false;
        return false;
    }

    private boolean check_parity(byte[] key) {
        for (int i = 0; i < 8; ++i) {
            if (key[i] == OddParityArrayLazyHolder.odd_parity_array[key[i] & 0xFF]) continue;
            this.is_parity_ok_ = false;
            return false;
        }
        this.is_parity_ok_ = true;
        return true;
    }

    public DesKey(byte[] key, boolean check_key) {
        DesKey.set_odd_parity(key);
        this.set_key_sced(key, check_key);
    }

    public static void set_odd_parity(byte[] key) {
        for (int i = 0; i < 8; ++i) {
            key[i] = OddParityArrayLazyHolder.odd_parity_array[key[i] & 0xFF];
        }
    }

    private void set_key_sced(byte[] key, boolean check_key) {
        if (check_key) {
            if (!this.check_parity(key)) {
                return;
            }
            if (this.check_weak_key(key)) {
                return;
            }
        }
        int key_c0 = key[0] & 0xFF | (key[1] & 0xFF) << 8 | (key[2] & 0xFF) << 16 | (key[3] & 0xFF) << 24;
        int key_d0 = key[4] & 0xFF | (key[5] & 0xFF) << 8 | (key[6] & 0xFF) << 16 | (key[7] & 0xFF) << 24;
        int tmp = 0;
        int[] ref_to_c0 = new int[1];
        int[] ref_to_d0 = new int[1];
        ref_to_c0[0] = key_c0;
        ref_to_d0[0] = key_d0;
        int a = ref_to_d0[0];
        int b = ref_to_c0[0];
        tmp = (a >>> 4 ^ b) & 0xF0F0F0F;
        ref_to_d0[0] = a ^= tmp << 4;
        ref_to_c0[0] = b ^= tmp;
        int n = -2;
        int a1 = ref_to_c0[0];
        int tmp2 = (a1 << 16 - n ^ a1) & 0xCCCC0000;
        ref_to_c0[0] = a1 = a1 ^ tmp2 ^ tmp2 >>> 16 - n;
        int n1 = -2;
        int a2 = ref_to_d0[0];
        int tmp3 = (a2 << 16 - n1 ^ a2) & 0xCCCC0000;
        ref_to_d0[0] = a2 = a2 ^ tmp3 ^ tmp3 >>> 16 - n1;
        a = ref_to_d0[0];
        b = ref_to_c0[0];
        tmp = (a >>> 1 ^ b) & 0x55555555;
        ref_to_d0[0] = a ^= tmp << 1;
        ref_to_c0[0] = b ^= tmp;
        a = ref_to_c0[0];
        b = ref_to_d0[0];
        tmp = (a >>> 8 ^ b) & 0xFF00FF;
        ref_to_c0[0] = a ^= tmp << 8;
        ref_to_d0[0] = b ^= tmp;
        a = ref_to_d0[0];
        b = ref_to_c0[0];
        tmp = (a >>> 1 ^ b) & 0x55555555;
        ref_to_d0[0] = a ^= tmp << 1;
        ref_to_c0[0] = b ^= tmp;
        key_c0 = ref_to_c0[0];
        key_d0 = ref_to_d0[0];
        key_d0 = (key_d0 & 0xFF) << 16 | key_d0 & 0xFF00 | (key_d0 & 0xFF0000) >>> 16 | (key_c0 & 0xF0000000) >>> 4;
        key_c0 &= 0xFFFFFFF;
        for (int i = 0; i < 16; ++i) {
            if (Shifts2LazyHolder.shifts2[i]) {
                key_c0 = key_c0 >>> 2 | key_c0 << 26;
                key_d0 = key_d0 >>> 2 | key_d0 << 26;
            } else {
                key_c0 = key_c0 >>> 1 | key_c0 << 27;
                key_d0 = key_d0 >>> 1 | key_d0 << 27;
            }
            int tmp1 = DesSKBLazyHolder.des_skb[0][(key_c0 &= 0xFFFFFFF) & 0x3F] | DesSKBLazyHolder.des_skb[1][key_c0 >>> 6 & 3 | key_c0 >>> 7 & 0x3C] | DesSKBLazyHolder.des_skb[2][key_c0 >>> 13 & 0xF | key_c0 >>> 14 & 0x30] | DesSKBLazyHolder.des_skb[3][key_c0 >>> 20 & 1 | key_c0 >>> 21 & 6 | key_c0 >>> 22 & 0x38];
            tmp = DesSKBLazyHolder.des_skb[4][(key_d0 &= 0xFFFFFFF) & 0x3F] | DesSKBLazyHolder.des_skb[5][key_d0 >>> 7 & 3 | key_d0 >> 8 & 0x3C] | DesSKBLazyHolder.des_skb[6][key_d0 >>> 15 & 0x3F] | DesSKBLazyHolder.des_skb[7][key_d0 >>> 21 & 0xF | key_d0 >>> 22 & 0x30];
            int offset = i * 8;
            int val = tmp << 16 | tmp1 & 0xFFFF;
            this.keysced_[offset++] = (byte)(val & 0xFF);
            this.keysced_[offset++] = (byte)(val >>> 8 & 0xFF);
            this.keysced_[offset++] = (byte)(val >>> 16 & 0xFF);
            this.keysced_[offset++] = (byte)(val >>> 24 & 0xFF);
            tmp1 = tmp1 >>> 16 | tmp & 0xFFFF0000;
            tmp1 = tmp1 << 4 | tmp1 >>> 28;
            this.keysced_[offset++] = (byte)(tmp1 & 0xFF);
            this.keysced_[offset++] = (byte)(tmp1 >>> 8 & 0xFF);
            this.keysced_[offset++] = (byte)(tmp1 >>> 16 & 0xFF);
            this.keysced_[offset++] = (byte)(tmp1 >>> 24 & 0xFF);
        }
    }

    private static class WeakKeysLazyHolder {
        private static byte[][] weak_keys = new byte[][]{{1, 1, 1, 1, 1, 1, 1, 1}, {-2, -2, -2, -2, -2, -2, -2, -2}, {31, 31, 31, 31, 31, 31, 31, 31}, {-32, -32, -32, -32, -32, -32, -32, -32}, {1, -2, 1, -2, 1, -2, 1, -2}, {-2, 1, -2, 1, -2, 1, -2, 1}, {31, -32, 31, -32, 14, -15, 14, -15}, {-32, 31, -32, 31, -15, 14, -15, 14}, {1, -32, 1, -32, 1, -15, 1, -15}, {-32, 1, -32, 1, -15, 1, -15, 1}, {31, -2, 31, -2, 14, -2, 14, -2}, {-2, 31, -2, 31, -2, 14, -2, 14}, {1, 31, 1, 31, 1, 14, 1, 14}, {31, 1, 31, 1, 14, 1, 14, 1}, {-32, -2, -32, -2, -15, -2, -15, -2}, {-2, -32, -2, -32, -2, -15, -2, -15}};

        private WeakKeysLazyHolder() {
        }
    }

    private static class DesSKBLazyHolder {
        private static int[][] des_skb = new int[][]{{0, 16, 0x20000000, 0x20000010, 65536, 65552, 0x20010000, 0x20010010, 2048, 2064, 0x20000800, 536872976, 67584, 67600, 536938496, 536938512, 32, 48, 0x20000020, 0x20000030, 65568, 65584, 0x20010020, 536936496, 2080, 2096, 0x20000820, 536873008, 67616, 67632, 536938528, 536938544, 524288, 524304, 0x20080000, 537395216, 589824, 589840, 0x20090000, 537460752, 526336, 526352, 0x20080800, 537397264, 591872, 591888, 537462784, 537462800, 524320, 524336, 0x20080020, 537395248, 589856, 589872, 0x20090020, 537460784, 526368, 526384, 0x20080820, 537397296, 591904, 591920, 537462816, 537462832}, {0, 0x2000000, 8192, 0x2002000, 0x200000, 0x2200000, 0x202000, 0x2202000, 4, 0x2000004, 8196, 0x2002004, 0x200004, 0x2200004, 0x202004, 0x2202004, 1024, 0x2000400, 9216, 0x2002400, 0x200400, 0x2200400, 0x202400, 0x2202400, 1028, 0x2000404, 9220, 0x2002404, 0x200404, 0x2200404, 0x202404, 0x2202404, 0x10000000, 0x12000000, 0x10002000, 0x12002000, 0x10200000, 0x12200000, 0x10202000, 0x12202000, 0x10000004, 301989892, 268443652, 301998084, 270532612, 304087044, 270540804, 304095236, 0x10000400, 301990912, 268444672, 301999104, 270533632, 304088064, 270541824, 304096256, 0x10000404, 301990916, 268444676, 301999108, 270533636, 304088068, 270541828, 304096260}, {0, 1, 262144, 262145, 0x1000000, 0x1000001, 0x1040000, 0x1040001, 2, 3, 262146, 262147, 0x1000002, 0x1000003, 17039362, 17039363, 512, 513, 262656, 262657, 0x1000200, 0x1000201, 17039872, 17039873, 514, 515, 262658, 262659, 0x1000202, 16777731, 17039874, 17039875, 0x8000000, 0x8000001, 0x8040000, 134479873, 0x9000000, 0x9000001, 0x9040000, 151257089, 0x8000002, 0x8000003, 134479874, 134479875, 0x9000002, 0x9000003, 151257090, 151257091, 0x8000200, 134218241, 134480384, 134480385, 0x9000200, 150995457, 151257600, 151257601, 0x8000202, 134218243, 134480386, 134480387, 0x9000202, 150995459, 151257602, 151257603}, {0, 0x100000, 256, 0x100100, 8, 0x100008, 264, 0x100108, 4096, 0x101000, 4352, 0x101100, 4104, 0x101008, 4360, 0x101108, 0x4000000, 0x4100000, 0x4000100, 0x4100100, 0x4000008, 68157448, 67109128, 68157704, 0x4001000, 0x4101000, 0x4001100, 0x4101100, 67112968, 68161544, 67113224, 68161800, 131072, 0x120000, 131328, 0x120100, 131080, 1179656, 131336, 1179912, 135168, 0x121000, 135424, 0x121100, 135176, 1183752, 135432, 1184008, 0x4020000, 68288512, 67240192, 68288768, 67239944, 68288520, 67240200, 68288776, 67244032, 68292608, 67244288, 68292864, 67244040, 68292616, 67244296, 68292872}, {0, 0x10000000, 65536, 0x10010000, 4, 0x10000004, 65540, 0x10010004, 0x20000000, 0x30000000, 0x20010000, 0x30010000, 0x20000004, 0x30000004, 536936452, 805371908, 0x100000, 0x10100000, 0x110000, 0x10110000, 0x100004, 0x10100004, 0x110004, 0x10110004, 0x20100000, 0x30100000, 0x20110000, 0x30110000, 537919492, 806354948, 537985028, 806420484, 4096, 0x10001000, 69632, 0x10011000, 4100, 0x10001004, 69636, 0x10011004, 0x20001000, 0x30001000, 0x20011000, 0x30011000, 536875012, 805310468, 536940548, 805376004, 0x101000, 0x10101000, 0x111000, 0x10111000, 0x101004, 0x10101004, 0x111004, 0x10111004, 0x20101000, 0x30101000, 0x20111000, 0x30111000, 537923588, 806359044, 537989124, 806424580}, {0, 0x8000000, 8, 0x8000008, 1024, 0x8000400, 1032, 0x8000408, 131072, 0x8020000, 131080, 0x8020008, 132096, 134349824, 132104, 134349832, 1, 0x8000001, 9, 0x8000009, 1025, 134218753, 1033, 134218761, 131073, 134348801, 131081, 134348809, 132097, 134349825, 132105, 134349833, 0x2000000, 0xA000000, 0x2000008, 0xA000008, 0x2000400, 0xA000400, 33555464, 167773192, 0x2020000, 0xA020000, 0x2020008, 167903240, 0x2020400, 167904256, 33686536, 167904264, 0x2000001, 0xA000001, 0x2000009, 0xA000009, 33555457, 167773185, 33555465, 167773193, 0x2020001, 167903233, 0x2020009, 167903241, 33686529, 167904257, 33686537, 167904265}, {0, 256, 524288, 524544, 0x1000000, 0x1000100, 0x1080000, 0x1080100, 16, 272, 524304, 524560, 0x1000010, 0x1000110, 0x1080010, 0x1080110, 0x200000, 0x200100, 0x280000, 2621696, 0x1200000, 0x1200100, 19398656, 19398912, 0x200010, 0x200110, 2621456, 2621712, 0x1200010, 0x1200110, 19398672, 19398928, 512, 768, 524800, 525056, 0x1000200, 0x1000300, 17302016, 17302272, 528, 784, 524816, 525072, 0x1000210, 0x1000310, 17302032, 17302288, 0x200200, 0x200300, 0x280200, 2622208, 0x1200200, 18875136, 19399168, 19399424, 0x200210, 2097936, 2621968, 2622224, 0x1200210, 18875152, 19399184, 19399440}, {0, 0x4000000, 262144, 0x4040000, 2, 0x4000002, 262146, 0x4040002, 8192, 0x4002000, 270336, 0x4042000, 8194, 0x4002002, 270338, 0x4042002, 32, 0x4000020, 262176, 0x4040020, 34, 0x4000022, 262178, 0x4040022, 8224, 0x4002020, 270368, 0x4042020, 8226, 0x4002022, 270370, 0x4042022, 2048, 0x4000800, 264192, 0x4040800, 2050, 67110914, 264194, 67373058, 10240, 67119104, 272384, 67381248, 10242, 67119106, 272386, 67381250, 2080, 67110944, 264224, 67373088, 2082, 67110946, 264226, 67373090, 10272, 67119136, 272416, 67381280, 10274, 67119138, 272418, 67381282}};

        private DesSKBLazyHolder() {
        }
    }

    private static class Shifts2LazyHolder {
        private static boolean[] shifts2 = new boolean[]{false, false, true, true, true, true, true, true, false, true, true, true, true, true, true, false};

        private Shifts2LazyHolder() {
        }
    }

    private static class OddParityArrayLazyHolder {
        private static byte[] odd_parity_array = new byte[]{1, 1, 2, 2, 4, 4, 7, 7, 8, 8, 11, 11, 13, 13, 14, 14, 16, 16, 19, 19, 21, 21, 22, 22, 25, 25, 26, 26, 28, 28, 31, 31, 32, 32, 35, 35, 37, 37, 38, 38, 41, 41, 42, 42, 44, 44, 47, 47, 49, 49, 50, 50, 52, 52, 55, 55, 56, 56, 59, 59, 61, 61, 62, 62, 64, 64, 67, 67, 69, 69, 70, 70, 73, 73, 74, 74, 76, 76, 79, 79, 81, 81, 82, 82, 84, 84, 87, 87, 88, 88, 91, 91, 93, 93, 94, 94, 97, 97, 98, 98, 100, 100, 103, 103, 104, 104, 107, 107, 109, 109, 110, 110, 112, 112, 115, 115, 117, 117, 118, 118, 121, 121, 122, 122, 124, 124, 127, 127, -128, -128, -125, -125, -123, -123, -122, -122, -119, -119, -118, -118, -116, -116, -113, -113, -111, -111, -110, -110, -108, -108, -105, -105, -104, -104, -101, -101, -99, -99, -98, -98, -95, -95, -94, -94, -92, -92, -89, -89, -88, -88, -85, -85, -83, -83, -82, -82, -80, -80, -77, -77, -75, -75, -74, -74, -71, -71, -70, -70, -68, -68, -65, -65, -63, -63, -62, -62, -60, -60, -57, -57, -56, -56, -53, -53, -51, -51, -50, -50, -48, -48, -45, -45, -43, -43, -42, -42, -39, -39, -38, -38, -36, -36, -33, -33, -32, -32, -29, -29, -27, -27, -26, -26, -23, -23, -22, -22, -20, -20, -17, -17, -15, -15, -14, -14, -12, -12, -9, -9, -8, -8, -5, -5, -3, -3, -2, -2};

        private OddParityArrayLazyHolder() {
        }
    }
}

