/*
 * Decompiled with CFR 0.152.
 */
package progress.message.crypto;

public class MessageHash {
    private byte[] hash;

    protected MessageHash(byte[] hash0) {
        this.hash = new byte[hash0.length];
        System.arraycopy(hash0, 0, this.hash, 0, hash0.length);
    }

    public final byte[] toByteArray() {
        byte[] buf = new byte[this.hash.length];
        System.arraycopy(this.hash, 0, buf, 0, this.hash.length);
        return buf;
    }

    public final int length() {
        return this.hash.length;
    }

    public int hashCode() {
        switch (this.hash.length) {
            case 0: {
                return 0;
            }
            case 1: {
                return this.hash[0];
            }
            case 2: {
                return this.hash[0] ^ this.hash[1] << 8;
            }
            case 3: {
                return this.hash[0] ^ this.hash[1] << 8 ^ this.hash[2] << 16;
            }
        }
        return this.hash[0] ^ this.hash[1] << 8 ^ this.hash[2] << 16 ^ this.hash[3] << 24;
    }

    public boolean equals(Object obj) {
        if (obj != null && this.getClass() == obj.getClass()) {
            return this.equalTo(((MessageHash)obj).hash);
        }
        return false;
    }

    protected final boolean equalTo(byte[] buffer) {
        byte[] hash = this.hash;
        int len = hash.length;
        if (buffer.length == len) {
            while (--len >= 0) {
                if (buffer[len] == hash[len]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.hash.length; ++i) {
            sb.append(Integer.toString(this.hash[i] >>> 4 & 0xF, 16)).append(Integer.toString(this.hash[i] & 0xF, 16));
        }
        return sb.toString();
    }
}

