/*
 * Decompiled with CFR 0.152.
 */
package progress.message.cwaq;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import progress.message.broker.AgentAdministrativelyCreatedQueue;
import progress.message.broker.AgentQueueProcessor;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Config;
import progress.message.broker.IAgentQueue;
import progress.message.broker.IRemoteBroker;
import progress.message.broker.RoutingConfiguration;
import progress.message.broker.RoutingConnectionInfo;
import progress.message.gr.RouteInfo;
import progress.message.gr.RouteRequest;
import progress.message.msg.IMgram;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;

public class ClusteredQueueManager
extends DebugObject {
    private AgentRegistrar m_reg = null;
    private static volatile String m_localNodeName = null;
    private Hashtable m_clusteredQtoNeighborListTable;
    private Hashtable m_activeNeighbors;

    public ClusteredQueueManager(AgentRegistrar reg) {
        super(DebugState.GLOBAL_DEBUG_ON ? "ClusteredQueueManager" : null);
        this.m_reg = reg;
        m_localNodeName = Config.ROUTING_NODE_NAME;
        this.m_clusteredQtoNeighborListTable = new Hashtable();
        this.m_activeNeighbors = new Hashtable();
    }

    public void advertiseClusteredQueues(IRemoteBroker irb) {
        RouteRequest rr = new RouteRequest(4);
        if (this.DEBUG) {
            this.debug("advertiseClusteredQueues to irb = " + irb);
        }
        RoutingConfiguration rc = AgentRegistrar.getAgentRegistrar().getRoutingConfig();
        RoutingConnectionInfo rci = rc.getRoutingConnection(m_localNodeName);
        AgentQueueProcessor aqp = AgentRegistrar.getAgentRegistrar().getQueueProc();
        Enumeration clusteredQueues = null;
        clusteredQueues = aqp.getClusteredQueues();
        IAgentQueue iaq = null;
        while (clusteredQueues.hasMoreElements()) {
            iaq = (IAgentQueue)clusteredQueues.nextElement();
            String clusteredName = iaq.getQueueName();
            ClusteredQueueManager.createRouteInfoObject(clusteredName, rci, rr);
        }
        if (irb.isConnected()) {
            irb.sendThrough(rr.getIMgram((short)-1));
        }
    }

    public void disconnectAllClusteredQueueInstances(Long clientId) {
        if (this.DEBUG) {
            this.debug("disconnectAllClusteredQueueInstances: entering.... clientId= " + clientId);
        }
        IRemoteBroker irb = (IRemoteBroker)this.m_activeNeighbors.get(clientId);
        this.m_activeNeighbors.remove(clientId);
        if (this.DEBUG) {
            this.debug("disconnectAllClusteredQueueInstances: removed from neighbor list  clientId = " + clientId + " irb = " + irb);
        }
        Enumeration entries = this.m_clusteredQtoNeighborListTable.elements();
        Vector neighbors = null;
        while (entries.hasMoreElements()) {
            neighbors = (Vector)entries.nextElement();
            neighbors.remove(irb);
            if (!this.DEBUG) continue;
            this.debug("disconnectAllClusteredQueueInstances: removed from each clustered queue's list of neighbors list  clientId = " + clientId);
        }
        Enumeration cqs = AgentRegistrar.getAgentRegistrar().getQueueProc().getClusteredQueues();
        IAgentQueue iaq = null;
        while (cqs.hasMoreElements()) {
            iaq = (IAgentQueue)cqs.nextElement();
            if (!iaq.isClustered()) continue;
            ((AgentAdministrativelyCreatedQueue)iaq).onRemoveClusteredQueueInstance(clientId);
        }
    }

    public IRemoteBroker getRemoteBrokerforClusteredQueue(String destination, long ccid) {
        if (this.DEBUG) {
            this.debug("getRemoteBrokerforClusteredQueue: entering look up with destination = " + destination + " ccid=" + ccid);
        }
        IRemoteBroker irb = null;
        Vector neighborList = (Vector)this.m_clusteredQtoNeighborListTable.get(destination);
        if (neighborList != null) {
            Enumeration entries = neighborList.elements();
            while (entries.hasMoreElements() && (irb = (IRemoteBroker)entries.nextElement()).getClientID() != ccid) {
                irb = null;
            }
        }
        if (this.DEBUG) {
            this.debug("getRemoteBrokerforClusteredQueue: exiting look up with destination = " + destination + " ccid=" + ccid + " is returning irb = " + irb);
        }
        return irb;
    }

    public Enumeration getRemoteBrokersforClusteredQueue(String destination) {
        Vector neighborList;
        if (this.DEBUG) {
            this.debug("getRemoteBrokerforClusteredQueue: entering... look up with destination = " + destination);
        }
        if ((neighborList = (Vector)this.m_clusteredQtoNeighborListTable.get(destination)) != null) {
            if (this.DEBUG) {
                this.debug("getRemoteBrokerforClusteredQueue: exiting with enumeration for look up with destination = " + destination);
            }
            return neighborList.elements();
        }
        if (this.DEBUG) {
            this.debug("getRemoteBrokerforClusteredQueue: exiting with null for look up with destination = " + destination);
        }
        return null;
    }

    public void handleClusteredAdvertise(IRemoteBroker rb, RouteRequest rr) {
        if (this.DEBUG) {
            this.debug("handleClusteredAdvertise: Remote Broker is " + rb.getNodeName() + "::" + rb.getBrokerName());
        }
        String destination = null;
        for (int i = rr.getInfoCount() - 1; i >= 0; --i) {
            RouteInfo ri = rr.getInfo(i);
            destination = ri.getGlobalName();
            Vector<IRemoteBroker> neighborList = (Vector<IRemoteBroker>)this.m_clusteredQtoNeighborListTable.get(ri.getGlobalName());
            if (neighborList == null) {
                if (this.DEBUG) {
                    this.debug("handleClusteredAdvertise: adding new list for clustered queue " + destination + " with rb " + rb);
                }
                neighborList = new Vector<IRemoteBroker>();
                neighborList.add(rb);
                this.m_clusteredQtoNeighborListTable.put(destination, neighborList);
                this.newClusteredQueueNotification(rb, destination);
                continue;
            }
            if (neighborList.contains(rb)) {
                if (!this.DEBUG) continue;
                this.debug("handleClusteredAdvertise: neighbor already listed for  " + destination + " for the broker rb " + rb);
                continue;
            }
            if (this.DEBUG) {
                this.debug("handleClusteredAdvertise: adding to existing list for clustered queue " + destination + " the broker rb " + rb);
            }
            neighborList.add(rb);
            this.newClusteredQueueNotification(rb, destination);
        }
        if (this.DEBUG) {
            this.debug("handleClusteredAdvertise: ............exiting.");
        }
    }

    public void handleClusteredRemove(IRemoteBroker rb, RouteRequest rr) {
        if (this.DEBUG) {
            this.debug("handleClusteredRemove: Remote Broker is " + rb.getNodeName() + "::" + rb.getBrokerName());
        }
        String destination = null;
        for (int i = rr.getInfoCount() - 1; i >= 0; --i) {
            RouteInfo ri = rr.getInfo(i);
            destination = ri.getGlobalName();
            Vector neighborList = (Vector)this.m_clusteredQtoNeighborListTable.get(ri.getGlobalName());
            if (neighborList != null) {
                if (this.DEBUG) {
                    this.debug("handleClusteredRemove: removing list for clustered queue " + destination + " with rb " + rb);
                }
                neighborList.remove(rb);
                this.removedClusteredQueueNotification(rb, destination);
                continue;
            }
            if (!this.DEBUG) continue;
            this.debug("handleClusteredRemove: no entry in list for clustered queue " + destination + " to remove for the broker rb " + rb);
        }
        if (this.DEBUG) {
            this.debug("handleClusteredRemove: ............exiting.");
        }
    }

    public void newClusteredQueueNotification(IRemoteBroker irb, String queueName) {
        IAgentQueue iaq;
        if (this.DEBUG) {
            this.debug("newClusteredQueueInstance: adding queueName = " + queueName + " for irb = " + irb);
        }
        if ((iaq = AgentRegistrar.getAgentRegistrar().getQueueProc().getAgentQueue(queueName)) != null) {
            ((AgentAdministrativelyCreatedQueue)iaq).onNewClusteredQueueInstance(irb);
        }
    }

    public void onMgram(IRemoteBroker rb, IMgram img) {
        RouteRequest rr = new RouteRequest();
        rr.fromIMgramPayload(img.getRawBody(), (short)-1);
        switch (rr.getRequestType()) {
            case 4: {
                this.handleClusteredAdvertise(rb, rr);
                break;
            }
            case 5: {
                this.handleClusteredRemove(rb, rr);
                break;
            }
        }
    }

    public void onNewConnection(IRemoteBroker irb) {
        boolean sameNode = m_localNodeName.equals(irb.getNodeName());
        if (sameNode) {
            this.m_activeNeighbors.put(irb.getClientID(), irb);
            this.advertiseClusteredQueues(irb);
        }
    }

    public void onNewClustered(String clusteredName) {
        if (this.DEBUG) {
            this.debug("onNewClustered: clustered name is " + clusteredName);
        }
        if (this.m_activeNeighbors.isEmpty()) {
            return;
        }
        RoutingConfiguration rc = AgentRegistrar.getAgentRegistrar().getRoutingConfig();
        RoutingConnectionInfo rci = rc.getRoutingConnection(m_localNodeName);
        RouteRequest rr = new RouteRequest(4);
        ClusteredQueueManager.createRouteInfoObject(clusteredName, rci, rr);
        Enumeration entries = this.m_activeNeighbors.elements();
        while (entries.hasMoreElements()) {
            IRemoteBroker rba = (IRemoteBroker)entries.nextElement();
            if (this.DEBUG) {
                this.debug("onNewClustered advertising " + clusteredName + " to rb = " + rba);
            }
            if (!rba.isConnected()) continue;
            rba.sendThrough(rr.getIMgram((short)-1));
        }
    }

    public void onRemoveClustered(String clusteredName) {
        if (this.DEBUG) {
            this.debug("onRemoveClustered: clustered name is " + clusteredName);
        }
        if (this.m_activeNeighbors.isEmpty()) {
            return;
        }
        RoutingConfiguration rc = AgentRegistrar.getAgentRegistrar().getRoutingConfig();
        RoutingConnectionInfo rci = rc.getRoutingConnection(m_localNodeName);
        RouteRequest rr = new RouteRequest(5);
        ClusteredQueueManager.createRouteInfoObject(clusteredName, rci, rr);
        Enumeration entries = this.m_activeNeighbors.elements();
        while (entries.hasMoreElements()) {
            IRemoteBroker rba = (IRemoteBroker)entries.nextElement();
            if (this.DEBUG) {
                this.debug("onRemoveClustered: advertising removal of clustered q = " + clusteredName + " to rb = " + rba);
            }
            if (!rba.isConnected()) continue;
            rba.sendThrough(rr.getIMgram((short)-1));
        }
    }

    private static void createRouteInfoObject(String clusteredName, RoutingConnectionInfo rci, RouteRequest rr) {
        RouteInfo ri = new RouteInfo();
        ri.setGlobalName(clusteredName);
        ri.setNodeName(m_localNodeName);
        ri.setBrokerName(Config.BROKER_NAME);
        ri.setConnectionInfo(rci);
        rr.addInfo(ri);
    }

    public void removedClusteredQueueNotification(IRemoteBroker irb, String queueName) {
        IAgentQueue iaq;
        if (this.DEBUG) {
            this.debug("removedClusteredQueueNotification: removing queueName = " + queueName + " for irb = " + irb);
        }
        if ((iaq = AgentRegistrar.getAgentRegistrar().getQueueProc().getAgentQueue(queueName)) != null) {
            ((AgentAdministrativelyCreatedQueue)iaq).onRemoveClusteredQueueInstance(irb.getClientID());
        }
    }
}

