/*
 * Decompiled with CFR 0.152.
 */
package progress.message.db;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Properties;
import progress.message.broker.Config;
import progress.message.db.Db;
import progress.message.db.EDatabaseException;
import progress.message.db.jdbc.JDBCDatabase;
import progress.message.db.prAccessor;
import progress.message.db.pse.PSEBrokerDb;
import progress.message.dbsc.sql.DbSchemaDD;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.zclient.DebugObject;

public class DBFactory {
    public static Db createBrokerDb() throws EDatabaseException {
        PSEBrokerDb db = null;
        String DATABASE_STORE_TYPE = Config.DATABASE_STORE_TYPE;
        if (DebugState.GLOBAL_DEBUG_ON) {
            DebugObject.class_debug("DBFactory", "createBrokerDb(); dbtype = " + DATABASE_STORE_TYPE);
        }
        if (!DATABASE_STORE_TYPE.equalsIgnoreCase(Config.DATABASE_STORE_TYPE_EMBEDDED)) {
            throw new EAssertFailure("Cannot initialize BrokerDb; DatabaseStoreType must be Embedded; type " + DATABASE_STORE_TYPE + " is not supported");
        }
        db = new PSEBrokerDb(Config.MQSTORE_DB_CONNECT, Config.BROKER_NAME, "TxnIndices");
        if (DebugState.GLOBAL_DEBUG_ON) {
            DebugObject.class_debug("DBFactory", "createBrokerDb(); created " + db);
        }
        return db;
    }

    public static Db createBrokerDb(Properties props) throws EDatabaseException {
        PSEBrokerDb db = null;
        String DATABASE_STORE_TYPE = props.getProperty("DATABASE_STORE_TYPE");
        String BROKER_NAME = props.getProperty("BROKER_NAME");
        if (DebugState.GLOBAL_DEBUG_ON) {
            DebugObject.class_debug("DBFactory", "createBrokerDb(props); dbtype = " + DATABASE_STORE_TYPE);
        }
        if (!DATABASE_STORE_TYPE.equalsIgnoreCase("Embedded")) {
            throw new EAssertFailure("Cannot initialize BrokerDb; DatabaseStoreType must be Embedded; type " + DATABASE_STORE_TYPE + " is not supported");
        }
        String MQSTORE_DB_CONNECT = props.getProperty("MQSTORE_DB_CONNECT");
        db = new PSEBrokerDb(MQSTORE_DB_CONNECT, BROKER_NAME, "TxnIndices");
        if (DebugState.GLOBAL_DEBUG_ON) {
            DebugObject.class_debug("DBFactory", "createBrokerDb(props); created " + db);
        }
        return db;
    }

    public static Db createDupDetectDb(Properties props, Db brokerDb) throws EDatabaseException {
        String ddObjectName = props.getProperty("INDEXED_TXN_TABLE_NAME");
        if (ddObjectName == null || ddObjectName.trim().equals("")) {
            if (brokerDb == null) {
                throw new EAssertFailure("DupDetect table is in basic db; create brokerDb first");
            }
            if (DebugState.GLOBAL_DEBUG_ON) {
                DebugObject.class_debug("DBFactory", "createDupDetectDb(props, brokerDb); returning brokerdb " + brokerDb + " ddname= " + brokerDb.getDDName());
            }
            return brokerDb;
        }
        String dbConnect = props.getProperty("INDEXED_TXN_DB_CONNECT");
        String jdbcDriver = props.getProperty("INDEXED_TXN_JDBC_DRIVER");
        String dbProperties = props.getProperty("INDEXED_TXN_DB_PROPERTIES");
        String user = props.getProperty("INDEXED_TXN_DB_USER", "");
        String passwd = props.getProperty("INDEXED_TXN_DB_PASSWORD", "");
        Properties connectInfo = new Properties();
        connectInfo.put("user", user);
        connectInfo.put("password", passwd);
        JDBCDatabase jdb = DBFactory.createJDBCDatabase(dbConnect, "", connectInfo, jdbcDriver, dbProperties);
        jdb.setDupDetectTableName(ddObjectName);
        jdb.setSchemaDef(new DbSchemaDD(jdb, ddObjectName));
        JDBCDatabase db = jdb;
        if (DebugState.GLOBAL_DEBUG_ON) {
            DebugObject.class_debug("DBFactory", "createDupDetectDb(props); created " + db + " ddname= " + ((Db)db).getDDName());
        }
        return db;
    }

    public static JDBCDatabase createJDBCDatabase(String url, String brokerInstance, Properties connectInfo, String driver, String dbpropfile) throws EDatabaseException {
        Properties p = new Properties();
        if (dbpropfile != null) {
            try {
                FileInputStream fis = new FileInputStream(dbpropfile);
                p.load(fis);
            }
            catch (FileNotFoundException e) {
                Object[] parms = new Object[]{dbpropfile};
                String msg = MessageFormat.format(prAccessor.getString("startupFailureDBProps"), parms);
                throw new EDatabaseException(msg);
            }
            catch (IOException e) {
                Object[] parms = new Object[]{dbpropfile};
                String msg = MessageFormat.format(prAccessor.getString("startupFailureLoadDBProps"), parms);
                throw new EDatabaseException(msg);
            }
        } else {
            Object[] parms = new Object[]{""};
            String msg = MessageFormat.format(prAccessor.getString("startupFailureDBProps"), parms);
            throw new EDatabaseException(msg);
        }
        JDBCDatabase db = new JDBCDatabase(url, brokerInstance, connectInfo, driver, p);
        if (brokerInstance != null && brokerInstance.length() > 0) {
            db.setVersionTableName("BrokerDBVer");
        }
        return db;
    }

    public static boolean isBrokerDbDirExists() {
        try {
            File f = new File(Config.MQSTORE_DB_CONNECT);
            return f.exists() && f.isDirectory();
        }
        catch (Exception e) {
            return false;
        }
    }
}

