/*
 * Decompiled with CFR 0.152.
 */
package progress.message.db.pse;

import com.odi.Database;
import com.odi.DatabaseNotFoundException;
import com.odi.ObjectStoreException;
import com.odi.Session;
import com.odi.Transaction;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import progress.message.broker.Config;
import progress.message.db.EDatabaseException;
import progress.message.db.EDatabaseNotExists;
import progress.message.db.prAccessor;
import progress.message.db.pse.IRWXLock;
import progress.message.db.pse.PSEUtil;
import progress.message.db.pse.util.DbMetrics;
import progress.message.db.pse.util.ReentrantRWXLock;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;
import progress.message.zclient.DebugThread;

public class PSEDbContext
extends DebugObject {
    String m_dbName;
    Session m_session;
    Database m_database;
    IRWXLock m_dbLock;
    int m_ident;
    Transaction m_txn;
    volatile boolean m_closed;
    boolean DEBUG1 = (this.debugFlags & 0x40) > 0;
    DbMetrics m_dbMetrics;
    DbMetrics m_dbMetricsI;

    PSEDbContext(int id, String dbname) {
        super(DebugState.GLOBAL_DEBUG_ON ? "PSEDbContext " + id + ", " + dbname : null);
        this.m_dbName = dbname;
        this.m_ident = id;
        if (this.DEBUG) {
            this.debug("Constructed ");
        }
    }

    private void initMetrics() {
        try {
            File f = new File(this.m_dbName);
            String shortDbName = f.getName();
            shortDbName = shortDbName.substring(0, shortDbName.indexOf("."));
            String metricsDbg = "DbMetrics" + shortDbName;
            if (this.DEBUG1) {
                this.debug("shortDbName= " + shortDbName);
            }
            if (DebugState.get(metricsDbg)) {
                this.debugInitialize(metricsDbg, shortDbName);
                this.m_dbMetrics = new DbMetrics(f.getCanonicalPath(), shortDbName, DebugState.getDiagnosticFlags(metricsDbg));
            } else {
                metricsDbg = "DbMetricsI" + shortDbName;
                if (DebugState.get(metricsDbg)) {
                    this.debugInitialize(metricsDbg, shortDbName);
                    this.m_dbMetricsI = new DbMetrics(f.getCanonicalPath(), shortDbName, (long)DebugState.getDiagnosticFlags(metricsDbg));
                    this.m_dbMetricsI.init(this.m_session, this.m_dbLock);
                }
            }
        }
        catch (ObjectStoreException ose) {
            this.m_dbMetrics = null;
            this.m_dbMetricsI = null;
        }
        catch (IOException ex) {
            this.m_dbMetrics = null;
            this.m_dbMetricsI = null;
        }
    }

    private void debugInitialize(String metricsDbg, String shortDbName) {
        if (this.DEBUG1) {
            this.debug("initializing " + metricsDbg + " for " + shortDbName);
        }
    }

    public int getIdent() {
        return this.m_ident;
    }

    public void open() throws EDatabaseException, EDatabaseNotExists {
        Session sess = null;
        if (this.DEBUG) {
            this.debug("open: starting... ");
        }
        try {
            sess = PSEUtil.createSession(this.getSessionIdent());
            HashMap dbOpenParams = PSEDbContext.retrieveDbOpenParams(sess);
            try {
                this.m_database = Database.open((String)this.m_dbName, (int)7, (HashMap)dbOpenParams);
            }
            catch (DatabaseNotFoundException ex) {
                if (sess != null) {
                    sess.terminate();
                }
                throw new EDatabaseNotExists(prAccessor.getString("DB_NOT_EXISTS") + this.m_dbName, ex);
            }
            this.populateLockSessionAndBeginTrans(sess);
            this.initMetrics();
        }
        catch (ObjectStoreException ex) {
            if (sess != null) {
                if (this.DEBUG) {
                    this.debug("open: terminating session ", ex);
                }
                sess.terminate();
            }
            this.handlePSEExceptionInternal(ex);
        }
        if (this.DEBUG) {
            this.debug("open: completed... ");
        }
    }

    private String getSessionIdent() {
        return "id= " + this.m_ident + " db= " + this.m_dbName;
    }

    public void create() throws EDatabaseException, EDatabaseNotExists {
        if (this.DEBUG) {
            this.debug("create: starting... ");
        }
        try {
            Session sess = PSEUtil.createSession(this.getSessionIdent());
            HashMap dbOpenParams = PSEDbContext.retrieveDbOpenParams(sess);
            this.m_database = Database.create((String)this.m_dbName, (int)438, (HashMap)dbOpenParams);
            this.populateLockSessionAndBeginTrans(sess);
        }
        catch (ObjectStoreException ex) {
            this.handlePSEExceptionInternal(ex);
        }
        if (this.DEBUG) {
            this.debug("create: completed... ");
        }
    }

    private void populateLockSessionAndBeginTrans(Session sess) throws EDatabaseException {
        this.m_dbLock = new ReentrantRWXLock();
        this.m_session = sess;
        this.beginTrans();
        PSEDbContext pSEDbContext = this;
        pSEDbContext.m_session.leave();
    }

    private static HashMap retrieveDbOpenParams(Session sess) {
        sess.join();
        HashMap<String, Boolean> dbOpenParams = new HashMap<String, Boolean>();
        dbOpenParams.put("DO_FILE_SYNC", new Boolean(Config.DB_FORCE_SYNC));
        return dbOpenParams;
    }

    public void destroy() {
        if (this.DEBUG) {
            this.debug("destroy: starting... ");
        }
        try {
            if (this.m_session.isActive()) {
                this.m_session.join();
                this.abortTransaction();
                if (this.m_database.isOpen()) {
                    this.m_database.destroy();
                }
                this.m_session.terminate();
            } else {
                Session sess = PSEUtil.createSession(this.getSessionIdent());
                sess.join();
                Database db = Database.open((String)this.m_dbName, (int)438);
                db.destroy();
                sess.terminate();
            }
        }
        catch (ObjectStoreException objectStoreException) {
            // empty catch block
        }
        if (this.DEBUG) {
            this.debug("destroy: completed... ");
        }
    }

    public void close() {
        block17: {
            if (this.m_closed) {
                return;
            }
            if (this.DEBUG1) {
                this.debug("close: starting... ");
            }
            if (this.m_dbMetricsI != null) {
                this.m_dbMetricsI.terminate();
            }
            try {
                if (!this.m_session.isActive()) break block17;
                this.m_session.join();
                this.m_dbLock.acquireExclusiveLock();
                try {
                    try {
                        this.abortTransaction();
                    }
                    catch (ObjectStoreException objectStoreException) {
                        // empty catch block
                    }
                    try {
                        if (this.m_database.isOpen()) {
                            if (this.DEBUG1) {
                                this.debug("close: Calling m_database.close() ");
                            }
                            this.m_database.close();
                        }
                    }
                    catch (ObjectStoreException objectStoreException) {
                        // empty catch block
                    }
                    this.m_session.terminate();
                }
                finally {
                    this.m_closed = true;
                    this.m_dbLock.releaseExclusiveLock();
                }
            }
            catch (ObjectStoreException objectStoreException) {
            }
            finally {
                this.m_closed = true;
            }
        }
        if (this.DEBUG1) {
            this.debug("close: completed... ");
        }
    }

    private void abortTransaction() {
        if (this.m_session.inTransaction()) {
            this.m_session.currentTransaction().abort();
        }
    }

    public Database getDatabase() {
        return this.m_database;
    }

    public IRWXLock getDbLock() {
        return this.m_dbLock;
    }

    public Session getSession() {
        return this.m_session;
    }

    public void beginTrans() throws EDatabaseException {
        this.m_dbLock.acquireExclusiveLock();
        try {
            this.m_txn = Transaction.begin((int)7);
        }
        catch (ObjectStoreException ex) {
            this.handlePSEExceptionInternal(ex);
        }
        finally {
            this.m_dbLock.releaseExclusiveLock();
        }
    }

    public void commit() throws EDatabaseException {
        this.m_dbLock.acquireExclusiveLock();
        try {
            this.m_txn.commit(3);
            if (this.m_dbMetrics != null) {
                this.m_dbMetrics.updatectr(this.m_session);
            }
            this.m_txn = Transaction.begin((int)7);
        }
        catch (ObjectStoreException ose) {
            if (this.DEBUG1) {
                this.debug("Commit exception " + Thread.currentThread() + " " + ose.toString(), ose);
            }
            try {
                this.rollbackInternal();
            }
            catch (ObjectStoreException objectStoreException) {
                // empty catch block
            }
            this.handlePSEExceptionInternal(ose);
        }
        finally {
            this.m_dbLock.releaseExclusiveLock();
        }
    }

    private void rollbackInternal() throws ObjectStoreException {
        if (this.m_txn.isActive()) {
            this.m_txn.abort(2);
        }
        this.m_txn = Transaction.begin((int)7);
    }

    public void rollback() throws EDatabaseException {
        if (this.DEBUG1) {
            this.debug("Rollback called " + Thread.currentThread());
            Thread.currentThread();
            Thread.dumpStack();
        }
        this.m_dbLock.acquireExclusiveLock();
        try {
            this.rollbackInternal();
        }
        catch (ObjectStoreException ex) {
            this.handlePSEExceptionInternal(ex);
        }
        finally {
            this.m_dbLock.releaseExclusiveLock();
        }
    }

    private boolean isThreadShuttingDown() {
        boolean threadShuttingDown = false;
        Thread thisThread = Thread.currentThread();
        if (thisThread instanceof DebugThread) {
            threadShuttingDown = ((DebugThread)thisThread).isShuttingDown();
        }
        if (this.DEBUG) {
            this.debug("threadShuttingDown= " + threadShuttingDown + " " + thisThread);
        }
        return threadShuttingDown;
    }

    private void handlePSEExceptionInternal(ObjectStoreException ose) throws EDatabaseException {
        if (!this.m_closed && !this.isThreadShuttingDown()) {
            ose.printStackTrace();
            System.err.println("PSEException: " + ose.toString());
        }
        throw new EDatabaseException();
    }

    public void handlePSEException(ObjectStoreException ose) throws EDatabaseException {
        if (this.DEBUG1) {
            ose.printStackTrace();
            boolean activeSession = this.m_session != null && this.m_session.isActive();
            this.debug("PSE exception; activeSession= " + activeSession + " " + Thread.currentThread() + " " + ose.toString());
        }
        if (!this.m_closed && this.m_dbLock.hasUpdateLock() && this.m_session != null && this.m_session.isActive()) {
            try {
                this.rollback();
            }
            catch (EDatabaseException eDatabaseException) {
                // empty catch block
            }
        }
        this.handlePSEExceptionInternal(ose);
    }

    @Override
    public String toString() {
        return "PSEDbContext: id= " + this.m_ident + " db= " + this.m_dbName;
    }
}

