/*
 * Decompiled with CFR 0.152.
 */
package progress.message.db.pse.util;

import progress.message.db.pse.IRWXLock;

public class RWXLock
implements IRWXLock {
    private Thread m_currentReader;
    private Thread m_currentWriter;
    private Thread m_currentExclusive;

    @Override
    public void acquireReadLock() {
        try {
            this.acquireReadLock(false);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void acquireReadLock(boolean interruptible) throws InterruptedException {
        Thread t = Thread.currentThread();
        if (this.m_currentReader == t) {
            return;
        }
        if (this.m_currentExclusive == t) {
            throw new IllegalMonitorStateException("DbLock.acquireReadLock: Exclusive Lock not released ");
        }
        boolean interrupted = false;
        while (this.m_currentReader != null || this.m_currentExclusive != null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                if (interruptible) {
                    throw e;
                }
                interrupted = true;
            }
        }
        this.m_currentReader = t;
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void acquireUpdateLock() {
        try {
            this.acquireUpdateLock(false);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void acquireUpdateLock(boolean interruptible) throws InterruptedException {
        Thread t = Thread.currentThread();
        if (this.m_currentWriter == t) {
            return;
        }
        if (this.m_currentExclusive == t) {
            throw new IllegalMonitorStateException("DbLock.acquireUpdateLock: Exclusive Lock not released ");
        }
        boolean interrupted = false;
        while (this.m_currentWriter != null || this.m_currentExclusive != null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                if (interruptible) {
                    throw e;
                }
                interrupted = true;
            }
        }
        this.m_currentWriter = t;
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public synchronized void acquireExclusiveLock() {
        boolean interrupted = false;
        Thread t = Thread.currentThread();
        if (this.m_currentExclusive == t) {
            return;
        }
        if (t == this.m_currentWriter) {
            while (this.m_currentReader != null || this.m_currentExclusive != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            this.m_currentExclusive = t;
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            return;
        }
        if (t == this.m_currentReader) {
            while (this.m_currentWriter != null || this.m_currentExclusive != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            this.m_currentExclusive = t;
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            return;
        }
        while (this.m_currentWriter != null || this.m_currentReader != null || this.m_currentExclusive != null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        this.m_currentExclusive = t;
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public synchronized void releaseReadLock() {
        Thread thisThread = Thread.currentThread();
        if (thisThread == this.m_currentExclusive) {
            throw new IllegalMonitorStateException("DbLock.releaseReadLock: Exclusive Lock not released ");
        }
        if (thisThread != this.m_currentReader) {
            throw new IllegalMonitorStateException("DbLock.releaseReadLock: currentThread not owner " + thisThread);
        }
        this.m_currentReader = null;
        this.notifyAll();
    }

    @Override
    public synchronized void releaseUpdateLock() {
        Thread thisThread = Thread.currentThread();
        if (thisThread == this.m_currentExclusive) {
            throw new IllegalMonitorStateException("DbLock.releaseUpdateLock: Exclusive Lock not released ");
        }
        if (thisThread != this.m_currentWriter) {
            throw new IllegalMonitorStateException("DbLock.releaseUpdateLock: currentThread not owner " + thisThread + " owner= " + this.m_currentWriter);
        }
        this.m_currentWriter = null;
        this.notifyAll();
    }

    @Override
    public synchronized void releaseExclusiveLock() {
        Thread thisThread = Thread.currentThread();
        if (thisThread != this.m_currentExclusive) {
            throw new IllegalMonitorStateException("DbLock.releaseExclusiveLock: currentThread not owner " + thisThread);
        }
        this.m_currentExclusive = null;
        this.notifyAll();
    }

    public boolean hasReadLock() {
        return Thread.currentThread() == this.m_currentReader;
    }

    @Override
    public boolean hasUpdateLock() {
        return Thread.currentThread() == this.m_currentWriter;
    }

    public boolean hasExclusiveLock() {
        return Thread.currentThread() == this.m_currentExclusive;
    }
}

