/*
 * Decompiled with CFR 0.152.
 */
package progress.message.dbq.pse;

import com.odi.ObjectStoreException;
import progress.message.db.EDatabaseException;
import progress.message.db.pse.PSEBrokerDb;
import progress.message.db.pse.util.OpContext;
import progress.message.dbq.IInitDbDBQ;
import progress.message.dbq.pse.DBQPSEBase;
import progress.message.dbsc.pse.pc.reg.PSEBrokerMode;
import progress.message.dbsc.pse.pc.reg.PSEBrokerState;
import progress.message.dbsc.pse.pc.reg.PSELogTime;
import progress.message.dbsc.pse.pc.reg.PSESyncPoint;

public class InitDbDBQImplPSE
extends DBQPSEBase
implements IInitDbDBQ {
    private PSEBrokerDb m_pseDb;

    public InitDbDBQImplPSE(PSEBrokerDb db) {
        super("InitDbDBQImplPSE ");
        this.m_pseDb = db;
    }

    @Override
    public void init() throws EDatabaseException {
        if (this.m_dbCtx == null) {
            this.m_dbCtx = this.m_pseDb.getCtx(1);
        }
        this.m_opCtxUpdate = new OpContext(2, this.m_dbCtx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeSecurityMode(byte mode) throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("initializeSecurityMode ");
        }
        this.acquireLock(this.m_opCtxUpdate);
        try {
            PSEBrokerMode bmode = (PSEBrokerMode)this.m_dbCtx.getDatabase().getRoot(this.m_pseDb.rootName("BrokerMode"));
            if (bmode == null) {
                bmode = new PSEBrokerMode(mode);
                this.m_dbCtx.getDatabase().setRoot(this.m_pseDb.rootName("BrokerMode"), (Object)bmode);
            } else {
                bmode.setSecurityMode(mode);
            }
            this.m_dbCtx.commit();
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        finally {
            this.releaseLock(this.m_opCtxUpdate);
        }
        if (DEBUG) {
            this.debug("initializeSecurityMode completed");
        }
    }

    @Override
    public void initializeSyncPoint() throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("initializeSyncPoint ");
        }
        this.acquireLock(this.m_opCtxUpdate);
        try {
            PSESyncPoint sp = (PSESyncPoint)this.m_dbCtx.getDatabase().getRoot(this.m_pseDb.rootName("SyncPoint"));
            if (sp == null) {
                sp = new PSESyncPoint(-1, 0L);
                this.m_dbCtx.getDatabase().setRoot(this.m_pseDb.rootName("SyncPoint"), (Object)sp);
            } else {
                sp.setFileNumber(-1);
                sp.setPos(0L);
            }
            this.m_dbCtx.commit();
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        finally {
            this.releaseLock(this.m_opCtxUpdate);
        }
        if (DEBUG) {
            this.debug("initializeSyncPoint completed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeLogTime(long time) throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("initializeLogTime ");
        }
        this.acquireLock(this.m_opCtxUpdate);
        try {
            PSELogTime logtm = (PSELogTime)this.m_dbCtx.getDatabase().getRoot(this.m_pseDb.rootName("LogTime"));
            if (logtm == null) {
                logtm = new PSELogTime(time);
                this.m_dbCtx.getDatabase().setRoot(this.m_pseDb.rootName("LogTime"), (Object)logtm);
            } else {
                logtm.setLogTime(time);
            }
            this.m_dbCtx.commit();
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        finally {
            this.releaseLock(this.m_opCtxUpdate);
        }
        if (DEBUG) {
            this.debug("initializeLogTime completed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeBrokerState(int state) throws EDatabaseException {
        boolean DEBUG = this.getDebug();
        if (DEBUG) {
            this.debug("initializeBrokerState ");
        }
        this.acquireLock(this.m_opCtxUpdate);
        try {
            PSEBrokerState bstate = (PSEBrokerState)this.m_dbCtx.getDatabase().getRoot(this.m_pseDb.rootName("BrokerState"));
            if (bstate == null) {
                bstate = new PSEBrokerState(state);
                this.m_dbCtx.getDatabase().setRoot(this.m_pseDb.rootName("BrokerState"), (Object)bstate);
            } else {
                bstate.setLastBrokerState(state);
            }
            this.m_dbCtx.commit();
        }
        catch (ObjectStoreException e) {
            this.m_dbCtx.handlePSEException(e);
        }
        finally {
            this.releaseLock(this.m_opCtxUpdate);
        }
        if (DEBUG) {
            this.debug("initializeBrokerState completed");
        }
    }
}

