/*
 * Decompiled with CFR 0.152.
 */
package progress.message.dbsc;

import progress.message.db.EBrokerNameTooLong;
import progress.message.db.EDatabaseException;
import progress.message.dbsc.ISchemaDef;
import progress.message.dbsc.IStatusListener;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;

public abstract class SchemaDefBase
extends DebugObject {
    private IStatusListener m_statusListener;
    protected ISchemaDef.LogTarget logTarget;

    public SchemaDefBase() {
        super(DebugState.GLOBAL_DEBUG_ON ? "SchemaDefBase " : null);
    }

    public void setStatusListener(IStatusListener list) {
        this.m_statusListener = list;
    }

    public IStatusListener getStatusListener() {
        return this.m_statusListener;
    }

    public abstract void createAll() throws EDatabaseException, EBrokerNameTooLong;

    public abstract void dropAll() throws EDatabaseException;

    public void upgradeAll(int dbvers) throws EDatabaseException {
    }

    protected void notifyTableCreate(String name) {
        if (this.m_statusListener != null) {
            this.m_statusListener.creatingSchemaObj(2, name, true);
        }
    }

    protected void notifyCreate(String name) {
        if (this.m_statusListener != null) {
            this.m_statusListener.creatingSchemaObj(1, name, true);
        }
    }

    protected void notifyIndexCreate(String name) {
        if (this.m_statusListener != null) {
            this.m_statusListener.creatingSchemaObj(3, name, true);
        }
    }

    protected void notifyIndexNotCreated(String name) {
        if (this.m_statusListener != null) {
            this.m_statusListener.creatingSchemaObj(3, name, false);
        }
    }

    public void compact(String wokringDir) throws EDatabaseException {
        throw new EDatabaseException("compaction not implemeneted");
    }

    public void stopCompact() {
    }

    public void setLogTarget(ISchemaDef.LogTarget logTarget) {
        this.logTarget = logTarget;
    }
}

