/*
 * Decompiled with CFR 0.152.
 */
package progress.message.dbsc.pse;

import com.odi.Database;
import com.odi.Session;
import com.odi.util.IndexIterator;
import com.odi.util.OSTreeSet;
import java.util.Iterator;
import progress.message.dbsc.pse.ILog;
import progress.message.dbsc.pse.pc.ptp.PSEQMessage;
import progress.message.dbsc.pse.pc.ptp.PSEQueue;
import progress.message.util.EAssertFailure;

public class DbSchemaCheckPtp {
    Database m_db;
    ILog m_logger;

    public DbSchemaCheckPtp(Database db, ILog log) {
        this.m_db = db;
        this.m_logger = log;
    }

    public void checkDb() {
        Session sess = Session.getCurrent();
        if (sess == null) {
            throw new EAssertFailure("No current Session");
        }
        if (!sess.inTransaction()) {
            throw new EAssertFailure("No current Transaction");
        }
        this.m_logger.logln("\nChecking Ptp Schema...");
        this.dumpPtpInfo();
        sess.currentTransaction().commit();
        this.m_logger.logln("\nCompleted Checking Ptp Schema.");
    }

    private void dumpPtpInfo() {
        OSTreeSet qm = (OSTreeSet)this.m_db.getRoot("QMessages");
        this.m_logger.logln("Number of ptp messages= " + qm.size());
        OSTreeSet ts = (OSTreeSet)this.m_db.getRoot("Queues");
        this.m_logger.logln("Number of queues= " + ts.size());
        IndexIterator qit = ts.primaryIndexIterator();
        while (qit.hasNext()) {
            PSEQueue q = (PSEQueue)qit.next();
            String qn = q.getQueueName();
            long ct = 0L;
            Iterator mit = q.getMessageIterator();
            boolean idsPerLine = false;
            long pers = 0L;
            long nonpers = 0L;
            while (mit.hasNext()) {
                ++ct;
                PSEQMessage m = (PSEQMessage)mit.next();
                if (m.getPersistent()) {
                    ++pers;
                } else {
                    ++nonpers;
                }
                long l = m.getMessageId();
            }
            this.m_logger.logln("\nQueue= " + qn + " count= " + ct + " pers= " + pers + " nonpers= " + nonpers);
        }
    }
}

