/*
 * Decompiled with CFR 0.152.
 */
package progress.message.dbsc.pse;

import com.odi.Database;
import com.odi.ObjectNotFoundException;
import com.odi.Session;
import com.odi.util.IndexIterator;
import com.odi.util.OSTreeSet;
import java.util.Iterator;
import progress.message.dbsc.pse.ILog;
import progress.message.dbsc.pse.pc.pubsub.IPSEClientUndelMsgs;
import progress.message.dbsc.pse.pc.pubsub.IPSECounters;
import progress.message.dbsc.pse.pc.pubsub.IPSEMessage;
import progress.message.dbsc.pse.pc.pubsub.IPSEMessages;
import progress.message.dbsc.pse.pc.pubsub.IPSEUndelMsg;
import progress.message.util.EAssertFailure;

public class DbSchemaCheckPubSub {
    Database m_db;
    ILog m_logger;

    public DbSchemaCheckPubSub(Database db, ILog log) {
        this.m_db = db;
        this.m_logger = log;
    }

    public void checkDb() {
        Session sess = Session.getCurrent();
        if (sess == null) {
            throw new EAssertFailure("No current Session");
        }
        if (!sess.inTransaction()) {
            throw new EAssertFailure("No current Transaction");
        }
        this.m_logger.logln("\nChecking PubSub Schema...");
        this.checkCounters();
        this.checkClientsWithUndel();
        this.checkMessagesUsingMidIndex();
        this.checkMessagesUsingJMSIdIndex();
        sess.currentTransaction().commit();
        this.m_logger.logln("\nCompleted Checking PubSub Schema.");
    }

    private void checkCounters() {
        this.m_logger.logln("\nChecking Counters");
        IPSECounters ctr = (IPSECounters)this.m_db.getRoot("Counters");
        if (ctr == null) {
            this.m_logger.logln("No Counters available");
            return;
        }
        long topicdbsize = ctr.getTopicDBSize();
        long maxseqno = ctr.getSequenceNumber();
        long maxId = ctr.getMessageId();
        this.m_logger.logln("TopicDbSize= " + ctr.getTopicDBSize());
        this.m_logger.logln("Seqno= " + ctr.getSequenceNumber());
        this.m_logger.logln("MsgId= " + ctr.getMessageId());
        long calcMsgSize = 0L;
        long calcMaxSeqno = 0L;
        long calcMaxMid = 0L;
        long calcUndelSize = 0L;
        long calcUndelCt = 0L;
        IPSEMessages msgs = (IPSEMessages)this.m_db.getRoot("Messages");
        IndexIterator it = msgs.getIterator();
        while (it.hasNext()) {
            it.advance();
            Long midL = null;
            IPSEMessage message = null;
            midL = (Long)it.currentKey();
            message = (IPSEMessage)it.currentValue();
            calcMsgSize += (long)(message.getMessageSize() + 124);
        }
        this.m_logger.logln("\nCalculated size of messages in IPSEMessages= " + calcMsgSize + " count= " + msgs.getCount());
        OSTreeSet ts = (OSTreeSet)this.m_db.getRoot("ClientUndelMsgs");
        IndexIterator itx = ts.getPrimaryIndex().iterator();
        while (itx.hasNext()) {
            itx.advance();
            Long cidL = (Long)itx.currentKey();
            IPSEClientUndelMsgs cmsgs = (IPSEClientUndelMsgs)itx.currentValue();
            calcUndelCt += (long)cmsgs.getUndelCount();
            calcUndelSize += (long)(cmsgs.getUndelCount() * 87);
        }
        this.m_logger.logln("\nCalculated size of UndelMsgs= " + calcUndelSize + " Ct of UndelMsgs= " + calcUndelCt);
        long calcDbSize = calcMsgSize + calcUndelSize;
        if (calcDbSize != topicdbsize) {
            this.m_logger.logln("*****TopicDbSize is incorrect reported size= " + topicdbsize + " calculated size= " + calcDbSize);
        } else {
            this.m_logger.logln("TopicDbSize is correct --- reported size = calculated size = " + topicdbsize);
        }
        this.m_logger.logln("Completed checking Counters");
    }

    private void checkMessagesUsingMidIndex() {
        IPSEMessages msgs = (IPSEMessages)this.m_db.getRoot("Messages");
        this.m_logger.logln("\nChecking Messages using MessageId index; size= " + msgs.getCount());
        Long lastMidL = null;
        IPSEMessage lastMessage = null;
        int ct = 0;
        int ctOk = 0;
        int ctErr = 0;
        int nullBody = 0;
        try {
            IndexIterator it = msgs.getIterator();
            while (it.hasNext()) {
                it.advance();
                Long midL = null;
                IPSEMessage message = null;
                boolean hasError = false;
                try {
                    ++ct;
                    midL = (Long)it.currentKey();
                    message = (IPSEMessage)it.currentValue();
                    try {
                        String string = message.getJMSMessageId();
                    }
                    catch (ObjectNotFoundException ex) {
                        hasError = true;
                        this.m_logger.logln("*****Error retrieving JMSMessageId for IPSEMessage; mid= " + midL);
                    }
                    Iterator recips = null;
                    int recipsError = 0;
                    int recipsCt = 0;
                    try {
                        recips = message.getRecipients();
                        if (recips != null) {
                            while (recips.hasNext()) {
                                ++recipsCt;
                                try {
                                    Long idL = (Long)recips.next();
                                    OSTreeSet clients = (OSTreeSet)this.m_db.getRoot("ClientUndelMsgs");
                                    IPSEClientUndelMsgs cmsgs = (IPSEClientUndelMsgs)clients.getFromPrimaryIndex((Object)idL);
                                    if (cmsgs == null) {
                                        hasError = true;
                                        this.m_logger.logln("*****No PSEClientUndelMsgs for PSEMessage recipient; mid= " + midL + " recip= " + idL);
                                        continue;
                                    }
                                    IPSEUndelMsg undelmsg = cmsgs.getUndelMsg(midL);
                                    if (undelmsg != null) continue;
                                    hasError = true;
                                    this.m_logger.logln("*****No PSEUndelMsg for PSEMessage recipient; mid= " + midL + " recip= " + idL);
                                }
                                catch (ObjectNotFoundException ex) {
                                    hasError = true;
                                    this.m_logger.logln("*****Error retrieving recips for PSEMessage; mid= " + midL + " ct= " + ct + " recipsErrors= " + ++recipsError + " recipsCt= " + recipsCt);
                                }
                            }
                        }
                    }
                    catch (ObjectNotFoundException ex) {
                        hasError = true;
                        this.m_logger.logln("*****Error retrieving recipients  for PSEMessage; ct= " + ct + " mid= " + midL + " lastMid= " + lastMidL);
                    }
                    if (!message.hasBody()) {
                        ++nullBody;
                        this.m_logger.logln("*****PSEMessage has null body; mid= " + midL + " recipsCt= " + recipsCt);
                    }
                    if (hasError) {
                        ++ctErr;
                    } else {
                        lastMidL = midL;
                        lastMessage = message;
                        ++ctOk;
                    }
                }
                catch (ObjectNotFoundException ex) {
                    ex.printStackTrace();
                    this.m_logger.logln("*****Error retrieving PSEMessage; ct= " + ct + " thisMid= " + midL + " lastMid= " + lastMidL);
                    ++ctErr;
                }
                if (ct <= 0 || ct % 1000 != 0) continue;
                this.m_logger.logln("Processed " + ct + " PSEMessage; totalCt= " + msgs.getCount());
            }
        }
        catch (ObjectNotFoundException ex) {
            ex.printStackTrace();
            this.m_logger.logln("*****Error during Iteration " + ex.getMessage());
        }
        this.m_logger.logln("Completed checking Messages using MessageId index; totct = " + ct + " ctOk= " + ctOk + " ctErr= " + ctErr + " ctNullBody= " + nullBody);
    }

    private void checkMessagesUsingJMSIdIndex() {
        IPSEMessages allMsgs = (IPSEMessages)this.m_db.getRoot("Messages");
        this.m_logger.logln("\nChecking Messages using JMSMessageId index");
        String lastJMSId = null;
        long lastMid = -1L;
        IPSEMessage lastMessage = null;
        int ct = 0;
        int ctOk = 0;
        int ctErr = 0;
        try {
            IndexIterator it = allMsgs.getJMSIdIterator(null);
            while (it.hasNext()) {
                it.advance();
                String JMSId = null;
                IPSEMessage message = null;
                try {
                    ++ct;
                    JMSId = (String)it.currentKey();
                    message = (IPSEMessage)it.currentValue();
                    long mid = message.getMessageId();
                    if (lastJMSId != null && JMSId.equals(lastJMSId)) {
                        this.m_logger.logln("*****Duplicate JMSId= " + JMSId + " ct= " + ct + " thisMid= " + mid + " lastMid= " + lastMid);
                    }
                    lastJMSId = JMSId;
                    lastMid = mid;
                    lastMessage = message;
                    ++ctOk;
                }
                catch (ObjectNotFoundException ex) {
                    this.m_logger.logln("*****Error retrieving PSEMessage using JMSMsgId Index; ct= " + ct + " thisJMSId= " + JMSId + " lastJMSid= " + lastJMSId);
                    ++ctErr;
                }
            }
        }
        catch (ObjectNotFoundException ex) {
            ex.printStackTrace();
            this.m_logger.logln("*****Error during Iteration " + ex.getMessage());
        }
        this.m_logger.logln("Completed checking Messages using JMSMessageId index; totct = " + ct + " ctOk= " + ctOk + " ctErr= " + ctErr);
    }

    private void checkClientsWithUndel() {
        OSTreeSet ts = (OSTreeSet)this.m_db.getRoot("ClientUndelMsgs");
        this.m_logger.logln("\nChecking Clients with UndelMsgs; ClientCount = " + ts.size());
        Long lastCidL = null;
        IPSEClientUndelMsgs lastCmsgs = null;
        int ct = 0;
        int ctOk = 0;
        int ctErr = 0;
        try {
            IndexIterator it = ts.getPrimaryIndex().iterator();
            while (it.hasNext()) {
                it.advance();
                Long cidL = null;
                IPSEClientUndelMsgs cmsgs = null;
                try {
                    ++ct;
                    cidL = (Long)it.currentKey();
                    cmsgs = (IPSEClientUndelMsgs)it.currentValue();
                    lastCidL = cidL;
                    lastCmsgs = cmsgs;
                    ++ctOk;
                    this.checkUndelMsgs(cmsgs);
                }
                catch (ObjectNotFoundException ex) {
                    this.m_logger.logln("*****Error retrieving PSEClientUndelMsgs; ct= " + ct + " thisCid= " + cidL + " thisPSEClientUndelMsgs= " + cmsgs + " lastCid= " + lastCidL + " lastPSEClientUndelMsgs= " + lastCmsgs);
                    ++ctErr;
                }
            }
        }
        catch (ObjectNotFoundException ex) {
            ex.printStackTrace();
            this.m_logger.logln("*****Error during Iteration " + ex.getMessage());
        }
        this.m_logger.logln("\nCompleted checking Clients with UndelMsgs; totct = " + ct + " ctOk= " + ctOk + " ctErr= " + ctErr);
    }

    private void checkUndelMsgs(IPSEClientUndelMsgs cmsgs) {
        this.m_logger.logln("\nChecking UndelMsgs for Client cid= " + cmsgs.getClientId() + " count = " + cmsgs.getUndelCount() + " size= " + cmsgs.getTotalSize());
        Long lastMidL = null;
        IPSEUndelMsg lastUndel = null;
        int ct = 0;
        int ctOk = 0;
        int ctErr = 0;
        try {
            OSTreeSet ts = cmsgs.getAllUndel();
            IndexIterator it = ts.getPrimaryIndex().iterator();
            while (it.hasNext()) {
                it.advance();
                Long midL = null;
                IPSEUndelMsg undel = null;
                try {
                    ++ct;
                    midL = (Long)it.currentKey();
                    undel = (IPSEUndelMsg)it.currentValue();
                    IPSEMessage msg = null;
                    try {
                        msg = undel.getMessage();
                        int size = msg.getMessageSize();
                        ++ctOk;
                    }
                    catch (ObjectNotFoundException ex) {
                        this.m_logger.logln("*****Error retrieving PSEMessage from PSEUndelMsg; ct= " + ct + " Mid= " + midL + " PSEUndelMsg= " + undel);
                        it.remove();
                        ++ctErr;
                    }
                    lastMidL = midL;
                    lastUndel = undel;
                }
                catch (ObjectNotFoundException ex) {
                    this.m_logger.logln("*****Error retrieving PSEUndelMsg; ct= " + ct + " thisMid= " + midL + " thisPSEUndelMsg= " + undel + " lastMid= " + lastMidL);
                    ++ctErr;
                }
            }
        }
        catch (ObjectNotFoundException ex) {
            ex.printStackTrace();
            this.m_logger.logln("*****Error during Iteration " + ex.getMessage());
        }
        this.m_logger.logln("Completed checking UndelMsgs for cid= " + cmsgs.getClientId() + " totct= " + ct + " ctOk= " + ctOk + " ctErr= " + ctErr);
    }
}

