/*
 * Decompiled with CFR 0.152.
 */
package progress.message.dbsc.pse.pc.ptp;

import com.odi.ClassInfo;
import com.odi.Database;
import com.odi.GenericObject;
import com.odi.IPersistent;
import com.odi.IPersistentHooks;
import com.odi.ObjectStore;
import com.odi.Placement;
import com.odi.imp.ObjectReference;
import com.odi.util.OSTreeSet;
import java.util.Iterator;
import progress.message.dbsc.pse.pc.ptp.PSEQMessage;
import progress.message.util.EAssertFailure;

public class PSEQueue
implements IPersistent,
IPersistentHooks {
    private String _QueueName;
    private OSTreeSet _QMessages;
    private static Class msgClass;
    protected transient ObjectReference ODIref;
    public transient byte ODIObjectState;
    static ClassInfo myOdiClassInfoInstance;

    public PSEQueue(String name, Database db) {
        this._QueueName = new String(name);
        this._QMessages = new OSTreeSet((Placement)db, msgClass, "getMessageId()");
    }

    public String getQueueName() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._QueueName;
    }

    public PSEQMessage getMessage(long id) {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        Long key = new Long(id);
        return (PSEQMessage)this._QMessages.getFromPrimaryIndex((Object)key);
    }

    public boolean addMessage(PSEQMessage msg) {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._QMessages.add((Object)msg);
    }

    public boolean removeMessage(PSEQMessage msg) {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._QMessages.remove((Object)msg);
    }

    public Iterator getMessageIterator() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._QMessages.iterator();
    }

    public void preDestroyPersistent() {
        PSEQueue pSEQueue;
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        if (!this._QMessages.isEmpty()) {
            new EAssertFailure("Destroying non-empty PSEQueue " + this._QueueName).printStackTrace();
        }
        ObjectStore.destroy((IPersistent)this._QMessages);
        ObjectStore.destroy((Object)this._QueueName);
        if (((pSEQueue = this).ODIObjectState & 2) != 0) {
            pSEQueue = pSEQueue;
            ObjectStore.dirty((IPersistent)pSEQueue);
        }
        pSEQueue._QMessages = null;
        this._QueueName = null;
    }

    public String toStringAll() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        StringBuffer buf = new StringBuffer("PSEQueue: ");
        buf.append("\tName: " + this.getQueueName());
        buf.append("\tMsgCount: " + this._QMessages.size());
        return buf.toString();
    }

    static {
        myOdiClassInfoInstance = PSEQueue.getClassInfoInstance();
        String msgClassName = "progress.message.dbsc.pse.pc.ptp.PSEQMessage";
        try {
            msgClass = Class.forName(msgClassName);
        }
        catch (ClassNotFoundException cnfe) {
            new EAssertFailure("Class Not Found: " + msgClassName).printStackTrace();
        }
    }

    public ObjectReference ODIgetRef() {
        return this.ODIref;
    }

    public void ODIsetRef(ObjectReference objectReference) {
        this.ODIref = objectReference;
    }

    public byte ODIgetState() {
        return this.ODIObjectState;
    }

    public void ODIsetState(byte by) {
        this.ODIObjectState = by;
    }

    protected synchronized Object clone() throws CloneNotSupportedException {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        ((PSEQueue)super.clone()).ODIref = null;
        ((PSEQueue)super.clone()).ODIObjectState = 0;
        return (PSEQueue)super.clone();
    }

    public void postInitializeContents() {
    }

    public void preFlushContents() {
    }

    public void preClearContents() {
    }

    public void initializeContents(GenericObject genericObject) {
        ClassInfo classInfo = myOdiClassInfoInstance;
        this._QueueName = genericObject.getStringField(1, classInfo);
        this._QMessages = (OSTreeSet)genericObject.getClassField(2, classInfo);
    }

    public void flushContents(GenericObject genericObject) {
        ClassInfo classInfo = myOdiClassInfoInstance;
        genericObject.setStringField(1, this._QueueName, classInfo);
        genericObject.setClassField(2, (Object)this._QMessages, classInfo);
    }

    public void clearContents() {
        this._QueueName = null;
        this._QMessages = null;
    }

    public PSEQueue(ClassInfo classInfo) {
    }

    private static final ClassInfo getClassInfoInstance() {
        return ClassInfo.get(PSEQueue.class);
    }
}

