/*
 * Decompiled with CFR 0.152.
 */
package progress.message.dbsc.sql;

import java.util.Vector;
import progress.message.db.EBrokerNameTooLong;
import progress.message.db.EDatabaseException;
import progress.message.db.jdbc.JDBCDatabase;
import progress.message.dbsc.ISchemaDef;
import progress.message.dbsc.SchemaDefBase;
import progress.message.dbsc.sql.ITableDef;

public class DbSchemaDD
extends SchemaDefBase
implements ISchemaDef {
    String m_tableName;
    JDBCDatabase m_db;
    public String intType;
    public String timeType;
    public String varchar64;
    public String varchar254;

    public DbSchemaDD(JDBCDatabase db, String tableName) {
        this.m_tableName = tableName;
        this.m_db = db;
        this.timeType = this.m_db.makeType(93);
        this.intType = this.m_db.makeType(4);
        this.varchar64 = db.makeType(12, 64);
        this.varchar254 = db.makeType(12, 254);
    }

    public ITableDef getTableDef() throws EDatabaseException {
        return new TableDefDD();
    }

    @Override
    public void createAll() throws EDatabaseException, EBrokerNameTooLong {
        TableDefDD td = new TableDefDD();
        td.createTable();
        td.createIndexes();
    }

    @Override
    public void dropAll() {
        TableDefDD td = new TableDefDD();
        td.drop();
    }

    @Override
    public void createDD() throws EDatabaseException, EBrokerNameTooLong {
        this.createAll();
    }

    @Override
    public void dropDD() {
        this.dropAll();
    }

    @Override
    public void upgradeDD(int dbvers) throws EDatabaseException {
        this.upgradeAll(dbvers);
    }

    class TableDefDD
    implements ITableDef {
        TableDefDD() {
        }

        @Override
        public void createTable() throws EDatabaseException, EBrokerNameTooLong {
            DbSchemaDD.this.notifyTableCreate(DbSchemaDD.this.m_tableName);
            DbSchemaDD.this.m_db.createTable(DbSchemaDD.this.m_tableName, this.getColumns());
        }

        @Override
        public String getName() {
            return DbSchemaDD.this.m_tableName;
        }

        @Override
        public void drop() {
            DbSchemaDD.this.m_db.dropTable(DbSchemaDD.this.m_tableName);
            DbSchemaDD.this.m_db.dropIndex(DbSchemaDD.this.m_tableName + "Idx", DbSchemaDD.this.m_tableName);
        }

        @Override
        public void createIndexes() throws EDatabaseException {
            DbSchemaDD.this.notifyIndexCreate(DbSchemaDD.this.m_tableName + "Idx");
            String[] columns = new String[]{"CommitId"};
            boolean created = DbSchemaDD.this.m_db.createIndex(DbSchemaDD.this.m_tableName + "Idx", DbSchemaDD.this.m_tableName, columns);
            if (!created) {
                DbSchemaDD.this.notifyIndexNotCreated(DbSchemaDD.this.m_tableName + "Idx");
            }
        }

        @Override
        public Vector getColumns() {
            Vector<Object> columns = new Vector<Object>();
            columns.addElement(DbSchemaDD.this.m_db.makeColumnDef("CommitId", DbSchemaDD.this.varchar64, "not null primary key"));
            columns.addElement(DbSchemaDD.this.m_db.makeColumnDef("endOfLife", DbSchemaDD.this.timeType, "not null"));
            columns.addElement(DbSchemaDD.this.m_db.makeColumnDef("CreationTime", DbSchemaDD.this.timeType, "not null"));
            columns.addElement(DbSchemaDD.this.m_db.makeColumnDef("State", DbSchemaDD.this.intType, "not null"));
            columns.addElement(DbSchemaDD.this.m_db.makeColumnDef("ChannelID", DbSchemaDD.this.varchar254, "not null"));
            return columns;
        }
    }
}

