/*
 * Decompiled with CFR 0.152.
 */
package progress.message.dd;

import progress.message.client.EGeneralException;
import progress.message.db.EDatabaseException;
import progress.message.dd.ExecuteThread;
import progress.message.dd.NoDupDetectDb;
import progress.message.dd.NoDupDetectDbConnection;

public final class Cleaner {
    private Thread mThread;
    private long mInterval;
    private boolean mFinish = false;
    private NoDupDetectDbConnection mNdConnection;

    public Cleaner(long interval) throws EDatabaseException, EGeneralException {
        this.mInterval = interval;
        this.mNdConnection = NoDupDetectDb.getConnection();
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                while (Cleaner.this.mThread != null) {
                    new ExecuteThread(Cleaner.this.mNdConnection);
                    try {
                        Thread.sleep(Cleaner.this.mInterval * 1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!Cleaner.this.mFinish) continue;
                    new ExecuteThread(Cleaner.this.mNdConnection);
                    break;
                }
            }
        };
        this.mThread = new Thread(runner, "Duplicate Transaction Detection cleaner thread");
        this.mThread.start();
    }

    public synchronized void finish() {
        this.mFinish = true;
        this.mThread.interrupt();
    }
}

