/*
 * Decompiled with CFR 0.152.
 */
package progress.message.dd;

import java.text.MessageFormat;
import java.util.Properties;
import progress.message.client.EGeneralException;
import progress.message.db.DBFactory;
import progress.message.db.Db;
import progress.message.db.EDatabaseException;
import progress.message.db.EInvalidConfiguration;
import progress.message.dd.Cleaner;
import progress.message.dd.NoDupDetectDbAdmin;
import progress.message.dd.NoDupDetectDbConnection;
import progress.message.dd.prAccessor;
import progress.message.util.DebugState;
import progress.message.util.server.OStream;
import progress.message.zclient.DebugObject;

public final class NoDupDetectDb
extends DebugObject {
    public static final int COMMIT_ID_LEN = 64;
    public static final int CHANNEL_ID_LEN = 254;
    private static NoDupDetectDbAdmin mAdmin;
    private static volatile NoDupDetectDbConnection mConnection;
    private static Db mDb;
    private static Db mBrokerDb;
    private static boolean mInitialized;
    private static Properties mDbConfigProperties;
    private static long mDefaultLifeSpan;
    private static long mCleanupInterval;
    private static boolean mEnabled;
    private static volatile Cleaner mCleaner;
    private static boolean mFTShared;

    public static synchronized void init(Properties props, Db brokerDb) throws EInvalidConfiguration {
        if (DebugState.GLOBAL_DEBUG_ON) {
            NoDupDetectDb.class_debug("NoDupDetectDb", "Starting");
        }
        mInitialized = true;
        mAdmin = null;
        mConnection = null;
        mDb = null;
        mCleaner = null;
        mBrokerDb = brokerDb;
        mDbConfigProperties = props;
        mEnabled = false;
        Boolean indexedTxnEnabled = (Boolean)props.get("INDEXED_TXN");
        if (indexedTxnEnabled != null) {
            mEnabled = indexedTxnEnabled;
        }
        if (DebugState.GLOBAL_DEBUG_ON) {
            NoDupDetectDb.class_debug("NoDupDetectDb", "Enabled= " + mEnabled);
        }
        mDefaultLifeSpan = 86400L;
        Long defaultLifespan = (Long)props.get("INDEXED_TXN_DEFAULT_LIFESPAN");
        if (defaultLifespan != null) {
            try {
                mDefaultLifeSpan = defaultLifespan;
                if (mDefaultLifeSpan <= 0L) {
                    throw new EInvalidConfiguration("");
                }
            }
            catch (NumberFormatException nfe) {
                OStream.println(prAccessor.getString("STR001"));
                throw new EInvalidConfiguration("");
            }
        }
        if (DebugState.GLOBAL_DEBUG_ON) {
            NoDupDetectDb.class_debug("NoDupDetectDb", "mDefaultLifeSpan= " + mDefaultLifeSpan);
        }
        mCleanupInterval = 86400L;
        Long cleanupInterval = (Long)props.get("INDEXED_TXN_CLEANUP_INTERVAL");
        if (cleanupInterval != null) {
            try {
                mCleanupInterval = cleanupInterval;
                if (mCleanupInterval == 0L) {
                    mCleanupInterval = 86400L;
                }
            }
            catch (NumberFormatException nfe) {
                OStream.println(prAccessor.getString("STR002"));
                throw nfe;
            }
        }
        if (DebugState.GLOBAL_DEBUG_ON) {
            NoDupDetectDb.class_debug("NoDupDetectDb", "mCleanupInterval= " + mCleanupInterval);
        }
        String txnTableName = props.getProperty("INDEXED_TXN_TABLE_NAME");
        if (DebugState.GLOBAL_DEBUG_ON) {
            NoDupDetectDb.class_debug("NoDupDetectDb", "txnTableName= " + txnTableName);
        }
        if (txnTableName != null && !txnTableName.trim().equals("") && txnTableName.length() > Db.getMaxNameLength()) {
            Object[] parms = new Object[]{txnTableName};
            String msg = MessageFormat.format(prAccessor.getString("STR004"), parms);
            OStream.println(msg);
            throw new EInvalidConfiguration(msg);
        }
        mFTShared = false;
        Boolean FTShared = (Boolean)props.get("INDEXED_TXN_DB_SHARED");
        if (FTShared != null) {
            mFTShared = FTShared;
        }
        if (DebugState.GLOBAL_DEBUG_ON) {
            NoDupDetectDb.class_debug("NoDupDetectDb", "mFTShared= " + mFTShared);
        }
    }

    public static synchronized NoDupDetectDbAdmin getAdmin(Properties props, Db brokerDb) throws IllegalStateException, EDatabaseException, EGeneralException {
        if (DebugState.GLOBAL_DEBUG_ON) {
            NoDupDetectDb.class_debug("NoDupDetectDb", "getAdmin starting");
        }
        NoDupDetectDb.init(props, brokerDb);
        NoDupDetectDb.checkState();
        if (mAdmin == null) {
            if (mDb == null) {
                NoDupDetectDb.createDb();
                if (mBrokerDb != mDb) {
                    mBrokerDb.close();
                }
                if (DebugState.GLOBAL_DEBUG_ON) {
                    NoDupDetectDb.class_debug("NoDupDetectDb", "getAdmin createdDb; txnTableName= " + mDb.getDDName());
                }
            }
            mAdmin = new NoDupDetectDbAdmin(mDb);
        }
        return mAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static NoDupDetectDbConnection getConnection() throws IllegalStateException, EDatabaseException, EGeneralException {
        NoDupDetectDb.checkState();
        if (mConnection == null) {
            Class<NoDupDetectDb> clazz = NoDupDetectDb.class;
            // MONITORENTER : progress.message.dd.NoDupDetectDb.class
            if (mConnection == null) {
                if (DebugState.GLOBAL_DEBUG_ON) {
                    NoDupDetectDb.class_debug("NoDupDetectDb", "getConnection: initializing NoDupDetectDbConnection ");
                }
                if (mDb == null) {
                    NoDupDetectDb.createDb();
                    mDb.start();
                    if (DebugState.GLOBAL_DEBUG_ON) {
                        NoDupDetectDb.class_debug("NoDupDetectDb", "getConnection: created Db ");
                    }
                }
                if (!mDb.seemsConfiguredDD()) {
                    if (!DebugState.GLOBAL_DEBUG_ON) throw new EDatabaseException(prAccessor.getString("STR005"));
                    NoDupDetectDb.class_debug("NoDupDetectDb", "getConnection: Db not configured for DD; throwing exception");
                    throw new EDatabaseException(prAccessor.getString("STR005"));
                }
                mConnection = new NoDupDetectDbConnection(mDb);
                if (DebugState.GLOBAL_DEBUG_ON) {
                    NoDupDetectDb.class_debug("NoDupDetectDb", "getConnection: initialized NoDupDetectDbConnection ");
                }
            }
            // MONITOREXIT : clazz
        }
        if (!DebugState.GLOBAL_DEBUG_ON) return mConnection;
        NoDupDetectDb.class_debug("NoDupDetectDb", "getConnection:  returning NoDupDetectDbConnection ");
        return mConnection;
    }

    public static void startCleaner() throws IllegalStateException, EDatabaseException, EGeneralException {
        if (DebugState.GLOBAL_DEBUG_ON) {
            NoDupDetectDb.class_debug("NoDupDetectDb", "startCleaner: creating Cleaner ");
        }
        NoDupDetectDb.checkState();
        mCleaner = new Cleaner(mCleanupInterval);
    }

    public static void stopCleaner() {
        mCleaner.finish();
    }

    private static void checkState() throws IllegalStateException {
        if (!mInitialized) {
            throw new IllegalStateException("NoDupDetectDb class instance must be initialized before used!");
        }
    }

    private static synchronized void createDb() throws EDatabaseException, EGeneralException {
        mDb = DBFactory.createDupDetectDb(mDbConfigProperties, mBrokerDb);
    }

    public static boolean isEnabled() {
        return mEnabled;
    }

    public static long getDefaultLifeSpan() {
        return mDefaultLifeSpan * 1000L;
    }

    public static boolean isFTShared() {
        return mFTShared;
    }

    public static void clearTransactionTable() throws EGeneralException {
        if (DebugState.GLOBAL_DEBUG_ON) {
            NoDupDetectDb.class_debug("NoDupDetectDb", "clearTransactionTable starting");
        }
        if (NoDupDetectDb.isEnabled()) {
            NoDupDetectDb.getConnection().deleteAll();
        }
        if (DebugState.GLOBAL_DEBUG_ON) {
            NoDupDetectDb.class_debug("NoDupDetectDb", "clearTransactionTable completed");
        }
    }

    static {
        mInitialized = false;
        mDefaultLifeSpan = 86400L;
        mCleanupInterval = 86400L;
        mEnabled = false;
        mFTShared = false;
    }
}

