/*
 * Decompiled with CFR 0.152.
 */
package progress.message.ft;

import java.util.ArrayList;
import java.util.List;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.Config;
import progress.message.client.EGeneralException;
import progress.message.db.EDatabaseException;
import progress.message.dbsc.data.IDbDupDetectData;
import progress.message.dd.NoDupDetectDb;
import progress.message.dd.NoDupDetectDbConnection;
import progress.message.ft.DynamicSyncManager;
import progress.message.ft.FTMgramFactory;
import progress.message.ft.ReplicationManager;
import progress.message.msg.IMgram;
import progress.message.zclient.DebugThread;

public class DupDetectionDynSyncer
extends DebugThread {
    private DynamicSyncManager m_dsm;
    private int m_role = -1;
    private static final int RECORDS_TO_REQUEST = 10;

    public DupDetectionDynSyncer(DynamicSyncManager dsm, int role) {
        super("DupDetectionDynSyncer");
        this.m_dsm = dsm;
        this.m_role = role;
    }

    @Override
    public void threadMain() {
        try {
            if (this.DEBUG) {
                this.debug("DupDetectionDynSyncer running... m_role: " + this.m_role);
            }
            if (this.m_role == 1) {
                if (NoDupDetectDb.isEnabled() && !NoDupDetectDb.isFTShared()) {
                    this.performActiveSync();
                } else {
                    IMgram replicateOp = FTMgramFactory.createReplicateDupDetectOp(null, true);
                    AgentRegistrar.getAgentRegistrar().getReplicationManager().replicateMgram(replicateOp);
                }
                if (this.DEBUG) {
                    this.debug("get and send database info to be replicated on the standby");
                }
                if (this.DEBUG) {
                    this.debug("DupDetectionDynSyncer exiting...");
                }
                this.m_dsm.setStatus(1);
            } else if (this.m_role == 2 && this.DEBUG) {
                this.debug("receive and process database info replicated from active");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performActiveSync() throws InterruptedException {
        NoDupDetectDbConnection ndd = null;
        ReplicationManager mgr = AgentRegistrar.getAgentRegistrar().getReplicationManager();
        try {
            ndd = NoDupDetectDb.getConnection();
            String[] limits = ndd.startDynamicSync();
            if (limits == null) {
                IMgram replicateOp = FTMgramFactory.createReplicateDupDetectOp(null, true);
                mgr.replicateMgram(replicateOp);
                if (this.CALLBACK) {
                    this.callback("Sent Dup Detect Op", 1, null);
                }
                return;
            }
            try {
                String minimum = limits[0];
                String maximum = limits[1];
                boolean complete = false;
                int requestCount = 10;
                boolean inclusive = true;
                do {
                    ReplicationManager.ReplicationJob rj = null;
                    NoDupDetectDbConnection noDupDetectDbConnection = ndd;
                    synchronized (noDupDetectDbConnection) {
                        ArrayList recordsToReplicate = new ArrayList();
                        int replicationSize = 0;
                        do {
                            List records;
                            boolean bl = complete = (records = ndd.getDupDetectData(minimum, maximum, requestCount, inclusive)).size() < requestCount;
                            if (this.CALLBACK) {
                                this.callback("Initial Dup Detect Online Sync snapshot taken", 3, new Boolean(complete));
                            }
                            recordsToReplicate.addAll(records);
                            replicationSize += FTMgramFactory.getDupDetectSize(records);
                            if (complete) continue;
                            inclusive = false;
                            IDbDupDetectData data = (IDbDupDetectData)records.get(records.size() - 1);
                            minimum = data.getCommitID();
                        } while (!complete && replicationSize < Config.REPLICATION_CHUNK_SIZE);
                        if (!complete) {
                            IDbDupDetectData data = (IDbDupDetectData)recordsToReplicate.get(recordsToReplicate.size() - 1);
                            minimum = data.getCommitID();
                            ndd.setCurrentReplicationCommitId(minimum);
                        }
                        IMgram replicateOp = FTMgramFactory.createReplicateDupDetectOp(recordsToReplicate, complete);
                        rj = mgr.replicateMgramSynchronouslyNoWait(replicateOp);
                        if (this.CALLBACK) {
                            this.callback("Sent Dup Detect Op", 0, null);
                        }
                    }
                    if (rj == null) continue;
                    rj.join();
                    rj = null;
                } while (!complete);
            }
            finally {
                ndd.completeDynamicSync();
            }
        }
        catch (EDatabaseException e) {
            IMgram replicateOp = FTMgramFactory.createReplicateDupDetectOp(null, true);
            mgr.replicateMgram(replicateOp);
            return;
        }
        catch (EGeneralException e) {
            if (!Broker.isInShutdown()) {
                e.printStackTrace();
            }
            return;
        }
    }
}

