/*
 * Decompiled with CFR 0.152.
 */
package progress.message.ft;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.Config;
import progress.message.broker.IReplicateableSaverOp;
import progress.message.broker.QMsgSaverOp;
import progress.message.broker.QueueMsgSaver;
import progress.message.dbq.IPtpDBQ;
import progress.message.ft.DynamicSyncManager;
import progress.message.ft.ReplicationManager;
import progress.message.msg.IMgram;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;

public class DynamicSyncDBQMsgsTracker
extends DebugObject {
    private int m_syncBatchSize;
    private DynamicSyncManager m_dsm = null;
    private QueueMsgSaver m_qmsgSaver = null;
    private long m_activeMax = -1L;
    private long m_activeMin = -1L;
    private long m_standbyMax = -1L;
    private long m_standbyMin = -1L;
    private long m_current = -1L;
    private long m_lastReplicated = -1L;
    private MessageSet m_MTD = null;
    private MessageSet m_MTR = null;
    private MessageSet m_inDoubt = null;
    private SortedSet m_DNR = new TreeSet();
    private boolean DEBUG1;
    private long m_currentMax = -1L;
    static final int MTD = 0;
    static final int MTR = 1;
    static final int IN_DOUBT = 2;

    DynamicSyncDBQMsgsTracker(DynamicSyncManager dsm) {
        super(DebugState.GLOBAL_DEBUG_ON ? "DynamicSyncDBQMsgsTracker" : null);
        this.m_dsm = dsm;
        this.m_qmsgSaver = AgentRegistrar.getAgentRegistrar().getQueueMsgSaver();
        this.m_syncBatchSize = Math.max(1000, Config.REPLICATION_CHUNK_SIZE / 8);
        this.DEBUG1 = this.checkDebugFlags(64);
        if (this.DEBUG1) {
            this.debug("created; syncBatchSize= " + this.m_syncBatchSize);
        }
    }

    void setActiveTrackings(long max, long min) {
        this.m_activeMax = max;
        this.m_activeMin = min;
    }

    void setStandbyTrackings(long max, long min) {
        this.m_standbyMax = max;
        this.m_standbyMin = min;
    }

    long getActiveMax() {
        return this.m_activeMax;
    }

    long getActiveMin() {
        return this.m_activeMin;
    }

    long getStandbyMax() {
        return this.m_standbyMax;
    }

    long getStandbyMin() {
        return this.m_standbyMin;
    }

    void sort() {
        if (this.m_standbyMax == -1L && this.m_standbyMin == -1L) {
            this.m_MTR = this.checkMaxMinAndCreateMessageSet(this.m_activeMax, this.m_activeMin, this.m_MTR, 1);
        } else if (this.m_activeMax == -1L && this.m_activeMin == -1L) {
            this.m_MTD = this.checkMaxMinAndCreateMessageSet(this.m_standbyMax, this.m_standbyMin, this.m_MTD, 0);
        } else if (this.m_activeMin > this.m_standbyMax || this.m_activeMax < this.m_standbyMin) {
            this.m_MTD = new MessageSet(0, this.m_standbyMax, this.m_standbyMin);
            this.m_MTR = new MessageSet(1, this.m_activeMax, this.m_activeMin);
        } else if (this.m_activeMin <= this.m_standbyMin && this.m_activeMax >= this.m_standbyMax) {
            this.m_inDoubt = new MessageSet(2, this.m_standbyMax, this.m_standbyMin);
            this.m_MTR = this.createMessageSet(this.m_standbyMin, this.m_activeMin, this.m_MTR, 1);
            if (this.m_activeMax > this.m_standbyMax) {
                if (this.getMTR() == null) {
                    this.m_MTR = new MessageSet(1, this.m_activeMax, this.m_standbyMax + 1L);
                } else {
                    this.m_MTR.addNext(new MessageSet(1, this.m_activeMax, this.m_standbyMax + 1L));
                }
            }
        } else if (this.m_standbyMin <= this.m_activeMin && this.m_standbyMax >= this.m_activeMax) {
            this.m_inDoubt = new MessageSet(2, this.m_activeMax, this.m_activeMin);
            if (this.m_standbyMin < this.m_activeMin) {
                this.m_MTD = new MessageSet(0, this.m_activeMin - 1L, this.m_standbyMin);
            }
            if (this.m_standbyMax > this.m_activeMax) {
                if (this.getMTD() == null) {
                    this.m_MTD = new MessageSet(0, this.m_standbyMax, this.m_activeMax + 1L);
                } else {
                    this.m_MTD.addNext(new MessageSet(0, this.m_standbyMax, this.m_activeMax + 1L));
                }
            }
        } else if (this.m_activeMin >= this.m_standbyMin && this.m_activeMax >= this.m_standbyMax) {
            this.m_inDoubt = new MessageSet(2, this.m_standbyMax, this.m_activeMin);
            this.m_MTR = this.validateAndCreateMessageSet(this.m_activeMax, this.m_standbyMax, this.m_MTR, 1);
            this.m_MTD = this.createMessageSet(this.m_activeMin, this.m_standbyMin, this.m_MTD, 0);
        } else if (this.m_activeMin <= this.m_standbyMin && this.m_activeMax <= this.m_standbyMax) {
            this.m_inDoubt = new MessageSet(2, this.m_activeMax, this.m_standbyMin);
            if (this.m_standbyMin > this.m_activeMin) {
                this.m_MTR = new MessageSet(1, --this.m_standbyMin, this.m_activeMin);
            }
            this.m_MTD = this.validateAndCreateMessageSet(this.m_standbyMax, this.m_activeMax, this.m_MTD, 0);
        }
        if (this.DEBUG1) {
            if (this.m_MTR != null) {
                this.debug("sort: MTR = [" + this.m_MTR.m_min + ", " + this.m_MTR.m_max + "]");
                if (this.m_MTR.m_next != null) {
                    this.debug("sort (m_MTR.m_next): MTR = [" + this.m_MTR.m_next.m_min + ", " + this.m_MTR.m_next.m_max + "]");
                }
            }
            if (this.m_MTD != null) {
                this.debug("sort: MTD = [" + this.m_MTD.m_min + ", " + this.m_MTD.m_max + "]");
                if (this.m_MTD.m_next != null) {
                    this.debug("sort (m_MTD.m_next): MTD = [" + this.m_MTD.m_next.m_min + ", " + this.m_MTD.m_next.m_max + "]");
                }
            }
            if (this.m_inDoubt != null) {
                this.debug("sort: In-Doubt = [" + this.m_inDoubt.m_min + ", " + this.m_inDoubt.m_max + "]");
            }
        }
    }

    private MessageSet checkMaxMinAndCreateMessageSet(long m_standbyMax, long m_standbyMin, MessageSet m_MTDParam, int MTD) {
        MessageSet m_MTD = m_MTDParam;
        if (m_standbyMax != -1L && m_standbyMin != -1L) {
            m_MTD = new MessageSet(MTD, m_standbyMax, m_standbyMin);
        }
        return m_MTD;
    }

    private MessageSet createMessageSet(long m_activeMin, long m_standbyMin, MessageSet m_MTDParam, int MTD) {
        MessageSet m_MTD = m_MTDParam;
        if (m_activeMin > m_standbyMin) {
            m_MTD = new MessageSet(MTD, m_activeMin - 1L, m_standbyMin);
        }
        return m_MTD;
    }

    private MessageSet validateAndCreateMessageSet(long m_standbyMax, long m_activeMax, MessageSet m_MTDParam, int MTD) {
        MessageSet m_MTD = m_MTDParam;
        if (m_standbyMax > m_activeMax) {
            m_MTD = new MessageSet(MTD, m_standbyMax, m_activeMax + 1L);
        }
        return m_MTD;
    }

    void deleteMTD() {
        if (this.getMTD() != null) {
            long from = this.getMTD().m_lower;
            long to = this.getMTD().m_upper;
            this.m_qmsgSaver.deleteMsgs(from, to);
            int ct = this.m_dsm.getStandbyDBQMsgs().removeBatch(from, to);
            if (this.DEBUG1) {
                this.debug("deleteMTD: db saver op (1) enqueued to delete messages from " + from + " to " + to + " count= " + ct);
            }
            if (this.getMTD().hasNext()) {
                from = this.getMTD().next().m_lower;
                to = this.getMTD().next().m_upper;
                this.m_qmsgSaver.deleteMsgs(from, to);
                ct = this.m_dsm.getStandbyDBQMsgs().removeBatch(from, to);
                if (this.checkDebugFlags(64)) {
                    this.debug("deleteMTD: db saver op (2) enqueued to delete messages from " + from + " to " + to + " count= " + ct);
                }
            }
        }
    }

    public boolean okToReplicate(IReplicateableSaverOp op) {
        if (op.getType() == 0) {
            return this.replicateSaveOp(op.getTracking());
        }
        if (op.getType() == 1) {
            return this.replicateDeleteOp(op);
        }
        return true;
    }

    private synchronized boolean replicateSaveOp(long tracking) {
        if (this.DEBUG) {
            this.debug("replicating live save op, tracking = " + tracking);
        }
        if (tracking <= this.m_activeMax && tracking > this.m_current) {
            if (this.DEBUG) {
                this.debug("adding tracking " + tracking + " to DNR to avoid redundant message replication");
            }
            this.m_DNR.add(new Long(tracking));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean replicateDeleteOp(IReplicateableSaverOp op) {
        boolean reenqueue = false;
        boolean ret = true;
        DynamicSyncDBQMsgsTracker dynamicSyncDBQMsgsTracker = this;
        synchronized (dynamicSyncDBQMsgsTracker) {
            long tracking = op.getTracking();
            if (tracking > this.m_activeMax || tracking <= this.m_lastReplicated) {
                ret = true;
                if (this.DEBUG) {
                    this.debug("replicating live delete op, tracking = " + tracking);
                }
            } else if (tracking > this.m_current && tracking <= this.m_activeMax) {
                Long ltracking = new Long(tracking);
                if (this.m_DNR.contains(ltracking)) {
                    return true;
                }
                if (tracking <= this.m_currentMax) {
                    this.m_DNR.add(ltracking);
                }
                ret = false;
                if (this.DEBUG) {
                    this.debug("surpressing live delete op, tracking = " + tracking);
                }
            } else if (tracking <= this.m_current && tracking > this.m_lastReplicated) {
                reenqueue = true;
                ret = false;
                if (this.DEBUG) {
                    this.debug("re-submitting live delete op, tracking = " + tracking);
                }
            }
        }
        if (reenqueue) {
            this.m_qmsgSaver.replicateDelete((QMsgSaverOp)((Object)op));
        }
        return ret;
    }

    public synchronized boolean okToReplicate(long tracking) {
        return !this.m_DNR.contains(new Long(tracking));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastReplicated(long tracking) {
        if (this.DEBUG) {
            this.debug("saver replicating online-sync'd message, tracking = " + tracking);
        }
        DynamicSyncDBQMsgsTracker dynamicSyncDBQMsgsTracker = this;
        synchronized (dynamicSyncDBQMsgsTracker) {
            this.m_lastReplicated = tracking;
        }
        if (this.CALLBACK) {
            this.callback(tracking + " replicated by saver.", 4, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeMap getMessageIds(long from, long to, int count) {
        IPtpDBQ ptpDBQ = AgentRegistrar.getAgentRegistrar().getBrokerDatabase().getIPtpDBQ();
        boolean releaseLock = false;
        TreeMap subset = null;
        try {
            ptpDBQ.acquireLock();
            releaseLock = true;
            subset = ptpDBQ.getMessageIdsTx(from, to, count);
            if (subset != null && !subset.isEmpty()) {
                this.m_DNR.headSet((Long)subset.firstKey()).clear();
            }
            this.m_currentMax = to;
        }
        catch (Exception ex) {
            if (!Broker.exiting) {
                ex.printStackTrace();
            }
        }
        finally {
            if (releaseLock) {
                ptpDBQ.releaseLock();
            }
        }
        return subset;
    }

    private boolean replicateMTR(long max, long min) {
        boolean ret = true;
        boolean more = true;
        long next = min;
        if (this.DEBUG1) {
            this.debug("replicateMTR starting: max= " + max + " min= " + min);
        }
        while (more) {
            int repl = 0;
            TreeMap subset = this.getMessageIds(next, max, this.m_syncBatchSize);
            if (subset == null || subset.isEmpty()) {
                return ret;
            }
            if (subset.size() < this.m_syncBatchSize) {
                more = false;
            } else {
                next = (Long)subset.lastKey() + 1L;
                if (next > max) {
                    more = false;
                }
            }
            if (this.DEBUG) {
                this.debug("found " + subset.size() + " message ids within MTR. lastkey= " + next + " max= " + max);
            }
            ReplicationManager mgr = this.m_dsm.getReplicationManager();
            Iterator iter = subset.keySet().iterator();
            while (iter.hasNext()) {
                long tracking = (Long)iter.next();
                if (this.okToReplicate(tracking) && mgr.okToReplicate()) {
                    IMgram m;
                    if (this.DEBUG) {
                        this.debug("replcating mgram from MTR, tracking = " + tracking);
                    }
                    if ((m = this.m_qmsgSaver.retrieveMgram(tracking)) != null) {
                        if (this.CALLBACK && !more && !iter.hasNext()) {
                            this.callback("Last MTR to be enqueued, tracking = " + tracking, 3, null);
                        }
                        this.m_qmsgSaver.replicateSave(m.getBrokerHandle().getLocalQueueName(), m, this);
                        ++repl;
                        if (this.CALLBACK) {
                            this.callback("First MTR enqueued, tracking = " + tracking, 2, null);
                        }
                    }
                } else {
                    this.setCurrent(tracking);
                    if (this.DEBUG) {
                        this.debug("skipping mgram from MTR, tracking = " + tracking);
                    }
                }
                if (mgr.okToReplicate()) continue;
                return false;
            }
            if (!this.DEBUG1) continue;
            this.debug("replicateMTR: read " + subset.size() + " message ids within MTR. numMsgsReplicated= " + repl + " lastkey= " + next + " max= " + max);
        }
        if (this.DEBUG1) {
            this.debug("replicateMTR: completed");
        }
        return ret;
    }

    private boolean resolveInDoubt() {
        long max = this.getInDoubt().m_upper;
        long next = this.getInDoubt().m_lower;
        boolean more = true;
        this.logDebug(this.DEBUG1, "resolveInDoubt: starting");
        while (more) {
            TreeMap subset = this.getMessageIds(next, max, this.m_syncBatchSize);
            if (subset == null || subset.isEmpty()) {
                return true;
            }
            if (subset.size() < this.m_syncBatchSize) {
                more = false;
            } else {
                next = (Long)subset.lastKey() + 1L;
                if (next > max) {
                    more = false;
                }
            }
            int idsSent = subset.size();
            this.logDebug(this.DEBUG, "read " + subset.size() + " message ids within In-Doubt.");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream request = new DataOutputStream(bos);
            try {
                request.writeInt(1);
                request.writeInt(subset.size());
                for (Object object : subset.keySet()) {
                    long tracking = (Long)object;
                    request.writeLong(tracking);
                    this.logDebug(this.DEBUG, "sending In-Doubt id , tracking = " + tracking);
                }
                request.close();
            }
            catch (IOException ioe) {
                if (this.DEBUG) {
                    ioe.printStackTrace();
                }
                return false;
            }
            IMgram reply = null;
            try {
                ReplicationManager.ReplicationRequest job = this.m_dsm.getReplicationManager().sendRequest("QUEUE_DB_SYNC_EXCHANGE", bos.toByteArray());
                if (job == null) {
                    this.logDebug(this.DEBUG, "Failed to send active's in-doubt tracking list.");
                    return false;
                }
                if (job.join()) {
                    reply = job.getReplyMgram();
                }
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
            if (this.CALLBACK) {
                this.callback("InDoubt request sent.", 1, null);
            }
            if (!this.processReply(max, next, idsSent, reply)) continue;
            return false;
        }
        this.logDebug(this.DEBUG1, "resolveInDoubt: completed");
        return true;
    }

    private boolean processReply(long max, long next, int idsSent, IMgram reply) {
        int idsReceived;
        ReplicationManager manager = this.m_dsm.getReplicationManager();
        int msgs = 0;
        if (reply == null) {
            this.logDebug(this.DEBUG, "Failed to exchange in-doubt trackings with standby - no reply.");
            return true;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(reply.getRawBody());
        DataInputStream data = new DataInputStream(bis);
        try {
            int count;
            if (!data.readBoolean()) {
                return true;
            }
            idsReceived = count = data.readInt();
            for (int i = 0; i < count; ++i) {
                long tracking = data.readLong();
                if (this.okToReplicate(tracking) && manager.okToReplicate()) {
                    this.logDebug(this.DEBUG, "replcating standby requested message, tracking = " + tracking);
                    IMgram mGram = this.m_qmsgSaver.retrieveMgram(tracking);
                    if (mGram != null) {
                        this.m_qmsgSaver.replicateSave(mGram.getBrokerHandle().getLocalQueueName(), mGram, this);
                        ++msgs;
                    }
                } else {
                    this.setCurrent(tracking);
                }
                if (manager.okToReplicate()) continue;
                return true;
            }
        }
        catch (IOException ioe) {
            this.logDebug(this.DEBUG, "Failed to process reply, caught exception " + ioe);
            return true;
        }
        this.logDebug(this.DEBUG1, "resolveInDoubt: idsSent= " + idsSent + " idsReceived= " + idsReceived + " msgsSent= " + msgs + " lastkey= " + next + " max= " + max);
        return false;
    }

    private void logDebug(boolean debug, String message) {
        if (debug) {
            this.debug(message);
        }
    }

    public synchronized void setCurrent(long tracking) {
        this.m_current = tracking;
    }

    boolean reconcile() {
        if (this.DEBUG1) {
            this.debug("reconcile starting");
        }
        boolean ok = true;
        long next = this.getActiveMin();
        while (ok && next <= this.getActiveMax()) {
            if (this.getMTR() != null && this.getMTR().contains(next)) {
                long max = next > this.getMTR().m_upper ? this.getMTR().next().m_upper : this.getMTR().m_upper;
                ok = this.replicateMTR(max, next);
                next = max + 1L;
                continue;
            }
            if (this.getInDoubt() == null || !this.getInDoubt().contains(next)) continue;
            ok = this.resolveInDoubt();
            next = this.getInDoubt().m_upper + 1L;
        }
        if (this.DEBUG1) {
            this.debug("reconcile completed");
        }
        return ok;
    }

    synchronized long getLastTracking() {
        return this.m_current;
    }

    MessageSet getMTR() {
        return this.m_MTR;
    }

    MessageSet getMTD() {
        return this.m_MTD;
    }

    MessageSet getInDoubt() {
        return this.m_inDoubt;
    }

    static final class MessageSet {
        int m_type;
        long m_upper;
        long m_lower;
        long m_max;
        long m_min;
        long m_current = -1L;
        MessageSet m_next = null;

        MessageSet(int type, long upper, long lower) {
            this.m_type = type;
            this.m_max = this.m_upper = upper;
            this.m_min = this.m_lower = lower;
        }

        boolean addNext(MessageSet next) {
            if (next.m_type == this.m_type && next.m_lower > this.m_upper) {
                this.m_next = next;
                this.m_max = this.m_next.m_upper;
                return true;
            }
            return false;
        }

        boolean hasNext() {
            return this.m_next != null;
        }

        MessageSet next() {
            return this.m_next;
        }

        boolean contains(long tracking) {
            if (tracking >= this.m_lower && tracking <= this.m_upper) {
                return true;
            }
            if (this.m_next != null) {
                return this.m_next.contains(tracking);
            }
            return false;
        }
    }
}

