/*
 * Decompiled with CFR 0.152.
 */
package progress.message.ft;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import progress.message.broker.Broker;
import progress.message.broker.BrokerStatus;
import progress.message.broker.Config;
import progress.message.broker.EBrokerAborted;
import progress.message.broker.prAccessor;
import progress.message.client.EGeneralException;
import progress.message.ft.FTMgramFactory;
import progress.message.ft.FailoverConfig;
import progress.message.ft.IRequestHandler;
import progress.message.ft.ReplicationManager;
import progress.message.msg.IMgram;
import progress.message.util.DebugState;
import progress.message.util.PriorityQueue;
import progress.message.zclient.DebugObject;

final class FailoverStateSolicitator
extends DebugObject
implements BrokerStatus,
Runnable {
    private ReplicationManager m_rm = null;
    private PriorityQueue m_requestQueue = null;
    private Thread m_solicitator = null;
    private volatile boolean m_connected = false;
    private boolean m_isLocalActive = false;
    private boolean m_isPeerActive = false;
    private int m_peerRecoveredState = 0;
    private boolean m_peerHasClientConnected = false;
    private long m_peerConnectionCount = 0L;
    private long m_peerFailoverMetricsDifference = 0L;
    private static String DUAL_ACTIVE_ERROR = prAccessor.getString("DUAL_ACTIVE_ERROR");
    private static String ROLE_RESOLUTION_ERROR = prAccessor.getString("ROLE_RESOLUTION_ERROR");

    FailoverStateSolicitator(ReplicationManager rm) throws EGeneralException {
        super(DebugState.GLOBAL_DEBUG_ON ? "FailoverStateSolicitator" : null);
        this.m_rm = rm;
        this.m_requestQueue = new PriorityQueue(1);
        IRequestHandler remoteAdminHandler = new IRequestHandler(){

            @Override
            public void handleRequest(IMgram m) {
                FailoverStateSolicitator.this.handleRemoteAdminNotification(m);
            }
        };
        rm.registerRequestHandler(FailoverConfig.addPrefix("REMOTE_ADMIN_NOTIFICATION"), remoteAdminHandler);
        IRequestHandler solicitationHandler = new IRequestHandler(){

            @Override
            public void handleRequest(IMgram m) {
                FailoverStateSolicitator.this.m_requestQueue.enqueue(m, 0);
            }
        };
        rm.registerRequestHandler(FailoverConfig.addPrefix("STATE_EXCHANGE"), solicitationHandler);
        if (this.DEBUG) {
            this.debug("created");
        }
    }

    void sendRemoteShutdownNotification() {
        block7: {
            if (this.m_rm.getBrokerState() != 2 && this.m_rm.getBrokerState() != 3) {
                return;
            }
            ReplicationManager.ReplicationRequest job = null;
            IMgram reply = null;
            if (this.DEBUG) {
                this.debug("sending remote shutdown notification...");
            }
            try {
                job = this.m_rm.sendRequest(FailoverConfig.addPrefix("REMOTE_ADMIN_NOTIFICATION"), new byte[1]);
                if (job == null) {
                    if (this.DEBUG) {
                        this.debug("Failed to send remote shutdown notification - no job created.");
                    }
                    return;
                }
                if (job.join()) {
                    reply = job.getReplyMgram();
                }
            }
            catch (InterruptedException ex) {
                if (!this.DEBUG) break block7;
                this.debug("Failed to send remote shutdown notification - thread interrupted.");
            }
        }
    }

    private void handleRemoteAdminNotification(IMgram m) {
        try {
            if (this.DEBUG) {
                this.debug("received remote shutdown notification from the active.");
            }
            this.m_rm.getConnectionMgr().setRemoteAdminShutdown();
            this.m_rm.sendReply(FTMgramFactory.getRequestReplyTracking(m), new byte[1]);
        }
        catch (Exception ex) {
            if (this.DEBUG) {
                ex.printStackTrace();
            }
            return;
        }
    }

    @Override
    public void run() {
        if (this.DEBUG) {
            this.debug("starting remote state solicitation ...");
        }
        while (true) {
            IMgram reply;
            block9: {
                ReplicationManager.ReplicationRequest job = null;
                reply = null;
                try {
                    job = this.m_rm.sendRequest(FailoverConfig.addPrefix("STATE_EXCHANGE"), new byte[1], true);
                    if (job == null) {
                        if (!this.DEBUG) break;
                        this.debug("Failed to send remote state solicitation - no job created.");
                        break;
                    }
                    if (!job.join()) break block9;
                    reply = job.getReplyMgram();
                }
                catch (InterruptedException ex) {
                    if (!this.DEBUG) break;
                    this.debug("Failed to send remote state solicitation - thread interrupted.");
                    break;
                }
            }
            if (reply == null) continue;
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(reply.getRawBody());
                DataInputStream data = new DataInputStream(bis);
                this.handleStandbyReply(data.readInt());
                data.close();
            }
            catch (IOException ex) {
                if (this.DEBUG) {
                    this.debug("Failed to read the response for the remote broker state:");
                }
                ex.printStackTrace();
                break;
            }
            catch (InterruptedException ex) {
                if (!this.DEBUG) break;
                this.debug("Failed to send remote state solicitation - thread interrupted.");
                break;
            }
        }
    }

    synchronized void cleanup() {
        this.m_connected = false;
        this.m_requestQueue.cancel();
        this.m_requestQueue = new PriorityQueue(1);
        if (this.m_solicitator != null) {
            if (this.DEBUG) {
                this.debug("stopping remote state solicitation ...");
            }
            Thread t = this.m_solicitator;
            this.m_solicitator = null;
            t.interrupt();
        }
    }

    synchronized void resume() {
        this.m_connected = true;
    }

    synchronized void doSolicit() {
        this.m_connected = true;
        if (this.m_solicitator != null) {
            return;
        }
        this.m_solicitator = new Thread((Runnable)this, "Standby Remote State Solicitator");
        this.m_solicitator.setDaemon(true);
        this.m_solicitator.start();
    }

    void sendStandbyBrokerState(int state) {
        if (!this.m_connected) {
            if (this.DEBUG) {
                this.debug("error sending standby state - replication connection dropped.");
            }
            return;
        }
        try {
            IMgram request = (IMgram)this.m_requestQueue.dequeueWait();
            if (request == null) {
                if (this.DEBUG) {
                    this.debug("error sending standby state - no outstanding request, replication connection dropped.");
                }
                return;
            }
            long replyTracking = FTMgramFactory.getRequestReplyTracking(request);
            if (this.DEBUG) {
                this.debug("sending local state, state = " + BrokerStatus.State.get(state) + ", reply tracking = " + replyTracking);
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream reply = new DataOutputStream(bos);
            reply.writeInt(state);
            reply.close();
            this.m_rm.sendReply(FTMgramFactory.getRequestReplyTracking(request), bos.toByteArray());
        }
        catch (Exception ex) {
            if (this.DEBUG) {
                ex.printStackTrace();
            }
            return;
        }
    }

    void handleStandbyReply(int lastKnownRemoteState) throws InterruptedException {
        if (this.DEBUG) {
            this.debug("received solicitation reply, remote state = " + BrokerStatus.State.get(lastKnownRemoteState));
        }
        if (lastKnownRemoteState == 5) {
            this.m_rm.triggerDynamicSyncOnActive();
        } else if (lastKnownRemoteState == 6) {
            this.m_rm.setBrokerState(2);
        }
    }

    void setLocalBrokerRole(boolean active) {
        this.m_isLocalActive = active;
    }

    void setRemoteBrokerState(boolean isPeerActive, int peerRecoveredState, boolean peerHasClientConnected, long peerConnectionCount, long peerFailoverMetricsDifference) {
        this.m_isPeerActive = isPeerActive;
        this.m_peerRecoveredState = peerRecoveredState;
        this.m_peerHasClientConnected = peerHasClientConnected;
        this.m_peerConnectionCount = peerConnectionCount;
        this.m_peerFailoverMetricsDifference = peerFailoverMetricsDifference;
    }

    void resetRemoteBrokerState() {
        this.m_isPeerActive = false;
        this.m_peerRecoveredState = 0;
        this.m_peerHasClientConnected = false;
        this.m_peerConnectionCount = 0L;
        this.m_peerFailoverMetricsDifference = 0L;
    }

    synchronized boolean resolveBrokerRole() {
        return this.resolveBrokerRole(this.m_isPeerActive, this.m_peerRecoveredState, this.m_peerHasClientConnected, this.m_peerConnectionCount, this.m_peerFailoverMetricsDifference, false);
    }

    synchronized boolean resolveBrokerRole(boolean checkOnly) {
        return this.resolveBrokerRole(this.m_isPeerActive, this.m_peerRecoveredState, this.m_peerHasClientConnected, this.m_peerConnectionCount, this.m_peerFailoverMetricsDifference, checkOnly);
    }

    private boolean resolveBrokerRole(boolean remoteActive, int remoteRecoveredState, boolean peerHasClientConnected, long peerConnectionCount, long peerFailoverMetricsDifference, boolean checkOnly) {
        Boolean result3;
        this.m_connected = true;
        int localRecoveredState = this.debugAndRetrieveLocalRecoveredState(peerHasClientConnected, remoteActive, remoteRecoveredState);
        if (remoteActive) {
            if (this.m_isLocalActive) {
                Boolean result1;
                this.debugData(peerHasClientConnected);
                if (this.m_rm.getBrokerState() == 6) {
                    return this.changeBrokerStateToStandbySync(checkOnly);
                }
                if (this.m_rm.isAssertingActive()) {
                    return this.shutdownDualActiveError(checkOnly, localRecoveredState, remoteRecoveredState);
                }
                long localFailoverMetricsDifference = this.m_rm.getFailoverMetricsDifference();
                String dualActiveResolution = this.logMessageAndRetrieveDualActiveResolution(localFailoverMetricsDifference, localRecoveredState, peerConnectionCount, peerFailoverMetricsDifference, remoteRecoveredState);
                if (("SET_ACTIVE_METRIC_SUM".equals(dualActiveResolution) || "SET_ACTIVE_METRIC_SUM_FORCE_ACTIVE".equals(dualActiveResolution)) && (result1 = this.shutdownDualActiveError(checkOnly, dualActiveResolution, localFailoverMetricsDifference, localRecoveredState, peerFailoverMetricsDifference, remoteRecoveredState)) != null) {
                    return result1;
                }
                return this.handleBroker(checkOnly, dualActiveResolution, localRecoveredState, peerHasClientConnected, remoteRecoveredState);
            }
            return this.shutdownOrUpdateState(checkOnly, localRecoveredState, remoteRecoveredState);
        }
        Boolean result2 = this.populateData(checkOnly);
        if (result2 != null) {
            return result2;
        }
        if (!checkOnly) {
            this.waitForStataTransitionToWaitingFinish();
        }
        if ((result3 = this.changeBrokerStateToRecoveryOrShutdown(checkOnly, localRecoveredState, remoteRecoveredState)) != null) {
            return result3;
        }
        if (remoteRecoveredState == 1) {
            return this.changeBrokerStateToStandbySync(checkOnly);
        }
        Boolean result4 = this.changeBrokerStateToRecovery2(checkOnly, localRecoveredState, remoteRecoveredState);
        if (result4 != null) {
            return result4;
        }
        Boolean result5 = this.validateAndchangeBrokerStateToStandbySync(checkOnly, localRecoveredState, remoteRecoveredState);
        if (result5 != null) {
            return result5;
        }
        Boolean result6 = this.changeBrokerStateToRecovery(checkOnly, localRecoveredState, remoteRecoveredState);
        if (result6 != null) {
            return result6;
        }
        return this.validateAndShutdown(checkOnly, localRecoveredState, remoteRecoveredState);
    }

    private Boolean changeBrokerStateToRecovery(boolean checkOnly, int localRecoveredState, int remoteRecoveredState) {
        if ((localRecoveredState == 2 || localRecoveredState == 3 || localRecoveredState == 6) && remoteRecoveredState == 0) {
            return this.changeBrokerStateToRecovery(checkOnly);
        }
        if ((remoteRecoveredState == 2 || remoteRecoveredState == 3 || remoteRecoveredState == 6) && localRecoveredState == 0) {
            return this.changeBrokerStateToStandbySync(checkOnly);
        }
        return null;
    }

    private Boolean changeBrokerStateToRecoveryOrShutdown(boolean checkOnly, int localRecoveredState, int remoteRecoveredState) {
        if (localRecoveredState == 0 && remoteRecoveredState == 0) {
            if (Config.PRIMARY && Config.FT_PREFERRED_ACTIVE == 0 || !Config.PRIMARY && Config.FT_PREFERRED_ACTIVE == 1) {
                return this.changeBrokerStateToRecovery(checkOnly);
            }
            return this.changeBrokerStateToStandbySync(checkOnly);
        }
        if (localRecoveredState == 1) {
            if (remoteRecoveredState != 1) {
                return this.changeBrokerStateToRecovery(checkOnly);
            }
            return this.shutdownDualActiveError(checkOnly, localRecoveredState, remoteRecoveredState);
        }
        return null;
    }

    private Boolean shutdownDualActiveError(boolean checkOnly, String dualActiveResolution, long localFailoverMetricsDifference, int localRecoveredState, long peerFailoverMetricsDifference, int remoteRecoveredState) {
        if (localFailoverMetricsDifference > 0L || peerFailoverMetricsDifference > 0L) {
            if (localFailoverMetricsDifference == peerFailoverMetricsDifference) {
                if ("SET_ACTIVE_METRIC_SUM_FORCE_ACTIVE".equals(dualActiveResolution)) {
                    if (this.m_rm.isFailoverBroker()) {
                        return this.shutdownDualActiveError(checkOnly, localRecoveredState, remoteRecoveredState);
                    }
                    return true;
                }
                return this.shutdownDualActiveError(checkOnly, localRecoveredState, remoteRecoveredState);
            }
            if ("SET_ACTIVE_METRIC_SUM_FORCE_ACTIVE".equals(dualActiveResolution) && localFailoverMetricsDifference > peerFailoverMetricsDifference) {
                return true;
            }
            return this.shutdownDualActiveError(checkOnly, localRecoveredState, remoteRecoveredState);
        }
        return null;
    }

    private Boolean changeBrokerStateToRecovery2(boolean checkOnly, int localRecoveredState, int remoteRecoveredState) {
        if (localRecoveredState == 3 && remoteRecoveredState == 5 || localRecoveredState == 3 && remoteRecoveredState == 6 || localRecoveredState == 2 && remoteRecoveredState == 6) {
            return this.changeBrokerStateToRecovery(checkOnly);
        }
        return null;
    }

    private Boolean populateData(boolean checkOnly) {
        if (this.m_isLocalActive) {
            if (this.m_rm.getBrokerState() == 6) {
                if (this.DEBUG) {
                    this.debug("the STANDBY broker waiting for FDT is assuming the active role.");
                }
                if (!checkOnly) {
                    this.m_rm.setBrokerState(1);
                }
                return true;
            }
            if (this.DEBUG) {
                this.debug("the broker is assuming the active role, current state = " + (String)State.get(this.m_rm.getBrokerState()));
            }
            if (!checkOnly) {
                this.m_rm.resetFailoverStatus();
            }
            return true;
        }
        return null;
    }

    private int debugAndRetrieveLocalRecoveredState(boolean peerHasClientConnected, boolean remoteActive, int remoteRecoveredState) {
        int localRecoveredState = this.m_rm.getRecoveredState();
        if (this.DEBUG) {
            this.debug("resolving broker roles, broker(current active, recovered state, client connected) = local(" + this.m_isLocalActive + ", " + (String)State.get(localRecoveredState) + ", " + this.m_rm.hasReceivedConnections() + "), remote(" + remoteActive + ", " + (String)State.get(remoteRecoveredState) + ", " + peerHasClientConnected + ")");
        }
        return localRecoveredState;
    }

    private boolean handleBroker(boolean checkOnly, String dualActiveResolution, int localRecoveredState, boolean peerHasClientConnected, int remoteRecoveredState) {
        if (this.m_rm.isFailoverBroker()) {
            if (!checkOnly && !this.resolveDualActive(localRecoveredState, remoteRecoveredState)) {
                this.shutdown(DUAL_ACTIVE_ERROR, localRecoveredState, remoteRecoveredState);
            }
            return false;
        }
        if (peerHasClientConnected && !"SET_STANDBY_NOCLIENT_CONNECTION_FORCE_ACTIVE".equals(dualActiveResolution)) {
            return this.shutdownDualActiveError(checkOnly, localRecoveredState, remoteRecoveredState);
        }
        if (!checkOnly) {
            BrokerComponent.getBrokerComponent();
            BrokerComponent.logMessage(prAccessor.format("DUAL_ACTIVE_NO_ACTIVITY_ON_FAILOVER_PEER", State.get(localRecoveredState), State.get(remoteRecoveredState)), (Integer)3);
        }
        return true;
    }

    private boolean shutdownOrUpdateState(boolean checkOnly, int localRecoveredState, int remoteRecoveredState) {
        if (this.m_rm.getRecoveredState() == 1) {
            return this.shutdownDualActiveError(checkOnly, localRecoveredState, remoteRecoveredState);
        }
        if (!checkOnly) {
            if (this.m_rm.getBrokerState() != 6) {
                this.waitForStataTransitionToWaitingFinish();
            }
            this.m_rm.setBrokerState(5);
        }
        return false;
    }

    private String logMessageAndRetrieveDualActiveResolution(long localFailoverMetricsDifference, int localRecoveredState, long peerConnectionCount, long peerFailoverMetricsDifference, int remoteRecoveredState) {
        BrokerComponent.getBrokerComponent();
        BrokerComponent.logMessage(prAccessor.format("DUAL_ACTIVE_RESOLUTION_INFORMATION", State.get(localRecoveredState), State.get(remoteRecoveredState), this.m_rm.getStandaloneConnectionCount(), peerConnectionCount, localFailoverMetricsDifference, peerFailoverMetricsDifference), (Integer)3);
        String dualActiveResolution = Config.DUAL_ACTIVE_RESOLUTION;
        return dualActiveResolution;
    }

    private Boolean validateAndchangeBrokerStateToStandbySync(boolean checkOnly, int localRecoveredState, int remoteRecoveredState) {
        if (remoteRecoveredState == 3 && localRecoveredState == 5 || remoteRecoveredState == 3 && localRecoveredState == 6 || remoteRecoveredState == 2 && localRecoveredState == 6) {
            return this.changeBrokerStateToStandbySync(checkOnly);
        }
        return null;
    }

    private boolean validateAndShutdown(boolean checkOnly, int localRecoveredState, int remoteRecoveredState) {
        if (!checkOnly) {
            this.shutdown(ROLE_RESOLUTION_ERROR, localRecoveredState, remoteRecoveredState);
        }
        return false;
    }

    private void debugData(boolean peerHasClientConnected) {
        if (this.DEBUG) {
            this.debug("DUAL ACTIVE: is the failover broker = " + this.m_rm.isFailoverBroker() + ", clients failed over to the peer = " + peerHasClientConnected);
        }
    }

    private void waitForStataTransitionToWaitingFinish() {
        try {
            this.m_rm.waitForReplicationState(1);
        }
        catch (InterruptedException ex) {
            if (this.DEBUG) {
                ex.printStackTrace();
            }
            Thread.currentThread().interrupt();
        }
    }

    private boolean shutdownDualActiveError(boolean checkOnly, int localRecoveredState, int remoteRecoveredState) {
        if (!checkOnly) {
            this.shutdown(DUAL_ACTIVE_ERROR, localRecoveredState, remoteRecoveredState);
        }
        return false;
    }

    private boolean changeBrokerStateToStandbySync(boolean checkOnly) {
        if (!checkOnly) {
            this.m_rm.setBrokerState(5);
        }
        return false;
    }

    private boolean changeBrokerStateToRecovery(boolean checkOnly) {
        if (!checkOnly) {
            this.m_rm.setBrokerState(8);
        }
        return true;
    }

    private boolean resolveDualActive(int localRecoveredState, int remoteRecoveredState) {
        if (localRecoveredState == 1 && remoteRecoveredState == 1) {
            boolean metricBasedDualActiveResolution;
            BrokerComponent broker = BrokerComponent.getBrokerComponent();
            String dualActiveResolution = Config.DUAL_ACTIVE_RESOLUTION;
            boolean bl = metricBasedDualActiveResolution = "SET_ACTIVE_METRIC_SUM".equals(dualActiveResolution) || "SET_ACTIVE_METRIC_SUM_FORCE_ACTIVE".equals(dualActiveResolution);
            if ((metricBasedDualActiveResolution || "SET_STANDBY_NOCLIENT_CONNECTION".equals(dualActiveResolution) || "SET_STANDBY_NOCLIENT_CONNECTION_FORCE_ACTIVE".equals(dualActiveResolution)) && !this.m_rm.hasReceivedConnections()) {
                try {
                    BrokerComponent.logMessage(prAccessor.format("DUAL_ACTIVE_RESOLUTION_BOTH_STANDALONE", State.get(localRecoveredState), State.get(remoteRecoveredState)), (Integer)3);
                    broker.restartContainer();
                    return true;
                }
                catch (Exception e) {
                    BrokerComponent.logMessage(e, (Integer)1);
                }
            }
        }
        return false;
    }

    private void shutdown(String err, int localRecoveredState, int remoteRecoveredState) {
        if (!Broker.exiting) {
            try {
                Object[] params = new Object[]{State.get(localRecoveredState), State.get(remoteRecoveredState)};
                String msg = MessageFormat.format(err, params);
                BrokerComponent.getBrokerComponent().abort(msg, null, 1);
            }
            catch (EBrokerAborted eba) {
                return;
            }
        }
    }
}

