/*
 * Decompiled with CFR 0.152.
 */
package progress.message.ft;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentConnection;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.BrokerStateManager;
import progress.message.broker.Config;
import progress.message.broker.IClientContext;
import progress.message.client.EBrokerVersionMismatch;
import progress.message.ft.ConnectionManager;
import progress.message.ft.FailoverConfig;
import progress.message.util.VersionData;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Message;
import progress.message.zclient.Session;

class PassiveConvertHandler
implements IMessageHandler {
    public static final byte RESET = 0;
    public static final byte GET_TOKEN = 1;
    public static final byte DONE = 2;
    private static final String PARAMETER_ABSENT = PassiveConvertHandler.class.getName() + " - parameter absent in message: ";
    private ConnectionManager m_connMgr;

    PassiveConvertHandler(ConnectionManager connMgr) {
        this.m_connMgr = connMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Session session, Envelope envelope) {
        block29: {
            Message m = envelope.getMessage();
            Object array = null;
            try {
                byte op = m.readByte();
                if (FailoverConfig.DEBUG) {
                    System.out.println("PassiveConvertHandler: received mgram of " + m.getSubject() + ", op = " + op);
                }
                switch (op) {
                    case 1: {
                        if (!envelope.isRequest()) break;
                        long rid = -1L;
                        try {
                            rid = AddrUtil.getIdFromDirectedSubject(envelope.getReplySubject());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        boolean isPeerActive = m.readBoolean();
                        int peerRecoveredState = m.readInt();
                        boolean peerHasClientConnected = m.readBoolean();
                        long peerConnectionCount = 0L;
                        if (m.available() > 0) {
                            peerConnectionCount = m.readLong();
                        } else {
                            Config.logMessage(PARAMETER_ABSENT + "peerConnectionCount", 2);
                        }
                        long peerFailoverMetricsDifference = 0L;
                        if (m.available() > 0) {
                            peerFailoverMetricsDifference = m.readLong();
                        } else {
                            Config.logMessage(PARAMETER_ABSENT + "peerFailoverMetricsDifference", 2);
                        }
                        this.m_connMgr.setRemoteBrokerState(isPeerActive, peerRecoveredState, peerHasClientConnected, peerConnectionCount, peerFailoverMetricsDifference);
                        m = new Message();
                        if (rid == this.m_connMgr.getConnectID()) {
                            AgentConnection conn;
                            long token = this.m_connMgr.passiveConvert();
                            boolean isLocalActive = this.m_connMgr.getReplicationManager().isAssertingActive() || BrokerStateManager.getBrokerStateManager().isActive() || this.m_connMgr.getReplicationManager().getBrokerState() == 6;
                            this.m_connMgr.getReplicationManager().setLocalBrokerRole(isLocalActive);
                            boolean okToContinue = true;
                            IClientContext cc = null;
                            try {
                                cc = AgentRegistrar.getAgentRegistrar().getClient(rid);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (cc != null && (conn = cc.getConnection()) != null) {
                                byte remoteSver = cc.getClientSessionVer();
                                VersionData vdat = conn.getPartnerProductVersion();
                                try {
                                    okToContinue = this.m_connMgr.validateDirectionOfReplication(remoteSver, vdat);
                                }
                                catch (EBrokerVersionMismatch e) {
                                    okToContinue = false;
                                }
                            }
                            if (okToContinue) {
                                if (token != 0L) {
                                    m.write(token);
                                }
                                m.write(FailoverConfig.RM_APPID_SCODE);
                                m.writeBoolean(isLocalActive);
                                m.writeInt(this.m_connMgr.getReplicationManager().getRecoveredState());
                                m.writeBoolean(this.m_connMgr.getReplicationManager().hasReceivedConnections());
                                m.writeLong(this.m_connMgr.getReplicationManager().getStandaloneConnectionCount());
                                m.writeLong(this.m_connMgr.getReplicationManager().getFailoverMetricsDifference());
                            }
                        }
                        session.reply(m, envelope);
                        break;
                    }
                    case 2: {
                        try {
                            AgentRegistrar reg = AgentRegistrar.getAgentRegistrar();
                            long id = m.readLong();
                            IClientContext cc = reg.lockContext(id);
                            if (cc == null) break;
                            try {
                                if (this.m_connMgr.isActive()) {
                                    if (FailoverConfig.DEBUG) {
                                        System.out.println("PassiveConvertHandler: post connect, starting the sender");
                                    }
                                    reg.postConnect(id, cc.getChannel());
                                    cc.startDelivery(null);
                                }
                            }
                            finally {
                                cc.unlock();
                            }
                            if (FailoverConfig.DEBUG) {
                                BrokerComponent.getComponentContext().logMessage("  Convert 1", 3);
                            }
                            break;
                        }
                        catch (Exception e) {
                            if (!FailoverConfig.DEBUG) break;
                            BrokerComponent.getComponentContext().logMessage("unable to start new sender: " + e.getMessage(), (Throwable)e, 2);
                        }
                    }
                }
            }
            catch (IOException e) {
                if (Broker.isInShutdown()) break block29;
                e.printStackTrace();
            }
        }
    }
}

