/*
 * Decompiled with CFR 0.152.
 */
package progress.message.ft;

import com.sonicsw.mq.common.runtime.ReplicationConnectionStateConstants;
import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.mq.components.BrokerManagementNotificationsHelper;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import progress.message.broker.AgentConnection;
import progress.message.broker.AgentListener;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.AgentSender;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.IClientContext;
import progress.message.ft.ConnectionManager;
import progress.message.ft.ReplicationChannel;
import progress.message.ft.ReplicationSender;
import progress.message.ft.ReplicationSessionContext;
import progress.message.msg.IMgram;
import progress.message.msg.MgramFactory;
import progress.message.util.DebugState;
import progress.message.zclient.IDebugCallback;

public final class ReplicationConnection
extends AgentConnection
implements ReplicationConnectionStateConstants,
Runnable,
IDebugCallback {
    private static final int FIN_WAIT = 1;
    private final int CLOSED = 2;
    private static final int SYN_WAIT = 3;
    private final int ESTABLISHED = 4;
    static final int SEND_RESULT_SENT = 1;
    static final int SEND_RESULT_NOTSENT = 2;
    static final int SEND_RESULT_NEEDRETRY = 3;
    private ConnectionManager m_cm = null;
    private IClientContext m_remoteCC = null;
    private ReplicationSessionContext m_context = null;
    private volatile ReplicationChannel m_currentActive = null;
    private ReplicationChannel m_newActive = null;
    private int m_state = 4;
    private HashMap m_activeChannels = new HashMap();
    private boolean m_isActive = false;
    volatile AgentSender m_sender = null;
    private boolean m_isConnected = true;
    private HashMap m_repliesPendingAck = new HashMap();
    private HashMap m_pendingAckTable = new HashMap();
    private TreeMap m_msgPendingAckList = new TreeMap();
    private HashMap m_DNRs = new HashMap();
    private long m_LMR = -1L;
    private long m_seqNo = -1L;
    static final int DISCONNECT_ACTIVE = 0;
    static final int DISCONNECT_ACTIVE_DISCONNECT_ = 1;
    static final int RESUME_HIGHEST = 2;
    static final int RESUME_HIGHEST_ = 3;
    Thread m_callback = null;
    private long m_msgPendingSize;
    private long m_msgPendingMaxCt;
    private long m_msgPendingMaxSize;
    private long m_repliesMaxCt;
    private long m_DNRsSize;
    private long m_DNRsMaxCt;
    private long m_DNRsMaxSize;
    private long m_calls;
    static final int CHANNEL_DISCONNECTED = 0;
    static final int CHANNEL_CONNECTED = 1;
    static final int CHANNEL_ACTIVE = 2;
    private static final String[] CHANNEL_STATE = new String[]{"DISCONNECTED", "CONNECTED", "ACTIVE"};
    private Thread m_handler = null;
    static IMgram s_heartbeat = MgramFactory.getMgramFactory().buildPingRequest(new byte[0], 0);

    synchronized boolean isConnected() {
        return this.m_isConnected;
    }

    @Override
    public void callback(String text, int method, Object params) {
        Runnable testRunner1 = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ReplicationConnection replicationConnection = ReplicationConnection.this;
                synchronized (replicationConnection) {
                    try {
                        while (ReplicationConnection.this.m_activeChannels.size() < ReplicationChannel.getChannels().length || ReplicationConnection.this.m_currentActive != ReplicationConnection.this.m_newActive) {
                            ReplicationConnection.this.wait();
                        }
                    }
                    catch (InterruptedException ex) {
                        return;
                    }
                }
                ReplicationConnection.this.debug("sabotage active channel " + ReplicationConnection.this.m_currentActive + " to force channel switch...");
                try {
                    ReplicationConnection.this.m_currentActive.getSocket().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        this.m_callback = new Thread(testRunner1);
        this.m_callback.setDaemon(true);
        this.m_callback.start();
    }

    ReplicationSessionContext getSessionContext() {
        return this.m_context;
    }

    ReplicationConnection(ReplicationChannel active, ConnectionManager cm) throws IOException {
        super(null, -1L, false);
        if (DebugState.GLOBAL_DEBUG_ON) {
            this.debugName("ReplicationConnection of session " + active.getSessionContext().getSessionId());
        }
        this.m_cm = cm;
        this.m_newActive = active;
        this.m_context = active.getSessionContext();
        this.connectSuccess(0, this.m_context.getSecurityContext(), this.m_context.getSecurityContext().getClientId());
        this.m_activeChannels.put(active.getName(), active);
    }

    private synchronized ReplicationChannel getNewActive() {
        if (this.m_activeChannels.isEmpty()) {
            return null;
        }
        ReplicationChannel newActive = this.m_currentActive;
        for (ReplicationChannel channel : this.m_activeChannels.values()) {
            if (channel.getWeight() <= 0 || newActive != null && channel.getWeight() <= newActive.getWeight()) continue;
            newActive = channel;
        }
        return newActive;
    }

    public synchronized int getChannelState(String name) {
        ReplicationChannel channel = (ReplicationChannel)this.m_activeChannels.get(name);
        if (channel != null) {
            if (channel == this.m_currentActive) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public String getChannelStateString(String name) {
        return CHANNEL_STATE[this.getChannelState(name)];
    }

    synchronized void start() throws EClientNotRegistered, IOException {
        this.m_remoteCC = AgentRegistrar.getAgentRegistrar().getClient(this.getClientId(0));
        this.activate(this.m_newActive);
        this.m_remoteCC.startDelivery(null);
        this.m_isActive = true;
    }

    private void activate(ReplicationChannel newActive) throws IOException {
        if (this.DEBUG) {
            this.debug("activating channel " + newActive);
        }
        this.m_sender = newActive.activate(this.m_remoteCC);
        if (this.m_sender == null) {
            throw new IOException("Failed to connect sender of " + newActive + " to CC.");
        }
        this.m_currentActive = newActive;
        BrokerManagementNotificationsHelper.sendReplicationConnectionActivationNotification(newActive.getName());
    }

    private void deactivate() {
        if (this.DEBUG) {
            this.debug("deactivating channel " + this.m_currentActive);
        }
        ((ReplicationSender)this.m_currentActive.getAgentSender()).stopThread();
        this.m_currentActive = null;
        this.m_sender = null;
    }

    private synchronized void reset() {
        if (this.DEBUG) {
            this.debug("connection reset, channel count = " + this.m_activeChannels.size() + ", current active = " + this.getNewActive());
        }
        if (this.DEBUG) {
            this.debug("connection reset, dumping out queue of " + this.m_remoteCC);
        }
        this.m_remoteCC.getOutQueue().dumpOutQueue();
        this.m_isActive = false;
        if (this.checkDebugFlags(64)) {
            this.debug(" reset (before reset): m_repliesPendingAck= " + this.m_repliesPendingAck.size() + "; m_msgPendingAckList= " + this.m_msgPendingAckList.size() + "; m_msgPendingSize= " + this.m_msgPendingSize + "; m_DNRs= " + this.m_DNRs.size());
            this.m_msgPendingMaxCt = 0L;
            this.m_msgPendingMaxSize = 0L;
            this.m_DNRsMaxCt = 0L;
            this.m_DNRsMaxSize = 0L;
            this.m_repliesMaxCt = 0L;
            this.m_calls = 0L;
        }
        this.m_repliesPendingAck = new HashMap();
        this.m_pendingAckTable = new HashMap();
        this.m_msgPendingAckList = new TreeMap();
        this.m_msgPendingSize = 0L;
        this.m_DNRs = new HashMap();
        this.m_DNRsSize = 0L;
        this.m_LMR = -1L;
        this.m_seqNo = -1L;
    }

    private void checkDebug() {
        if (this.checkDebugFlags(64)) {
            ++this.m_calls;
            if (this.m_calls % 10000L == 0L) {
                if (this.m_msgPendingMaxSize > 3000000L || this.m_repliesMaxCt > 1L) {
                    this.debug("m_msgPendingAckList= " + this.m_msgPendingAckList.size() + "; m_msgPendingSize= " + this.m_msgPendingSize + "; m_msgPendingMaxCt= " + this.m_msgPendingMaxCt + "; m_msgPendingMaxSize= " + this.m_msgPendingMaxSize + "; m_repliesPendingAck= " + this.m_repliesPendingAck.size() + "; m_repliesMaxCt= " + this.m_repliesMaxCt);
                }
                if (this.m_DNRsMaxSize > 3000000L || this.m_repliesMaxCt > 1L) {
                    this.debug("m_DNRs= " + this.m_DNRs.size() + "; m_DNRsSize= " + this.m_DNRsSize + "; m_DNRsMaxCt= " + this.m_DNRsMaxCt + "; m_DNRsMaxSize= " + this.m_DNRsMaxSize + "; m_repliesPendingAck= " + this.m_repliesPendingAck.size() + "; m_repliesMaxCt= " + this.m_repliesMaxCt);
                }
                this.m_calls = 0L;
                this.m_repliesMaxCt = this.m_repliesPendingAck.size();
                this.m_DNRsMaxCt = this.m_DNRs.size();
                this.m_DNRsMaxSize = this.m_DNRsSize;
                this.m_msgPendingMaxCt = this.m_msgPendingAckList.size();
                this.m_msgPendingMaxSize = this.m_msgPendingSize;
            }
        }
    }

    private void checkDebugDNRs(IMgram m, int x) {
        if (this.checkDebugFlags(64)) {
            this.m_DNRsSize += (long)(m.getLimiterSize() * x);
            long sz = this.m_DNRs.size();
            if (sz > this.m_DNRsMaxCt) {
                this.m_DNRsMaxCt = sz;
            }
            if (this.m_DNRsSize > this.m_DNRsMaxSize) {
                this.m_DNRsMaxSize = this.m_DNRsSize;
            }
            this.checkDebug();
        }
    }

    private void checkDebugReplies() {
        if (this.checkDebugFlags(64)) {
            long sz = this.m_repliesPendingAck.size();
            if (sz > this.m_repliesMaxCt) {
                this.m_repliesMaxCt = sz;
            }
            this.checkDebug();
        }
    }

    private void checkDebugMsgPending(IMgram m, int x) {
        if (this.checkDebugFlags(64)) {
            long sz;
            this.m_msgPendingSize += (long)(m.getLimiterSize() * x);
            if (this.m_msgPendingSize > this.m_msgPendingMaxSize) {
                this.m_msgPendingMaxSize = this.m_msgPendingSize;
            }
            if ((sz = (long)this.m_msgPendingAckList.size()) > this.m_msgPendingMaxCt) {
                this.m_msgPendingMaxCt = sz;
            }
            this.checkDebug();
        }
    }

    void startChannelSwitchHandler() {
        if (this.m_handler != null) {
            return;
        }
        if (this.DEBUG) {
            this.debug("starting channel switch handler...");
        }
        this.m_handler = new Thread((Runnable)this, "Channel Switch Handler of " + this);
        this.m_handler.setDaemon(true);
        this.m_handler.start();
    }

    void stopChannelSwitchHandler() {
        if (this.m_handler != null) {
            if (this.DEBUG) {
                this.debug("stopping channel switch handler...");
            }
            Thread t = this.m_handler;
            this.m_handler = null;
            t.interrupt();
        }
    }

    void handleChannelSwitch(AgentConnection conn, byte op, IMgram m) throws IOException {
        ReplicationChannel ch = (ReplicationChannel)conn;
        if (op == 4) {
            this.handleLastMessage(ch, m);
        } else if (op == 5) {
            this.handleLastMessageReply(ch, m);
        } else if (op == 6) {
            this.handleFirstMessage(ch, m);
        } else if (op == 7) {
            this.handleFirstMessageReply(ch, m);
        }
    }

    synchronized void handleLastMessage(ReplicationChannel oldActive, IMgram m) {
        if (this.DEBUG) {
            this.debug("received LAST_MESSAGE over channel " + oldActive);
        }
        this.deactivate();
        this.m_state = 2;
        if (this.DEBUG) {
            this.debug("sending LAST_MESSAGE_REPLY over channel " + oldActive);
        }
        IMgram lastMsgReply = this.m_cm.buildLastMessageReply(this.getSessionContext().getSessionId());
        try {
            oldActive.sendThrough(lastMsgReply);
        }
        catch (IOException ex) {
            this.debugException(ex);
        }
        this.notifyAll();
    }

    synchronized void handleLastMessageReply(ReplicationChannel oldActive, IMgram m) {
        if (this.DEBUG) {
            this.debug("received LAST_MESSAGE_REPLY over channel " + oldActive);
        }
        this.m_state = 2;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int sendReplicationReply(IMgram m, boolean wait) {
        boolean send = m.isGuarenteed();
        if (this.DEBUG) {
            this.debug("sending replication reply, reply tracking = " + m.getGuarenteedTrackingNum());
        }
        ReplicationConnection replicationConnection = this;
        synchronized (replicationConnection) {
            Integer result = this.retrieveSendResult(wait);
            if (result != null) {
                return result;
            }
            if (send) {
                this.m_repliesPendingAck.put(new Long(m.getGuarenteedTrackingNum()), m);
                this.checkDebugReplies();
            }
        }
        if (send) {
            this.m_remoteCC.sendThrough(m);
            if (this.DEBUG) {
                this.debug("replication reply sent, reply tracking = " + m.getGuarenteedTrackingNum());
            }
        }
        return 1;
    }

    synchronized void rcvdReplicationReplyAck(long tracking) {
        if (!this.isActive()) {
            return;
        }
        this.m_repliesPendingAck.remove(new Long(tracking));
        this.checkDebugReplies();
    }

    synchronized void handleFirstMessage(ReplicationChannel newActive, IMgram request) throws IOException {
        if (this.DEBUG) {
            this.debug("handleFirstMessage(): received FIRST_MESSAGE over channel " + newActive);
        }
        byte[] body = request.getRawBody();
        ByteArrayInputStream bis = new ByteArrayInputStream(body, 9, body.length - 1);
        DataInputStream data = new DataInputStream(bis);
        int count = data.readInt();
        ArrayList<Long> activePendingRequests = new ArrayList<Long>(count);
        for (int i = 0; i < count; ++i) {
            long pendingRequest = data.readLong();
            activePendingRequests.add(new Long(pendingRequest));
            if (!this.DEBUG) continue;
            this.debug("handleFirstMessage(): active pendingRequests[" + i + "] = " + pendingRequest);
        }
        HashMap pendingReplies = this.m_repliesPendingAck;
        this.m_repliesPendingAck = new HashMap();
        this.m_repliesMaxCt = 0L;
        for (Long key : pendingReplies.keySet()) {
            if (!activePendingRequests.contains(key)) continue;
            if (this.DEBUG) {
                this.debug("handleFirstMessage(): re-sending replication reply, tracking = " + key);
            }
            this.sendReplicationReply((IMgram)pendingReplies.get(key), true);
        }
        this.activate(newActive);
        if (this.checkDebugFlags(64)) {
            this.debug("sending FIRST_MESSAGE_REPLY over channel " + newActive + ", LMR = " + this.m_LMR + ", DNR count = " + this.m_DNRs.size());
        }
        try {
            Set keys = this.m_DNRs.keySet();
            Iterator iter = keys.iterator();
            long[] DNRList = new long[keys.size()];
            int index = 0;
            while (iter.hasNext()) {
                DNRList[index] = (Long)iter.next();
                if (this.DEBUG) {
                    this.debug("DNR[" + index + "] = " + DNRList[index]);
                }
                ++index;
            }
            IMgram firstMsgReply = this.m_cm.buildFirstMessageReply(this.getSessionContext().getSessionId(), this.m_LMR, DNRList);
            newActive.sendThrough(firstMsgReply);
        }
        catch (IOException ex) {
            this.debugException(ex);
            newActive.reset();
            this.notifyAll();
        }
        this.m_state = 4;
        this.notifyAll();
    }

    private void debugException(IOException ex) {
        if (this.DEBUG) {
            this.debug(ex.getMessage(), ex);
        }
    }

    synchronized void handleFirstMessageReply(ReplicationChannel newActive, IMgram reply) throws IOException {
        if (this.DEBUG) {
            this.debug("received FIRST_MESSAGE_REPLY over channel " + newActive);
        }
        byte[] body = reply.getRawBody();
        ByteArrayInputStream bis = new ByteArrayInputStream(body, 9, body.length - 1);
        DataInputStream data = new DataInputStream(bis);
        long lmr = data.readLong();
        if (this.DEBUG) {
            this.debug("LMR = " + lmr);
        }
        int count = data.readInt();
        ArrayList<Long> DNR = new ArrayList<Long>(count);
        for (int i = 0; i < count; ++i) {
            long pendingAck = data.readLong();
            DNR.add(new Long(pendingAck));
            if (!this.DEBUG) continue;
            this.debug("DNR[" + i + "] = " + pendingAck);
        }
        SortedMap rcvdMsgs = ((TreeMap)this.m_msgPendingAckList.clone()).headMap(new Long(lmr + 1L));
        if (!rcvdMsgs.isEmpty()) {
            for (Long pendingAck : rcvdMsgs.keySet()) {
                long tracking;
                if (!DNR.isEmpty() && DNR.contains(pendingAck) || (tracking = this.rcvdReplicationAck(pendingAck)) == -1L) continue;
                this.m_cm.getReplicationManager().onReplicationAck(tracking);
            }
        }
        this.m_remoteCC.getOutQueue().dumpOutQueue();
        for (IMgram m : this.m_msgPendingAckList.tailMap(new Long(lmr + 1L)).values()) {
            if (this.DEBUG) {
                this.debug("re-enqueue msg with seq # = " + m.getGuarenteedTrackingNum());
            }
            this.m_remoteCC.sendThrough(m);
        }
        try {
            this.activate(newActive);
            this.m_state = 4;
        }
        catch (IOException ex) {
            newActive.reset();
        }
        this.notifyAll();
    }

    synchronized boolean onNewChannel(ReplicationChannel channel) {
        ReplicationChannel old = this.m_activeChannels.put(channel.getName(), channel);
        if (this.DEBUG) {
            this.debug(channel + " connected, active channel count = " + this.m_activeChannels.size());
        }
        if (old != null) {
            String msg = "A channel was re-established w/o being disconnected first -\n" + old.debugReset();
            BrokerComponent.getComponentContext().logMessage(msg, 2);
            if (old == this.m_currentActive) {
                this.m_currentActive = null;
            }
        }
        this.m_newActive = this.getNewActive();
        boolean resumed = false;
        if (!this.m_isActive && this.m_newActive != null) {
            if (this.DEBUG) {
                this.debug("attempting to resume replication with channel " + this.m_newActive);
            }
            try {
                this.activate(this.m_newActive);
                this.m_isActive = true;
                resumed = true;
            }
            catch (IOException ex) {
                this.resetNewActive(ex);
            }
        }
        this.debugCurrentActive();
        return resumed;
    }

    synchronized int onWeightChange(ReplicationChannel channel) {
        if (this.DEBUG) {
            this.debug(channel + " weight changed to " + channel.getWeight() + ", active channel count = " + this.m_activeChannels.size());
        }
        if (this.m_currentActive == channel && channel.getWeight() == 0) {
            this.m_currentActive = null;
        }
        this.m_newActive = this.getNewActive();
        int ret = 0;
        if (this.m_isActive && this.m_newActive == null) {
            if (this.DEBUG) {
                this.debug("weight change on the last active channel - replication stops.");
            }
            this.reset();
            ret = -1;
        } else if (!this.m_isActive && this.m_newActive != null) {
            if (this.DEBUG) {
                this.debug("resuming replication with channel " + this.m_newActive);
            }
            try {
                this.activate(this.m_newActive);
                this.m_isActive = true;
                ret = 1;
            }
            catch (IOException ex) {
                this.resetNewActive(ex);
            }
        }
        this.debugCurrentActive();
        return ret;
    }

    private void debugCurrentActive() {
        this.debugCurrentAndNewActive();
        this.notifyAll();
    }

    private void resetNewActive(IOException ex) {
        if (this.DEBUG) {
            this.debug("failed to resume replication with channel " + this.m_newActive, ex);
        }
        this.m_newActive.reset();
        this.m_newActive = null;
    }

    synchronized boolean onDisconnect(ReplicationChannel channel) {
        this.m_activeChannels.remove(channel.getName());
        if (this.DEBUG) {
            this.debug(channel + " disconnected, active channel count = " + this.m_activeChannels.size());
        }
        if (this.m_activeChannels.isEmpty()) {
            this.shutdown();
            return true;
        }
        if (this.m_currentActive == channel) {
            this.m_currentActive = null;
        }
        if ((this.m_newActive = this.getNewActive()) == null) {
            if (this.DEBUG) {
                this.debug("last active channel disconnecting - replication stops.");
            }
            this.reset();
        }
        this.notifyAll();
        this.debugCurrentAndNewActive();
        return false;
    }

    private void debugCurrentAndNewActive() {
        if (this.DEBUG) {
            this.debug("current active = " + this.m_currentActive + ", new active = " + this.m_newActive);
        }
    }

    synchronized boolean isActive() {
        return this.m_isActive;
    }

    void pingIfAlive() {
        for (ReplicationChannel ch : ((HashMap)this.m_activeChannels.clone()).values()) {
            if (this.DEBUG) {
                this.debug("pinging channel " + ch.getName());
            }
            ch.ping(s_heartbeat);
        }
    }

    private synchronized void shutdown() {
        this.m_isActive = false;
        this.m_isConnected = false;
        if (this.m_handler != null) {
            Thread t = this.m_handler;
            this.m_handler = null;
            t.interrupt();
        }
        if (this.CALLBACK && this.m_callback != null) {
            Thread c = this.m_callback;
            this.m_callback = null;
            c.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterCC() {
        IClientContext remoteCC;
        ReplicationConnection replicationConnection = this;
        synchronized (replicationConnection) {
            remoteCC = this.m_remoteCC;
        }
        if (remoteCC != null) {
            remoteCC.lock();
            try {
                AgentRegistrar.getAgentRegistrar().unsubscribeTransient(remoteCC);
                remoteCC.setState(-1);
                if (this.DEBUG) {
                    this.debug("un-registering cc " + remoteCC);
                }
                AgentRegistrar.getAgentRegistrar().unregister(remoteCC);
            }
            finally {
                remoteCC.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.DEBUG) {
            this.debug("channel switch handler started.");
        }
        while (true) {
            ReplicationConnection replicationConnection = this;
            synchronized (replicationConnection) {
                boolean ackExchange = false;
                ReplicationChannel oldActive = null;
                ReplicationChannel newActive = null;
                while (this.m_currentActive == this.m_newActive) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        if (Thread.currentThread() == this.m_handler) continue;
                        return;
                    }
                }
                if (this.DEBUG) {
                    this.debug("switching " + this.m_currentActive + " with " + this.m_newActive);
                }
                if (this.m_newActive != null) {
                    BrokerManagementNotificationsHelper.sendReplicationConnectionChannelSwitchNotification(this.m_newActive.getName(), this.m_currentActive == null ? "UNKNOWN" : this.m_currentActive.getName());
                }
                if ((oldActive = this.m_currentActive) != null && oldActive.isConnected()) {
                    this.m_state = 1;
                    this.deactivate();
                    try {
                        if (this.DEBUG) {
                            this.debug("sending LAST_MESSAGE to close " + oldActive);
                        }
                        IMgram lastMsg = this.m_cm.buildLastMessageRequest(this.getSessionContext().getSessionId());
                        oldActive.sendThrough(lastMsg);
                    }
                    catch (Exception ex) {
                        if (this.DEBUG) {
                            this.debug("failed to send LAST_MESSAGE to close " + oldActive, ex);
                        }
                        this.m_state = 2;
                        ackExchange = true;
                    }
                    while (this.m_state != 2) {
                        try {
                            if (!oldActive.isConnected()) {
                                if (this.DEBUG) {
                                    this.debug("failed to receive LAST_MESSAGE_REPLY to close " + oldActive + " - channel disconnected");
                                }
                                this.m_state = 2;
                                ackExchange = true;
                                break;
                            }
                            this.wait();
                        }
                        catch (InterruptedException ex) {
                            if (Thread.currentThread() == this.m_handler) continue;
                            return;
                        }
                    }
                } else {
                    this.m_state = 2;
                    ackExchange = true;
                }
                if (this.DEBUG) {
                    this.debug("ack exchange " + (ackExchange ? "is" : "NOT") + " required to activate the new channel");
                }
                if (this.m_newActive == null) {
                    if (this.DEBUG) {
                        this.debug("abort channel switch - active channel count = " + this.m_activeChannels.size());
                    }
                    return;
                }
                this.m_state = 3;
                newActive = this.m_newActive;
                try {
                    if (this.DEBUG) {
                        this.debug("sending FIRST_MESSAGE to activate " + newActive);
                    }
                    IMgram firstMsg = this.m_cm.buildFirstMessageRequest(this.getSessionContext().getSessionId(), this.m_cm.getReplicationManager().getPendingRequests());
                    newActive.sendThrough(firstMsg);
                }
                catch (Exception ex) {
                    if (this.DEBUG) {
                        this.debug("failed to send FIRST_MESSAGE to activate " + newActive, ex);
                    }
                    this.debugSwitchNewActive();
                    this.notifyAll();
                    continue;
                }
                while (this.m_state != 4) {
                    try {
                        if (!newActive.isConnected()) {
                            if (this.DEBUG) {
                                this.debug("failed to receive FIRST_MESSAGE_REPLY or to activate " + newActive + " - channel disconnected");
                            }
                            this.debugSwitchNewActive();
                            break;
                        }
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        if (Thread.currentThread() == this.m_handler) continue;
                        return;
                    }
                }
                this.notifyAll();
            }
        }
    }

    private void debugSwitchNewActive() {
        this.m_newActive = this.getNewActive();
        this.m_state = 2;
        if (this.DEBUG) {
            this.debug("proceed channel switch with new active " + this.m_newActive);
        }
    }

    @Override
    public AgentListener getAgentListener() {
        ReplicationChannel current = this.m_currentActive;
        if (current == null) {
            return null;
        }
        return current.getAgentListener();
    }

    @Override
    public AgentSender getAgentSender() {
        ReplicationChannel current = this.m_currentActive;
        if (current == null) {
            return null;
        }
        return current.getAgentSender();
    }

    synchronized long allocateSeqNum(IMgram m) {
        m.setGuarenteed(++this.m_seqNo);
        m.setPriority((byte)0);
        return this.m_seqNo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int sendReplicationMgram(IMgram m, boolean nonStop, boolean wait) {
        ReplicationConnection replicationConnection = this;
        synchronized (replicationConnection) {
            if (!nonStop && !this.isActive()) {
                if (this.DEBUG) {
                    this.debug("connection inactive, dropping replication mgram:");
                    m.dump();
                }
                return 2;
            }
            if (!wait && this.m_state != 4) {
                return 3;
            }
            while (this.m_state != 4) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    return 2;
                }
            }
            if (m.isGuarenteed()) {
                Long tracking = new Long(m.getGuarenteedTrackingNum());
                Long seq = new Long(this.allocateSeqNum(m));
                if (this.DEBUG) {
                    this.debug("replicating mgram with tracking # = " + tracking + " and seq # = " + seq);
                }
                this.m_pendingAckTable.put(seq, tracking);
                this.m_msgPendingAckList.put(seq, m);
                this.checkDebugMsgPending(m, 1);
            } else if (this.DEBUG) {
                this.debug("replicating mgram w/o tracking:");
                m.dump();
            }
        }
        this.m_remoteCC.sendThrough(m);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int sendReplicationAck(IMgram ack, boolean wait) {
        ReplicationConnection replicationConnection = this;
        synchronized (replicationConnection) {
            Integer result = this.retrieveSendResult(wait);
            if (result != null) {
                return result;
            }
            if (ack.getAckHandle() != null) {
                long seqNo = ack.getAckHandle().getTrackingNumber();
                IMgram msg = (IMgram)this.m_DNRs.remove(new Long(seqNo));
                if (msg != null) {
                    this.checkDebugDNRs(msg, -1);
                }
                if (this.DEBUG) {
                    this.debug("sending ack with seq # = " + seqNo);
                }
            }
        }
        this.m_remoteCC.sendThrough(ack);
        return 1;
    }

    private Integer retrieveSendResult(boolean wait) {
        if (!this.isActive()) {
            return 2;
        }
        if (!wait && this.m_state != 4) {
            return 3;
        }
        while (this.m_state != 4) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                return 2;
            }
        }
        return null;
    }

    synchronized long rcvdReplicationAck(long seqNo) {
        if (!this.isActive()) {
            return -1L;
        }
        Long tracking = (Long)this.m_pendingAckTable.remove(new Long(seqNo));
        IMgram mg = (IMgram)this.m_msgPendingAckList.remove(new Long(seqNo));
        if (mg != null) {
            this.checkDebugMsgPending(mg, -1);
        }
        if (this.DEBUG) {
            this.debug("receiving ack with seq # = " + seqNo + " and tracking # = " + (tracking == null ? -1L : tracking));
        }
        if (tracking != null) {
            return tracking;
        }
        return -1L;
    }

    synchronized void rcvdReplicationMgram(IMgram m) {
        if (!this.isActive()) {
            return;
        }
        long seqNo = m.getGuarenteedTrackingNum();
        if (seqNo != -1L) {
            this.m_LMR = seqNo;
            this.m_DNRs.put(new Long(seqNo), m);
            this.checkDebugDNRs(m, 1);
            if (this.DEBUG) {
                this.debug("receiving mgram with seq # = " + seqNo);
            }
        }
    }

    @Override
    public String toString() {
        return "ReplicationConnection of " + this.getSessionContext().getSessionId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerChannelSwitch() {
        ReplicationConnection replicationConnection = this;
        synchronized (replicationConnection) {
            while (this.m_activeChannels.size() < 2) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    return;
                }
            }
            this.m_currentActive.simulateNetworkFailure();
        }
    }

    public void setRemoteCC(IClientContext client) {
        this.m_remoteCC = client;
    }
}

