/*
 * Decompiled with CFR 0.152.
 */
package progress.message.ft;

import progress.message.util.EAssertFailure;

public class ReplicationState {
    public static final int STARTUP = 0;
    public static final int WAITING = 1;
    public static final int STANDALONE = 2;
    public static final int ACTIVE = 3;
    public static final int STANDBY = 4;
    public static final int ACTIVE_SYNC = 5;
    public static final int STANDBY_SYNC = 6;
    public static final int OFFLINE = 7;
    static String[] s_replicationStateStrings = new String[]{"STARTUP", "WAITING", "STANDALONE", "ACTIVE", "STANDBY", "ACTIVE_SYNC", "STANDBY_SYNC", "OFFLINE"};
    public static final String DESCRIPTION_STRING = ReplicationState.createInfoString();

    private static String createInfoString() {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i <= 6; ++i) {
            str.append(i).append("=");
            str.append(s_replicationStateStrings[i]);
            if (i >= 6) continue;
            str.append(",");
        }
        return str.toString();
    }

    static int getReplicationStateFromBrokerState(int bsmState) {
        switch (bsmState) {
            case 7: {
                return 0;
            }
            case 4: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 6: {
                return 4;
            }
            case 3: {
                return 5;
            }
            case 5: {
                return 6;
            }
        }
        throw new EAssertFailure("not a replication state");
    }

    public static String getReplicationStateString(int replicationState) {
        return s_replicationStateStrings[replicationState];
    }

    static boolean isReplicationState(int bsmState) {
        switch (bsmState) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }
}

