/*
 * Decompiled with CFR 0.152.
 */
package progress.message.ft;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.SortedMap;
import progress.message.broker.BrokerDatabase;
import progress.message.broker.IDBQMsgs;
import progress.message.broker.LogEvent;
import progress.message.db.EDatabaseException;
import progress.message.ft.DBQMsgUpdateEvt;
import progress.message.ft.ReplicationDemultiplexer;
import progress.message.zclient.DebugObject;

public class StandbyDBQMsgs
extends DebugObject
implements IDBQMsgs {
    private SortedMap m_dbQMsgs;
    private HashMap m_trackingNumsToInform;
    private HashMap m_backupTrackingNumsToInform;
    private HashMap m_syncTrackingNumsToInform;
    private HashMap m_deleteStatus;
    private ReplicationDemultiplexer m_demux;
    private boolean m_inSync = false;
    private boolean m_recoveryComplete = false;
    private long m_numCalls;

    public StandbyDBQMsgs(BrokerDatabase db, ReplicationDemultiplexer demux) throws EDatabaseException {
        super("StandbyDBQMsgs");
        this.m_dbQMsgs = Collections.synchronizedSortedMap(db.getIPtpDBQ().getAllQMessageIds());
        this.m_demux = demux;
        this.m_trackingNumsToInform = new HashMap();
        this.m_deleteStatus = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxTrackingNumber() {
        SortedMap sortedMap = this.m_dbQMsgs;
        synchronized (sortedMap) {
            if (this.m_dbQMsgs.isEmpty()) {
                return -1L;
            }
            return (Long)this.m_dbQMsgs.lastKey();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMinTrackingNumber() {
        SortedMap sortedMap = this.m_dbQMsgs;
        synchronized (sortedMap) {
            if (this.m_dbQMsgs.isEmpty()) {
                return -1L;
            }
            return (Long)this.m_dbQMsgs.firstKey();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeRecovery() {
        SortedMap sortedMap = this.m_dbQMsgs;
        synchronized (sortedMap) {
            if (this.checkDebugFlags(64)) {
                int bt = this.m_backupTrackingNumsToInform != null ? this.m_backupTrackingNumsToInform.size() : 0;
                int st = this.m_syncTrackingNumsToInform != null ? this.m_syncTrackingNumsToInform.size() : 0;
                this.debug("CompleteRecovery: m_dbQMsgs= " + this.m_dbQMsgs.size() + "; m_trackingNumsToInform= " + this.m_trackingNumsToInform.size() + "; m_backupTrackingNumsToInform= " + bt + "; m_syncTrackingNumsToInform= " + st + "; m_deleteStatus= " + this.m_deleteStatus.size());
            }
            for (Long value : this.m_dbQMsgs.values()) {
                this.informWaitingTrackingNums(value, (short)0);
            }
            if (this.m_inSync) {
                if (this.m_syncTrackingNumsToInform != null && !this.m_syncTrackingNumsToInform.isEmpty()) {
                    Iterator iter = this.m_syncTrackingNumsToInform.values().iterator();
                    while (iter.hasNext()) {
                        this.m_demux.getEventQueue().forceEnqueue((LogEvent)iter.next());
                    }
                }
                if (this.m_backupTrackingNumsToInform != null && !this.m_backupTrackingNumsToInform.isEmpty()) {
                    this.informAllTrackingNums(this.m_backupTrackingNumsToInform, (short)1);
                }
            }
            if (!this.m_trackingNumsToInform.isEmpty()) {
                this.informAllTrackingNums(this.m_trackingNumsToInform, (short)1);
            }
            this.m_recoveryComplete = true;
            this.reset();
        }
    }

    public void reset() {
        this.m_trackingNumsToInform.clear();
        this.m_deleteStatus.clear();
        this.m_syncTrackingNumsToInform = null;
        this.m_backupTrackingNumsToInform = null;
        this.m_inSync = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteStatus(long trackingNum) {
        SortedMap sortedMap = this.m_dbQMsgs;
        synchronized (sortedMap) {
            Long value = new Long(trackingNum);
            Object result = this.m_deleteStatus.remove(value);
            boolean ret = false;
            if (result != null) {
                ret = true;
            } else {
                this.m_deleteStatus.put(value, value);
                ret = false;
            }
            this.checkDebug();
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short status(long trackingNum, boolean inform) {
        SortedMap sortedMap = this.m_dbQMsgs;
        synchronized (sortedMap) {
            this.checkDebug();
            if (!this.m_recoveryComplete) {
                if (inform) {
                    Long trackingObj = new Long(trackingNum);
                    this.m_trackingNumsToInform.put(trackingObj, trackingObj);
                }
                return 2;
            }
            Long tracking = new Long(trackingNum);
            if (this.m_dbQMsgs.containsKey(tracking)) {
                return 0;
            }
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelInfo(long tracking) {
        SortedMap sortedMap = this.m_dbQMsgs;
        synchronized (sortedMap) {
            Long trackingObj = new Long(tracking);
            this.m_trackingNumsToInform.remove(trackingObj);
            if (this.m_inSync) {
                this.m_backupTrackingNumsToInform.remove(trackingObj);
                this.m_syncTrackingNumsToInform.remove(trackingObj);
            }
            this.checkDebug();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(long trackingNum) {
        SortedMap sortedMap = this.m_dbQMsgs;
        synchronized (sortedMap) {
            Long trackingObj = new Long(trackingNum);
            this.m_dbQMsgs.remove(trackingObj);
            this.checkDebug();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteReplicated(long tracking) {
        SortedMap sortedMap = this.m_dbQMsgs;
        synchronized (sortedMap) {
            Long trackingObj = new Long(tracking);
            this.m_dbQMsgs.remove(trackingObj);
            if (this.deleteStatus(tracking)) {
                this.informWaitingTrackingNums(trackingObj, (short)1);
            }
            this.checkDebug();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeBatch(long from, long toParam) {
        long to = toParam;
        int ct = 0;
        SortedMap sortedMap = this.m_dbQMsgs;
        synchronized (sortedMap) {
            SortedMap subMap = this.m_dbQMsgs.subMap(new Long(from), new Long(++to));
            Iterator iter = subMap.values().iterator();
            while (iter.hasNext()) {
                Long msg = (Long)iter.next();
                iter.remove();
                ++ct;
            }
            this.checkDebug();
        }
        return ct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(long trackingNum) {
        SortedMap sortedMap = this.m_dbQMsgs;
        synchronized (sortedMap) {
            Long tracking = new Long(trackingNum);
            this.m_dbQMsgs.put(tracking, tracking);
            this.informWaitingTrackingNums(tracking, (short)0);
            this.checkDebug();
        }
    }

    @Override
    public int size() {
        return this.m_dbQMsgs.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncBegin() {
        SortedMap sortedMap = this.m_dbQMsgs;
        synchronized (sortedMap) {
            int st;
            int bt;
            if (this.checkDebugFlags(64)) {
                bt = this.m_backupTrackingNumsToInform != null ? this.m_backupTrackingNumsToInform.size() : 0;
                st = this.m_syncTrackingNumsToInform != null ? this.m_syncTrackingNumsToInform.size() : 0;
                this.debug("SyncBegin (beforeReset): m_dbQMsgs= " + this.m_dbQMsgs.size() + "; m_trackingNumsToInform= " + this.m_trackingNumsToInform.size() + "; m_backupTrackingNumsToInform= " + bt + "; m_syncTrackingNumsToInform= " + st + "; m_deleteStatus= " + this.m_deleteStatus.size());
            }
            this.m_inSync = true;
            this.m_backupTrackingNumsToInform = this.m_trackingNumsToInform;
            this.m_deleteStatus = new HashMap();
            this.m_trackingNumsToInform = new HashMap();
            this.m_syncTrackingNumsToInform = new HashMap();
            if (this.checkDebugFlags(64)) {
                bt = this.m_backupTrackingNumsToInform != null ? this.m_backupTrackingNumsToInform.size() : 0;
                st = this.m_syncTrackingNumsToInform != null ? this.m_syncTrackingNumsToInform.size() : 0;
                this.debug("SyncBegin (afterReset): m_dbQMsgs= " + this.m_dbQMsgs.size() + "; m_trackingNumsToInform= " + this.m_trackingNumsToInform.size() + "; m_backupTrackingNumsToInform= " + bt + "; m_syncTrackingNumsToInform= " + st + "; m_deleteStatus= " + this.m_deleteStatus.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncEnd() {
        SortedMap sortedMap = this.m_dbQMsgs;
        synchronized (sortedMap) {
            if (this.m_inSync) {
                int st;
                int bt;
                if (this.checkDebugFlags(64)) {
                    bt = this.m_backupTrackingNumsToInform != null ? this.m_backupTrackingNumsToInform.size() : 0;
                    st = this.m_syncTrackingNumsToInform != null ? this.m_syncTrackingNumsToInform.size() : 0;
                    this.debug("SyncEnd (beforeReset): m_dbQMsgs= " + this.m_dbQMsgs.size() + "; m_trackingNumsToInform= " + this.m_trackingNumsToInform.size() + "; m_backupTrackingNumsToInform= " + bt + "; m_syncTrackingNumsToInform= " + st + "; m_deleteStatus= " + this.m_deleteStatus.size());
                }
                this.m_inSync = false;
                this.m_syncTrackingNumsToInform = null;
                this.m_backupTrackingNumsToInform = null;
                if (this.checkDebugFlags(64)) {
                    bt = this.m_backupTrackingNumsToInform != null ? this.m_backupTrackingNumsToInform.size() : 0;
                    st = this.m_syncTrackingNumsToInform != null ? this.m_syncTrackingNumsToInform.size() : 0;
                    this.debug("SyncEnd (afterReset): m_dbQMsgs= " + this.m_dbQMsgs.size() + "; m_trackingNumsToInform= " + this.m_trackingNumsToInform.size() + "; m_backupTrackingNumsToInform= " + bt + "; m_syncTrackingNumsToInform= " + st + "; m_deleteStatus= " + this.m_deleteStatus.size());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void informWaitingTrackingNums(Long tracking, short status) {
        SortedMap sortedMap = this.m_dbQMsgs;
        synchronized (sortedMap) {
            DBQMsgUpdateEvt evt;
            Object hasTracker;
            if (!this.m_trackingNumsToInform.isEmpty() && (hasTracker = this.m_trackingNumsToInform.remove(tracking)) != null) {
                evt = new DBQMsgUpdateEvt(tracking, status);
                this.m_demux.getEventQueue().forceEnqueue(evt);
            }
            if (this.m_inSync && !this.m_backupTrackingNumsToInform.isEmpty() && (hasTracker = this.m_backupTrackingNumsToInform.remove(tracking)) != null) {
                evt = new DBQMsgUpdateEvt(tracking, status);
                this.m_syncTrackingNumsToInform.put(tracking, evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void informAllTrackingNums(HashMap trackingNums, short status) {
        SortedMap sortedMap = this.m_dbQMsgs;
        synchronized (sortedMap) {
            DBQMsgUpdateEvt evt = new DBQMsgUpdateEvt((HashMap)trackingNums.clone(), status);
            this.m_demux.getEventQueue().forceEnqueue(evt);
        }
    }

    @Override
    public Iterator getAllIds() {
        return this.m_dbQMsgs.keySet().iterator();
    }

    private void checkDebug() {
        if (this.checkDebugFlags(64)) {
            ++this.m_numCalls;
            if (this.m_numCalls % 10000L == 0L) {
                int bt = this.m_backupTrackingNumsToInform != null ? this.m_backupTrackingNumsToInform.size() : 0;
                int st = this.m_syncTrackingNumsToInform != null ? this.m_syncTrackingNumsToInform.size() : 0;
                this.debug("10000 calls: m_dbQMsgs= " + this.m_dbQMsgs.size() + "; m_trackingNumsToInform= " + this.m_trackingNumsToInform.size() + "; m_backupTrackingNumsToInform= " + bt + "; m_syncTrackingNumsToInform= " + st + "; m_deleteStatus= " + this.m_deleteStatus.size());
                this.m_numCalls = 0L;
            }
        }
    }

    @Override
    public void resetDbQMsgs() {
        this.m_dbQMsgs.clear();
        this.m_dbQMsgs = null;
    }
}

