/*
 * Decompiled with CFR 0.152.
 */
package progress.message.ft;

import java.io.DataInput;
import java.io.IOException;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import progress.message.broker.SubscribeEvt;
import progress.message.ft.FTMgramFactory;
import progress.message.ft.IFTEventProcessor;
import progress.message.msg.IMgram;
import progress.message.msg.IOperationHandle;
import progress.message.msg.MgramFactory;

public class SubscriptionSyncOp {
    public static final byte VERSION = 0;
    ArrayList m_subEvts = null;
    private boolean m_lastChunk = false;
    private long m_guarTrackingNum = -1L;

    SubscriptionSyncOp() {
    }

    boolean isLastChunk() {
        return this.m_lastChunk;
    }

    void setGuarTrackingNum(long guarTrkNum) {
        this.m_guarTrackingNum = guarTrkNum;
    }

    long getGuarTrackingNum() {
        return this.m_guarTrackingNum;
    }

    SubscriptionSyncOp(DataInput input, IMgram subSyncOpMgram) throws IOException {
        input.readByte();
        this.m_lastChunk = input.readBoolean();
        LinkedList subMgramList = subSyncOpMgram.getOperationHandle().getMgramList();
        if (subMgramList != null) {
            Iterator subMgrams = subMgramList.iterator();
            this.m_subEvts = new ArrayList(subSyncOpMgram.getOperationHandle().getMgramList().size());
            IMgram m = null;
            SubscribeEvt subscribeEvt = null;
            while (subMgrams.hasNext()) {
                m = (IMgram)subMgrams.next();
                subscribeEvt = (SubscribeEvt)m.getStateEventHandle().getStateEvent();
                subscribeEvt.disableUsesSubscpriontTable();
                this.m_subEvts.add(subscribeEvt);
            }
        }
    }

    public static IMgram createSubscriptionSyncOpMgram(ArrayList subscribes, boolean lastChunk) throws IOException {
        IMgram mgram = MgramFactory.getMgramFactory().buildOperationMgram(23);
        ObjectOutput output = mgram.getPayloadOutputStreamHandle();
        FTMgramFactory.addFTOpHeader(output, (byte)4);
        output.writeByte(0);
        output.writeBoolean(lastChunk);
        int size = subscribes.size();
        IOperationHandle opHandle = mgram.getOperationHandle();
        SubscribeEvt subEvt = null;
        for (int i = 0; i < size; ++i) {
            subEvt = (SubscribeEvt)subscribes.get(i);
            IMgram subMgram = MgramFactory.getMgramFactory().buildStateEventMgram(subEvt, true);
            opHandle.addMgram(subMgram);
        }
        return mgram;
    }

    public void execute(IFTEventProcessor ftEventProcessor) throws InterruptedException {
        if (this.m_subEvts != null) {
            int size = this.m_subEvts.size();
            SubscribeEvt subEvt = null;
            for (int i = 0; i < size; ++i) {
                subEvt = (SubscribeEvt)this.m_subEvts.get(i);
                ftEventProcessor.addEventNoLog(subEvt);
            }
        }
    }
}

