/*
 * Decompiled with CFR 0.152.
 */
package progress.message.gr;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Date;
import progress.message.broker.RoutingConnectionInfo;
import progress.message.gr.RouteNodeHolder;
import progress.message.util.DebugState;
import progress.message.util.QueueUtil;
import progress.message.zclient.DebugObject;

public class RouteInfo
extends DebugObject {
    private String m_nodeName;
    private String m_sendingBrokerName;
    private String m_globalName;
    private String m_brokerName;
    private Date m_timestamp = new Date();
    private int m_networkHops = 0;
    private boolean m_reconcilePending;
    private RouteInfo m_next = null;
    private RouteNodeHolder m_RemoteNode;
    private RoutingConnectionInfo m_ConnectionInfo = null;
    public static final int VERSION = 1;

    public RouteInfo() {
        super(DebugState.GLOBAL_DEBUG_ON ? "RouteInfo" : null);
    }

    public void setNodeName(String nodeName) {
        this.m_nodeName = nodeName;
    }

    public String getNodeName() {
        return this.m_nodeName;
    }

    public void setGlobalName(String globalName) {
        this.m_globalName = globalName;
    }

    public String getGlobalName() {
        return this.m_globalName;
    }

    public void setBrokerName(String brokerName) {
        this.m_brokerName = brokerName;
    }

    public String getBrokerName() {
        return this.m_brokerName;
    }

    public void setSendingBrokerName(String sendingBrokerName) {
        this.m_sendingBrokerName = sendingBrokerName;
    }

    public String getSendingBrokerName() {
        return this.m_sendingBrokerName;
    }

    public String getHashName() {
        String strHash = this.m_nodeName;
        int[] destination = QueueUtil.queueNameToMatchVector(this.m_globalName);
        for (int i = 0; i < destination.length; ++i) {
            strHash = strHash.concat(Integer.toHexString(destination[i]));
        }
        return strHash;
    }

    public void setHops(int hops) {
        this.m_networkHops = hops;
    }

    public int getHops() {
        return this.m_networkHops;
    }

    public void setTimestamp(Date timestamp) {
        this.m_timestamp = timestamp;
    }

    public Date getTimestamp() {
        return this.m_timestamp;
    }

    public void setNext(RouteInfo ri) {
        this.m_next = ri;
    }

    public RouteInfo getNext() {
        return this.m_next;
    }

    public void setRemoteNode(RouteNodeHolder rnh) {
        this.m_RemoteNode = rnh;
    }

    public RouteNodeHolder getRemoteNode() {
        return this.m_RemoteNode;
    }

    public void setConnectionInfo(RoutingConnectionInfo rci) {
        this.m_ConnectionInfo = rci;
    }

    public RoutingConnectionInfo getConnectionInfo() {
        return this.m_ConnectionInfo;
    }

    public void setReconcilePending() {
        this.m_reconcilePending = true;
    }

    public void clearReconcilePending() {
        this.m_reconcilePending = false;
    }

    public boolean isReconcilePending() {
        return this.m_reconcilePending;
    }

    public Object clone() {
        RouteInfo ri = new RouteInfo();
        ri.setNodeName(this.m_nodeName);
        ri.setGlobalName(this.m_globalName);
        ri.setBrokerName(this.m_brokerName);
        ri.setTimestamp(this.m_timestamp);
        ri.setHops(this.m_networkHops);
        ri.setRemoteNode(this.m_RemoteNode);
        ri.setConnectionInfo(this.m_ConnectionInfo);
        return ri;
    }

    public int length() {
        int len = 4;
        len += this.m_nodeName.length();
        len += this.m_globalName.length();
        len += this.m_brokerName.length();
        len += 8;
        len += 4;
        if (this.m_ConnectionInfo != null) {
            len += this.m_ConnectionInfo.getRoutingNodeName().length();
            len += this.m_ConnectionInfo.getConnectionURLs().length();
            len += this.m_ConnectionInfo.getUserName().length();
            len += this.m_ConnectionInfo.getPasswordBytes().length;
            len += 4;
            len += 4;
            if (this.m_ConnectionInfo.getRoutingAcceptor() != null) {
                len += this.m_ConnectionInfo.getRoutingAcceptor().length();
            }
        }
        return len;
    }

    public void writeToStream(DataOutput stream, short version) throws IOException {
        stream.writeUTF(this.m_nodeName);
        stream.writeUTF(this.m_globalName);
        stream.writeUTF(this.m_brokerName);
        stream.writeLong(this.m_timestamp.getTime());
        stream.writeInt(this.m_networkHops);
        stream.writeBoolean(this.m_ConnectionInfo != null);
        if (this.m_ConnectionInfo != null) {
            stream.writeUTF(this.m_ConnectionInfo.getConnectionURLs());
            stream.writeInt(this.m_ConnectionInfo.getTimeout());
            stream.writeBoolean(this.m_ConnectionInfo.isForwardRoutings());
            stream.writeBoolean(this.m_ConnectionInfo.isLoadBalance());
            stream.writeBoolean(this.m_ConnectionInfo.isSequentialLoadBalancing());
            stream.writeBoolean(this.m_ConnectionInfo.isStaticRouting());
            stream.writeUTF(this.m_ConnectionInfo.getRoutingAcceptor());
        }
    }

    public void readFromStream(DataInput stream, short version) throws IOException {
        this.m_nodeName = stream.readUTF();
        this.m_globalName = stream.readUTF();
        this.m_brokerName = stream.readUTF();
        this.m_timestamp.setTime(stream.readLong());
        this.m_networkHops = stream.readInt();
        boolean isConnectionInfo = stream.readBoolean();
        if (isConnectionInfo) {
            this.m_ConnectionInfo = new RoutingConnectionInfo();
            this.m_ConnectionInfo.setRoutingNodeName(this.m_nodeName);
            this.m_ConnectionInfo.setUserName("");
            this.m_ConnectionInfo.setPassword("");
            this.m_ConnectionInfo.setConnectionURLs(stream.readUTF());
            this.m_ConnectionInfo.setTimeout(stream.readInt());
            this.m_ConnectionInfo.setForwardRoutings(stream.readBoolean());
            this.m_ConnectionInfo.setLoadBalance(stream.readBoolean());
            this.m_ConnectionInfo.setSequentialLoadBalancing(stream.readBoolean());
            this.m_ConnectionInfo.setStaticRouting(stream.readBoolean());
            this.m_ConnectionInfo.setRoutingAcceptor(stream.readUTF());
        } else {
            this.m_ConnectionInfo = null;
        }
    }

    @Override
    public String toString() {
        return "Route: " + this.m_nodeName + "::" + this.m_globalName + " from " + this.m_sendingBrokerName + " Hops: " + this.m_networkHops + " ts: " + this.m_timestamp + " Broker: " + this.m_brokerName + " RNH: " + this.m_RemoteNode;
    }
}

