/*
 * Decompiled with CFR 0.152.
 */
package progress.message.interbroker;

import progress.message.broker.AgentConnection;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Config;
import progress.message.broker.IClientContext;
import progress.message.broker.IQueueInfo;
import progress.message.broker.fc.CCFlowControlTracker;
import progress.message.broker.fc.FCEvent;
import progress.message.interbroker.IBFCEvent;
import progress.message.interbroker.Interbroker;
import progress.message.interbroker.Neighbor;
import progress.message.util.DebugState;
import progress.message.zclient.NegotiatedConnectParms;

public class IBFlowControlTracker
extends CCFlowControlTracker {
    private static short RESUMED_VERSION = 0;
    private static short BLOCKED_VERSION = 1;
    private String m_pendingQueue;

    public IBFlowControlTracker(IClientContext cc) {
        super(DebugState.GLOBAL_DEBUG_ON ? "IBFlowControlTracker " + cc : null, cc);
    }

    @Override
    protected FCEvent createResumedFCEvent() {
        IBFCEvent fcevt = new IBFCEvent(true, RESUMED_VERSION);
        fcevt.setSendingSideCC(this.m_cc);
        return fcevt;
    }

    @Override
    protected FCEvent createBlockedFCEvent() {
        IBFCEvent fcevt = new IBFCEvent(false, BLOCKED_VERSION);
        fcevt.setSendingSideCC(this.m_cc);
        fcevt.blockedPendingQueue = this.m_pendingQueue;
        return fcevt;
    }

    @Override
    protected boolean isFCMonitoringEnabled() {
        boolean result = false;
        if (Config.BROKER_FC_MONITOR_INTERVAL > 0) {
            AgentConnection ac = this.m_cc.getConnection();
            if (ac != null) {
                NegotiatedConnectParms ncp = null;
                ncp = ac.getNegotiatedConnectParms();
                if (ncp != null) {
                    result = ncp.getSupportsBrokerFCEvents();
                }
            }
            if (this.m_cc.getClientSessionVer() >= 31) {
                result = true;
            }
        }
        return result;
    }

    @Override
    public void sendFCReport(FCEvent evt) {
        AgentRegistrar.getAgentRegistrar().getFCMonitor().sendFCReport(this.m_cc, (IBFCEvent)evt);
    }

    @Override
    public void preMonitorFC() {
        this.m_pendingQueue = null;
        Neighbor n = Interbroker.getInterbroker().getNeighborByID(this.m_cc.getId());
        if (n == null) {
            return;
        }
        String pqname = n.getPendingQueueName();
        if (pqname == null || pqname.length() == 0) {
            return;
        }
        IQueueInfo qi = AgentRegistrar.getAgentRegistrar().getQueueProc().getRoutingQueue().getPendingQueueData(pqname);
        if (qi != null && qi.getTotalEnqueued() > 0) {
            this.m_pendingQueue = pqname;
        }
    }
}

