/*
 * Decompiled with CFR 0.152.
 */
package progress.message.interbroker;

import progress.message.util.EAssertFailure;
import progress.message.zclient.ILabelVisitor;
import progress.message.zclient.ISubject;
import progress.message.zclient.Label;

class IBSubscription {
    static final int NOP = 0;
    static final int SUBSCRIBE = 1;
    static final int UNSUBSCRIBE = 2;
    static final int LABEL_CHANGE = 3;
    private ISubject m_subject;
    private int m_refcount;
    private LabelState m_addLabelState;
    private LabelState m_removeLabelState;
    int m_guarcount;
    int m_persistcount;
    int m_globalcount;

    IBSubscription(ISubject subject) {
        this.m_subject = subject;
        if (subject != null && !subject.isMultiSubject() && subject.getSubjectString().startsWith("$ISYS.GSA.")) {
            this.m_addLabelState = new AddGSALabelState();
            this.m_removeLabelState = new RemoveGSALabelState();
        } else {
            this.m_addLabelState = new AddLabelState();
            this.m_removeLabelState = new RemoveLabelState();
        }
    }

    int addRef(Label lab) {
        this.m_addLabelState.m_ret = 0;
        if (this.m_refcount++ == 0) {
            this.m_addLabelState.m_ret = 1;
        }
        lab.visit(this.m_addLabelState);
        this.verifyCounts();
        return this.m_addLabelState.m_ret;
    }

    int removeRef(Label lab) {
        this.m_removeLabelState.m_ret = 0;
        if (--this.m_refcount == 0) {
            this.m_removeLabelState.m_ret = 2;
        }
        lab.visit(this.m_removeLabelState);
        this.verifyCounts();
        return this.m_removeLabelState.m_ret;
    }

    int updateRef(Label from, Label to) {
        boolean toglobal;
        boolean fromglobal;
        boolean pto;
        boolean pfrom;
        int ret = 0;
        GetLabelState fromState = null;
        GetLabelState toState = null;
        if (this.m_subject != null && !this.m_subject.isMultiSubject() && this.m_subject.getSubjectString().startsWith("$ISYS.GSA.")) {
            fromState = new GetGSALabelState();
            toState = new GetGSALabelState();
        } else {
            fromState = new GetLabelState();
            toState = new GetLabelState();
        }
        from.visit(fromState);
        to.visit(toState);
        boolean gfrom = fromState.isGuaranteed();
        boolean gto = toState.isGuaranteed();
        if (gfrom != gto && (gfrom && --this.m_guarcount == 0 || gto && this.m_guarcount++ == 0)) {
            ret = 3;
        }
        if ((pfrom = fromState.isPersistent()) != (pto = toState.isPersistent()) && (pfrom && --this.m_persistcount == 0 || pto && this.m_persistcount++ == 0)) {
            ret = 3;
        }
        if ((fromglobal = fromState.isGlobal()) != (toglobal = toState.isGlobal()) && (fromglobal && --this.m_globalcount == 0 || toglobal && this.m_globalcount++ == 0)) {
            ret = 3;
        }
        this.verifyCounts();
        return ret;
    }

    Label getLabel() {
        Label lab = new Label();
        lab.setGuaranteed(this.m_guarcount > 0);
        lab.setPersistent(this.m_persistcount > 0);
        lab.setRouteLimit(this.m_globalcount > 0 ? 7 : 2);
        return lab;
    }

    ISubject getSubject() {
        return this.m_subject;
    }

    private void verifyCounts() {
        if (this.m_refcount < 0 || this.m_guarcount < 0 || this.m_persistcount < 0) {
            throw new EAssertFailure("Negative count in IB subscription to " + this.m_subject + ": refcount " + this.m_refcount + ", guarcount " + this.m_guarcount + ", persistcount " + this.m_persistcount);
        }
    }

    private class GetGSALabelState
    extends GetLabelState {
        private GetGSALabelState() {
        }

        @Override
        public void setGuaranteed(boolean value) {
        }

        @Override
        public void setPersistent(boolean value) {
        }
    }

    private class GetLabelState
    extends LabelState {
        boolean m_isGlobal;
        boolean m_isPersistent;
        boolean m_isGuaranteed;

        private GetLabelState() {
            this.m_isGlobal = false;
            this.m_isPersistent = false;
            this.m_isGuaranteed = false;
        }

        @Override
        public void setGuaranteed(boolean value) {
            this.m_isGuaranteed = value;
        }

        @Override
        public void setPersistent(boolean value) {
            this.m_isPersistent = value;
        }

        @Override
        public void setRouteLimit(int limit) {
            if (limit == 7) {
                this.m_isGlobal = true;
            }
        }

        boolean isGuaranteed() {
            return this.m_isGuaranteed;
        }

        boolean isPersistent() {
            return this.m_isPersistent;
        }

        boolean isGlobal() {
            return this.m_isGlobal;
        }
    }

    private class RemoveGSALabelState
    extends RemoveLabelState {
        private RemoveGSALabelState() {
        }

        @Override
        public void setGuaranteed(boolean value) {
        }

        @Override
        public void setPersistent(boolean value) {
        }
    }

    private class RemoveLabelState
    extends LabelState {
        private RemoveLabelState() {
        }

        @Override
        public void setGuaranteed(boolean value) {
            if (value) {
                --IBSubscription.this.m_guarcount;
                if (IBSubscription.this.m_guarcount == 0 && this.m_ret != 2) {
                    this.m_ret = 3;
                }
            }
        }

        @Override
        public void setPersistent(boolean value) {
            if (value) {
                --IBSubscription.this.m_persistcount;
                if (IBSubscription.this.m_persistcount == 0 && this.m_ret != 2) {
                    this.m_ret = 3;
                }
            }
        }

        @Override
        public void setRouteLimit(int limit) {
            if (limit == 7) {
                --IBSubscription.this.m_globalcount;
                if (IBSubscription.this.m_globalcount == 0 && this.m_ret != 2) {
                    this.m_ret = 3;
                }
            }
        }
    }

    private class AddGSALabelState
    extends AddLabelState {
        private AddGSALabelState() {
        }

        @Override
        public void setGuaranteed(boolean value) {
        }

        @Override
        public void setPersistent(boolean value) {
        }
    }

    private class AddLabelState
    extends LabelState {
        private AddLabelState() {
        }

        @Override
        public void setGuaranteed(boolean value) {
            if (value) {
                if (IBSubscription.this.m_guarcount == 0 && this.m_ret != 1) {
                    this.m_ret = 3;
                }
                ++IBSubscription.this.m_guarcount;
            }
        }

        @Override
        public void setPersistent(boolean value) {
            if (value) {
                if (IBSubscription.this.m_persistcount == 0 && this.m_ret != 1) {
                    this.m_ret = 3;
                }
                ++IBSubscription.this.m_persistcount;
            }
        }

        @Override
        public void setRouteLimit(int limit) {
            if (limit == 7) {
                if (IBSubscription.this.m_globalcount == 0 && this.m_ret != 1) {
                    this.m_ret = 3;
                }
                ++IBSubscription.this.m_globalcount;
            }
        }
    }

    private abstract class LabelState
    implements ILabelVisitor {
        int m_ret;

        private LabelState() {
        }
    }
}

