/*
 * Decompiled with CFR 0.152.
 */
package progress.message.interbroker;

import java.io.IOException;
import java.util.Map;
import progress.message.broker.AgentConnection;
import progress.message.interbroker.InterbrokerListener;
import progress.message.interbroker.InterbrokerSender;
import progress.message.interbroker.Neighbor;
import progress.message.net.ISocket;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.ProgressSecureRandom;

public final class InterbrokerConnection
extends AgentConnection {
    private final String m_peerName;
    private AgentConnection old_conn;

    InterbrokerConnection(AgentConnection old_con, Neighbor n) throws IOException {
        this(old_con.getSocket(), n);
        this.old_conn = old_con;
    }

    InterbrokerConnection(ISocket socket, Neighbor n) throws IOException {
        super(socket, ProgressSecureRandom.theSecureRandom().nextLong(), false);
        this.m_peerName = n.getBrokerName();
        this.debugName("InterbrokerConnection");
        this.setAgentSender(new InterbrokerSender(this, n));
        this.setAgentListener(new InterbrokerListener(this, n));
        if (this.CALLBACK) {
            this.callback("", 100400, this);
        }
    }

    public final String getNeighborName() {
        return this.m_peerName;
    }

    @Override
    protected void closeInternal() {
        super.closeInternal();
        if (this.CALLBACK) {
            this.callback("", 100401, this);
        }
        if (this.old_conn != null) {
            this.old_conn.close();
        }
    }

    @Override
    protected String getInstanceMetricName() {
        ClientSecurityContext.ISecurityContextDisplayInfo displayInfo;
        String instanceName = null;
        ClientSecurityContext csc = this.getSecurityContext(0);
        if (csc != null && (displayInfo = csc.getDisplayInfo()).getType() == 2) {
            instanceName = displayInfo.getName();
        }
        return instanceName;
    }

    @Override
    public void appendConnectionMemberProperties(Map properties) {
        super.appendConnectionMemberProperties(properties);
        properties.put("ConnectionType", "Cluster");
        properties.put("PeerBroker", this.m_peerName);
    }
}

