/*
 * Decompiled with CFR 0.152.
 */
package progress.message.interbroker;

import java.util.Hashtable;
import progress.message.client.EGeneralException;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Message;
import progress.message.zclient.MessageHandler;
import progress.message.zclient.Session;

public class MessageSubdispatcher
extends MessageHandler
implements IMessageHandler {
    private Hashtable m_table = new Hashtable();
    private IMessageHandler m_default_handler;
    private String m_prefix;
    private int m_length_prefix;

    public MessageSubdispatcher(String prefix, IMessageHandler default_handler) throws EGeneralException {
        super(null);
        this.replaceHandler(this);
        this.m_default_handler = default_handler;
        if (prefix.length() == 0) {
            this.m_prefix = "#";
            this.m_length_prefix = 0;
        } else if (prefix.charAt(prefix.length() - 1) == '.') {
            this.m_prefix = prefix + "#";
            this.m_length_prefix = prefix.length();
        } else {
            this.m_prefix = prefix + ".#";
            this.m_length_prefix = prefix.length() + 1;
        }
        this.bind(this.m_prefix);
    }

    public void addDispatcher(String subdispatch, IMessageHandler handler) {
        this.m_table.put(subdispatch, handler);
    }

    @Override
    public void handleMessage(Session session, Envelope envelope) {
        Message msg = envelope.getMessage();
        String subject = msg.getSubject().getSubjectString();
        String subsection = null;
        int index = subject.indexOf(46, this.m_length_prefix);
        if (index == -1) {
            index = subject.length();
        }
        try {
            subsection = subject.substring(this.m_length_prefix, index);
        }
        catch (StringIndexOutOfBoundsException e) {
            this.m_default_handler.handleMessage(session, envelope);
            return;
        }
        Object obj = this.m_table.get(subsection);
        if (obj == null) {
            this.m_default_handler.handleMessage(session, envelope);
        } else {
            ((IMessageHandler)obj).handleMessage(session, envelope);
        }
    }
}

