/*
 * Decompiled with CFR 0.152.
 */
package progress.message.interbroker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BrokerSubscription;
import progress.message.broker.Config;
import progress.message.broker.EStartupFailure;
import progress.message.broker.FTPairPeerInfoHolder;
import progress.message.client.EGeneralException;
import progress.message.interbroker.AddGroupEvent;
import progress.message.interbroker.AddNeighborEvent;
import progress.message.interbroker.BrokerAddedEvent;
import progress.message.interbroker.BrokerHostChangeEvent;
import progress.message.interbroker.BrokerRemovedEvent;
import progress.message.interbroker.CollectiveGroup;
import progress.message.interbroker.ConfigConnectionMgr;
import progress.message.interbroker.IBConfigBean;
import progress.message.interbroker.IBConfigEvent;
import progress.message.interbroker.IBConfigListener;
import progress.message.interbroker.IBConfiguration;
import progress.message.interbroker.IBDBReinitEvent;
import progress.message.interbroker.Interbroker;
import progress.message.interbroker.InterbrokerConfig;
import progress.message.interbroker.Neighbor;
import progress.message.interbroker.RemoveGroupEvent;
import progress.message.interbroker.RemoveNeighborCompleteEvent;
import progress.message.interbroker.RemoveNeighborEvent;
import progress.message.interbroker.UpdateBrokerEvent;
import progress.message.interbroker.prAccessor;
import progress.message.util.LongHashTable;
import progress.message.zclient.Label;

final class Neighbors
implements IBConfigListener {
    private LongHashTable m_groups_by_id = new LongHashTable();
    private LongHashTable m_everyone = new LongHashTable();
    private LongHashTable m_everyone_by_connect_id = new LongHashTable();
    private CollectiveGroup[] m_groups = null;
    private Neighbor[] m_everyone_active = new Neighbor[0];
    private boolean m_removingGroup;
    private CollectiveGroup m_removeGroup;
    private int m_neighborRemovals;
    private ConfigConnectionMgr m_configMgr;
    private boolean m_contactInitiated = false;

    Neighbors() {
    }

    Neighbor getByID(long remote_broker_id) {
        return (Neighbor)this.m_everyone.get(remote_broker_id);
    }

    synchronized Neighbor getByConnectID(long id) {
        return (Neighbor)this.m_everyone_by_connect_id.get(id);
    }

    synchronized CollectiveGroup getGroupByID(long id) {
        return (CollectiveGroup)this.m_groups_by_id.get(id);
    }

    Neighbor[] getAllActive() {
        return this.m_everyone_active;
    }

    Neighbor[] getAll() {
        Neighbor[] returnVal = new Neighbor[this.m_everyone.size()];
        int count = 0;
        Enumeration enu = this.m_everyone.elements();
        while (enu.hasMoreElements()) {
            Neighbor neighbor = (Neighbor)enu.nextElement();
            returnVal[count++] = neighbor;
        }
        return returnVal;
    }

    CollectiveGroup[] getAllGroups() {
        return this.m_groups;
    }

    public boolean isDiscardMessage(long to_id, long from_id, int rte) {
        return !Neighbors.okToForward((CollectiveGroup)this.m_groups_by_id.get(from_id), (CollectiveGroup)this.m_groups_by_id.get(to_id), rte);
    }

    public static boolean okToForward(CollectiveGroup src, CollectiveGroup dest, int rte) {
        switch (rte) {
            case 0: {
                return false;
            }
            case 1: {
                return dest == null;
            }
            case 2: {
                return src == null || dest == null;
            }
        }
        return src == null || src != dest;
    }

    boolean processConfiguration(ConfigConnectionMgr configMgr) throws EStartupFailure {
        this.m_configMgr = configMgr;
        try {
            this.processNeighbors(this.m_configMgr.getConfigBean().getConfiguration(Config.BROKER_NAME));
        }
        catch (EGeneralException e) {
            BrokerComponent.getComponentContext().logMessage("Unable to get interbroker configuration from " + InterbrokerConfig.CONFIG_SERVER + ": " + e.getMessage(), (Throwable)e, 2);
            return false;
        }
        if (InterbrokerConfig.DEBUG) {
            this.displayNetworkData(System.out);
        }
        return true;
    }

    synchronized void activate(Neighbor n) {
        CollectiveGroup cg = n.getGroup();
        cg.activate(n);
        this.m_everyone_active = CollectiveGroup.appendToArray(this.m_everyone_active, n);
        n.activate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnect(Neighbor n) {
        if (n.isActive()) {
            Neighbors neighbors = this;
            synchronized (neighbors) {
                CollectiveGroup cg = n.getGroup();
                cg.deactivate(n);
                this.m_everyone_active = CollectiveGroup.removeFromArray(this.m_everyone_active, n);
            }
        }
        n.disconnect();
    }

    @Override
    public synchronized void IBConfigChanged(IBConfigEvent ibce) {
        boolean interrupted = false;
        while (this.m_removingGroup || this.m_neighborRemovals > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        Interbroker ib = Interbroker.getInterbroker();
        if (ibce instanceof BrokerAddedEvent) {
            if (Config.BROKER_NAME.equals(ibce.getBroker())) {
                ib.queueEvent(new AddGroupEvent((BrokerAddedEvent)ibce));
            } else {
                ib.queueEvent(new AddNeighborEvent((BrokerAddedEvent)ibce));
            }
        } else if (ibce instanceof BrokerRemovedEvent) {
            if (Config.BROKER_NAME.equals(ibce.getBroker())) {
                this.m_removingGroup = true;
                ib.queueEvent(new RemoveGroupEvent((BrokerRemovedEvent)ibce));
            } else {
                ++this.m_neighborRemovals;
                ib.queueEvent(new RemoveNeighborEvent((BrokerRemovedEvent)ibce));
            }
        } else if (ibce instanceof UpdateBrokerEvent) {
            ib.queueEvent(new BrokerHostChangeEvent((UpdateBrokerEvent)ibce));
        } else if (ibce instanceof IBDBReinitEvent) {
            int i;
            IBConfigBean bean = this.m_configMgr.getConfigBean();
            CollectiveGroup[] groups = (CollectiveGroup[])this.m_groups.clone();
            IBConfiguration config = bean.getConfiguration(Config.BROKER_NAME);
            Vector brokers = config.getBrokers();
            Vector hosts = config.getPeerInfos();
            Hashtable brokerHosts = new Hashtable();
            for (int i2 = brokers.size() - 1; i2 >= 0; --i2) {
                brokerHosts.put(brokers.elementAt(i2), hosts.elementAt(i2));
            }
            Vector cols = config.getCollectives();
            Vector membs = config.getCollectiveMembership();
            Vector<String> oldColls = new Vector<String>();
            String collName = null;
            for (i = 0; i < groups.length; ++i) {
                collName = groups[i].getName();
                oldColls.addElement(collName);
                if (cols.contains(collName)) continue;
                if (InterbrokerConfig.DEBUG) {
                    BrokerComponent.getComponentContext().logMessage("Removing: " + Config.BROKER_NAME + " from collective: " + collName, 3);
                }
                this.IBConfigChanged(new BrokerRemovedEvent(bean, 0L, 0, Config.BROKER_NAME, collName));
            }
            for (i = 0; i < cols.size(); ++i) {
                Vector broks = (Vector)membs.elementAt(i);
                int numbroks = broks.size();
                String[] evtmembs = new String[numbroks];
                FTPairPeerInfoHolder[] evthosts = new FTPairPeerInfoHolder[numbroks];
                for (int j = 0; j < numbroks; ++j) {
                    evtmembs[j] = (String)broks.elementAt(j);
                    evthosts[j] = (FTPairPeerInfoHolder)brokerHosts.get(evtmembs[j]);
                }
                if (oldColls.contains(cols.elementAt(i))) continue;
                if (InterbrokerConfig.DEBUG) {
                    BrokerComponent.getComponentContext().logMessage("Adding: " + Config.BROKER_NAME + " to collective: " + (String)cols.elementAt(i), 3);
                }
                this.IBConfigChanged(new BrokerAddedEvent(bean, 0L, 0, Config.BROKER_NAME, InterbrokerConfig.INTERBROKER_IB_CONNECT_INFO, (String)cols.elementAt(i), evtmembs, evthosts));
            }
        }
    }

    void processBrokerHostChange(BrokerHostChangeEvent evt) {
        String bname = evt.getBroker();
        FTPairPeerInfoHolder info = evt.getPeerInfo();
        Neighbor n = this.getByID(AddrUtil.stringToClientId(bname, "Broker"));
        if (n != null) {
            n.setPeerInfo(evt.getPeerInfo(), true);
        } else if (bname.equals(Config.BROKER_NAME) && !info.getPrimaryIBConnectUrls().equals(InterbrokerConfig.INTERBROKER_IB_CONNECT_INFO.getPrimaryIBConnectUrls())) {
            try {
                this.m_configMgr.getConfigBean().newBroker(Config.BROKER_NAME, InterbrokerConfig.INTERBROKER_IB_CONNECT_INFO);
            }
            catch (IOException e) {
                BrokerComponent.getComponentContext().logMessage("Error communicating with interbroker config server: " + e.getMessage(), (Throwable)e, 2);
            }
        }
    }

    void processAddNeighbor(AddNeighborEvent evt) {
        CollectiveGroup g = this.findGroup(evt.getCollective());
        if (g != null) {
            this.addNeighbor(g, evt.getBroker(), evt.getInfo());
        }
    }

    void processAddGroup(AddGroupEvent evt) {
        this.addGroup(evt.getCollective(), evt.getCollectiveMembers(), evt.getMemberInfos());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processRemoveNeighbor(RemoveNeighborEvent evt) {
        CollectiveGroup g = this.findGroup(evt.getCollective());
        if (g == null) {
            Neighbors neighbors = this;
            synchronized (neighbors) {
                --this.m_neighborRemovals;
                this.notifyAll();
                return;
            }
        }
        this.removeNeighbor(g, evt.getBroker());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processRemoveNeighborComplete(RemoveNeighborCompleteEvent evt) {
        CollectiveGroup g = this.findGroup(evt.getCollective());
        long id = AddrUtil.stringToClientId(evt.getBroker(), "Broker");
        Neighbor n = (Neighbor)this.m_everyone.get(id);
        Neighbors neighbors = this;
        synchronized (neighbors) {
            if (g != null && n != null) {
                g.removeNeighbor(n);
                this.m_everyone.remove(id);
                this.m_groups_by_id.remove(id);
                this.m_everyone_by_connect_id.remove(n.getConnectID());
            }
            if (--this.m_neighborRemovals == 0 && this.m_removingGroup) {
                this.removeGroup(this.m_removeGroup);
                this.m_removingGroup = false;
            }
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processRemoveGroup(RemoveGroupEvent evt) {
        CollectiveGroup g = this.findGroup(evt.getCollective());
        if (g == null) {
            Neighbors neighbors = this;
            synchronized (neighbors) {
                this.m_removingGroup = false;
                this.notifyAll();
                return;
            }
        }
        Neighbor[] membs = g.getMembers();
        for (int i = 0; i < membs.length; ++i) {
            ++this.m_neighborRemovals;
            this.removeNeighbor(g, membs[i].getName());
        }
        Neighbors neighbors = this;
        synchronized (neighbors) {
            if (this.m_neighborRemovals == 0) {
                this.removeGroup(g);
                this.m_removingGroup = false;
                this.notifyAll();
            } else {
                this.m_removeGroup = g;
            }
        }
    }

    synchronized void initiateContact() {
        for (int i = 0; i < this.m_groups.length; ++i) {
            Neighbor[] group = this.m_groups[i].getMembers();
            for (int j = 0; j < group.length; ++j) {
                group[j].startConnectThread();
            }
        }
        this.m_contactInitiated = true;
    }

    void stopThreads() {
        Enumeration enu = this.m_everyone.elements();
        while (enu.hasMoreElements()) {
            Neighbor neighbor = (Neighbor)enu.nextElement();
            neighbor.stopConnectThread();
        }
    }

    private CollectiveGroup findGroup(String name) {
        for (int i = 0; i < this.m_groups.length; ++i) {
            if (!this.m_groups[i].getName().equals(name)) continue;
            return this.m_groups[i];
        }
        return null;
    }

    private synchronized void addNeighbor(CollectiveGroup group, String broker, FTPairPeerInfoHolder info) {
        Neighbor n = new Neighbor(broker, info);
        group.addNeighbor(n);
        long key = n.getID();
        this.m_everyone.put(key, n);
        this.m_groups_by_id.put(key, group);
        this.m_everyone_by_connect_id.put(n.getConnectID(), n);
        if (this.m_contactInitiated) {
            n.startConnectThread();
        }
    }

    private void removeNeighbor(CollectiveGroup group, String broker) {
        long id = AddrUtil.stringToClientId(broker, "Broker");
        Neighbor n = (Neighbor)this.m_everyone.get(id);
        if (n != null) {
            n.invalidate();
            AgentRegistrar reg = AgentRegistrar.getAgentRegistrar();
            reg.terminateClient(id);
            reg.terminateClient(n.getConnectID());
        }
        Interbroker.getInterbroker().queueEvent(new RemoveNeighborCompleteEvent(group.getName(), broker));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addGroup(String name, String[] members, FTPairPeerInfoHolder[] hosts) {
        AgentRegistrar reg = AgentRegistrar.getAgentRegistrar();
        reg.lockSubscriptionTable();
        CollectiveGroup g = null;
        try {
            Neighbors neighbors = this;
            synchronized (neighbors) {
                g = new CollectiveGroup(name);
                CollectiveGroup[] newGroups = new CollectiveGroup[this.m_groups.length + 1];
                System.arraycopy(this.m_groups, 0, newGroups, 0, this.m_groups.length);
                newGroups[this.m_groups.length] = g;
                this.m_groups = newGroups;
            }
            Enumeration enu = reg.getAllSubscriptions();
            while (enu.hasMoreElements()) {
                BrokerSubscription bs = (BrokerSubscription)enu.nextElement();
                Label lab = bs.getLabel();
                if (Neighbors.okToForward(this.getGroupByID(bs.getClientId()), g, lab.getRouteLimit())) {
                    lab = Interbroker.markLabelGuaranteedForNonDurableFT(lab, bs.getClient(), bs.getSubject(), true);
                    g.addSubscription(bs.getSubject(), lab);
                    if (!InterbrokerConfig.DEBUG) continue;
                    BrokerComponent.getComponentContext().logMessage("forwarded " + bs + " to " + g, 3);
                    continue;
                }
                if (!InterbrokerConfig.DEBUG) continue;
                BrokerComponent.getComponentContext().logMessage("did *not* forward " + bs + " to " + g, 3);
            }
        }
        finally {
            reg.unlockSubscriptionTable();
        }
        for (int i = 0; i < members.length; ++i) {
            if (Config.BROKER_NAME.equals(members[i])) continue;
            this.addNeighbor(g, members[i], hosts[i]);
        }
    }

    private synchronized void removeGroup(CollectiveGroup g) {
        for (int i = 0; i < this.m_groups.length; ++i) {
            if (this.m_groups[i] != g) continue;
            CollectiveGroup[] newGroups = new CollectiveGroup[this.m_groups.length - 1];
            System.arraycopy(this.m_groups, 0, newGroups, 0, i);
            System.arraycopy(this.m_groups, i + 1, newGroups, i, this.m_groups.length - i - 1);
            this.m_groups = newGroups;
            break;
        }
    }

    private void processNeighbors(IBConfiguration config) throws EGeneralException {
        int i;
        Vector brokers = config.getBrokers();
        Vector infos = config.getPeerInfos();
        for (int i2 = brokers.size() - 1; i2 >= 0; --i2) {
            Neighbor n = new Neighbor((String)brokers.elementAt(i2), (FTPairPeerInfoHolder)infos.elementAt(i2));
            this.m_everyone.put(n.getID(), n);
            this.m_everyone_by_connect_id.put(n.getConnectID(), n);
        }
        Vector<Neighbor> temp = new Vector<Neighbor>();
        Vector cols = config.getCollectives();
        Vector membs = config.getCollectiveMembership();
        this.m_groups = new CollectiveGroup[cols.size()];
        for (i = 0; i < this.m_groups.length; ++i) {
            String gname = (String)cols.elementAt(i);
            Vector gmembs = (Vector)membs.elementAt(i);
            for (int j = gmembs.size() - 1; j >= 0; --j) {
                String bname = (String)gmembs.elementAt(j);
                Neighbor n = (Neighbor)this.m_everyone.get(AddrUtil.stringToClientId(bname, "Broker"));
                if (n == null) {
                    BrokerComponent.getComponentContext().logMessage("Cluster " + gname + " has unknown member " + bname, 2);
                    continue;
                }
                temp.addElement(n);
            }
            this.m_groups[i] = new CollectiveGroup(gname, temp);
            temp.setSize(0);
        }
        for (i = 0; i < this.m_groups.length; ++i) {
            Neighbor[] na = this.m_groups[i].getMembers();
            for (int j = 0; j < na.length; ++j) {
                this.m_groups_by_id.put(na[j].getID(), this.m_groups[i]);
            }
        }
    }

    private void displayNetworkData(PrintStream out) {
        out.println(prAccessor.getString("STR067"));
        for (int i = 0; i < this.m_groups.length; ++i) {
            out.println(this.m_groups[i].toString());
        }
    }
}

