/*
 * Decompiled with CFR 0.152.
 */
package progress.message.interbroker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.EOFException;
import java.io.IOException;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.SubscribeEvt;
import progress.message.broker.parser.ParseException;
import progress.message.broker.parser.TokenMgrError;
import progress.message.util.WrappedDataInputStream;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.ISubject;
import progress.message.zclient.Label;
import progress.message.zclient.Message;
import progress.message.zclient.Session;
import progress.message.zclient.Subject;

class SubscriptionListXfer
implements IMessageHandler {
    private AgentRegistrar m_reg;

    SubscriptionListXfer(AgentRegistrar reg) {
        this.m_reg = reg;
    }

    @Override
    public void handleMessage(Session s, Envelope env) {
        try {
            Message m = env.getMessage();
            long id = m.readLong();
            short type = m.readShort();
            if (type == 1) {
                while (true) {
                    WrappedDataInputStream dis = new WrappedDataInputStream(m);
                    ISubject subject = Subject.createFromStream(dis);
                    SubscribeEvt evt = new SubscribeEvt(null, id, subject, Label.unserialize(m));
                    this.m_reg.subscribe(evt);
                }
            }
        }
        catch (EOFException m) {
        }
        catch (EClientNotRegistered m) {
        }
        catch (IOException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
        catch (ParseException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
        catch (TokenMgrError e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
    }
}

