/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl;

import java.io.EOFException;
import java.io.IOException;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import progress.message.client.EGeneralException;
import progress.message.jimpl.JMSExceptionUtil;
import progress.message.jimpl.Message;
import progress.message.util.jclient.StreamMessageInputStream;
import progress.message.util.jclient.StreamMessageOutputStream;
import progress.message.zclient.Envelope;

public class StreamMessage
extends Message
implements progress.message.jclient.StreamMessage {
    private StreamMessageInputStream m_in = null;
    private StreamMessageOutputStream m_out = null;

    StreamMessage(Envelope envelope) {
        super(envelope);
        this.m_out = null;
        this.m_in = new StreamMessageInputStream(this.m_zenvelope.getMessage());
    }

    public StreamMessage() {
        super((short)5);
        this.m_in = null;
        this.m_out = new StreamMessageOutputStream(this.m_zenvelope.getMessage());
    }

    @Override
    public Object clone() {
        StreamMessage msg = (StreamMessage)super.clone();
        return this.cloneCheckingMOut(msg);
    }

    @Override
    public Object protectedClone() {
        StreamMessage msg = (StreamMessage)super.protectedClone();
        return this.cloneCheckingMOut(msg);
    }

    private StreamMessage cloneCheckingMOut(StreamMessage msg) {
        if (this.m_out == null) {
            msg.m_in = new StreamMessageInputStream(msg.m_zenvelope.getMessage());
        } else {
            msg.m_out = new StreamMessageOutputStream(msg.m_zenvelope.getMessage());
        }
        return msg;
    }

    public boolean readBoolean() throws JMSException {
        this.checkIsBodyReadOnly();
        try {
            return this.m_in.readBoolean();
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    public byte readByte() throws JMSException {
        this.checkIsBodyReadOnly();
        try {
            return this.m_in.readByte();
        }
        catch (EOFException e) {
            throw StreamMessage.createMessageEOFException(e);
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    public short readShort() throws JMSException {
        this.checkIsBodyReadOnly();
        try {
            return this.m_in.readShort();
        }
        catch (EOFException e) {
            throw StreamMessage.createMessageEOFException(e);
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    public char readChar() throws JMSException {
        this.checkIsBodyReadOnly();
        try {
            return this.m_in.readChar();
        }
        catch (EOFException e) {
            throw StreamMessage.createMessageEOFException(e);
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    public int readInt() throws JMSException {
        this.checkIsBodyReadOnly();
        try {
            return this.m_in.readInt();
        }
        catch (EOFException e) {
            throw StreamMessage.createMessageEOFException(e);
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    public long readLong() throws JMSException {
        this.checkIsBodyReadOnly();
        try {
            return this.m_in.readLong();
        }
        catch (EOFException e) {
            throw StreamMessage.createMessageEOFException(e);
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    public float readFloat() throws JMSException {
        this.checkIsBodyReadOnly();
        try {
            return this.m_in.readFloat();
        }
        catch (EOFException e) {
            throw StreamMessage.createMessageEOFException(e);
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    public double readDouble() throws JMSException {
        this.checkIsBodyReadOnly();
        try {
            return this.m_in.readDouble();
        }
        catch (EOFException e) {
            throw StreamMessage.createMessageEOFException(e);
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    public String readString() throws JMSException {
        this.checkIsBodyReadOnly();
        try {
            return this.m_in.readString();
        }
        catch (EOFException e) {
            throw StreamMessage.createMessageEOFException(e);
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    public int readBytes(byte[] value) throws JMSException {
        this.checkIsBodyReadOnly();
        try {
            return this.m_in.readBytes(value);
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    public Object readObject() throws JMSException {
        this.checkIsBodyReadOnly();
        try {
            return this.m_in.readObject();
        }
        catch (EOFException e) {
            throw StreamMessage.createMessageEOFException(e);
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    private void checkIsBodyReadOnly() throws MessageNotReadableException {
        if (!this.m_bodyReadOnly) {
            throw new MessageNotReadableException("");
        }
    }

    private static MessageEOFException createMessageEOFException(EOFException e) {
        MessageEOFException exc = new MessageEOFException(e.getMessage());
        exc.setLinkedException(e);
        return exc;
    }

    public void writeBoolean(boolean value) throws JMSException {
        if (this.m_bodyReadOnly) {
            throw new MessageNotWriteableException("");
        }
        try {
            this.m_out.writeBoolean(value);
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    public void writeByte(byte value) throws JMSException {
        if (this.m_bodyReadOnly) {
            throw new MessageNotWriteableException("");
        }
        try {
            this.m_out.writeByte(value);
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    public void writeShort(short value) throws JMSException {
        if (this.m_bodyReadOnly) {
            throw new MessageNotWriteableException("");
        }
        try {
            this.m_out.writeShort(value);
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    public void writeChar(char value) throws JMSException {
        if (this.m_bodyReadOnly) {
            throw new MessageNotWriteableException("");
        }
        try {
            this.m_out.writeChar(value);
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    public void writeInt(int value) throws JMSException {
        if (this.m_bodyReadOnly) {
            throw new MessageNotWriteableException("");
        }
        try {
            this.m_out.writeInt(value);
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    public void writeLong(long value) throws JMSException {
        if (this.m_bodyReadOnly) {
            throw new MessageNotWriteableException("");
        }
        try {
            this.m_out.writeLong(value);
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    public void writeFloat(float value) throws JMSException {
        if (this.m_bodyReadOnly) {
            throw new MessageNotWriteableException("");
        }
        try {
            this.m_out.writeFloat(value);
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    public void writeDouble(double value) throws JMSException {
        if (this.m_bodyReadOnly) {
            throw new MessageNotWriteableException("");
        }
        try {
            this.m_out.writeDouble(value);
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    public void writeString(String value) throws JMSException {
        if (this.m_bodyReadOnly) {
            throw new MessageNotWriteableException("");
        }
        try {
            if (value != null) {
                this.m_out.writeString(value);
            } else {
                this.writeObject(value);
            }
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    public void writeBytes(byte[] value) throws JMSException {
        if (this.m_bodyReadOnly) {
            throw new MessageNotWriteableException("");
        }
        try {
            if (value != null) {
                this.m_out.writeBytes(value);
            } else {
                this.writeObject(value);
            }
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        if (this.m_bodyReadOnly) {
            throw new MessageNotWriteableException("");
        }
        try {
            if (value == null || length == 0) {
                this.writeObject(value);
            } else {
                this.m_out.writeBytes(value, offset, length);
            }
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    public void writeObject(Object value) throws JMSException {
        if (this.m_bodyReadOnly) {
            throw new MessageNotWriteableException("");
        }
        try {
            this.m_out.writeObject(value);
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    public void reset() throws JMSException {
        this.m_bodyReadOnly = true;
        this.m_propertiesReadOnly = true;
        this.m_out = null;
        try {
            if (this.m_zenvelope.getMessage().cap() != 0) {
                this.m_zenvelope.getMessage().gotoByte(0);
            }
        }
        catch (EGeneralException ege) {
            throw JMSExceptionUtil.createJMSException(ege);
        }
        catch (IOException ioe) {
            throw JMSExceptionUtil.createJMSException(ioe);
        }
        this.m_in = new StreamMessageInputStream(this.m_zenvelope.getMessage());
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this.m_in = null;
        this.m_out = new StreamMessageOutputStream(this.m_zenvelope.getMessage());
    }
}

