/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl.xmessage;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import progress.message.client.prAccessor;
import progress.message.jimpl.xmessage.ObjectRegistry;
import progress.message.resources.prMessageFormat;

public final class XMLUtils {
    public static final String lineSeparator = System.getProperty("XMLWriter.lineSeparator", "\n");
    private static String NS_URI_XMLNS = "http://www.w3.org/2000/xmlns/";

    public static String xmlDecode(String s) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        StringBuffer sb = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            int c = s.charAt(i);
            if (c == 38) {
                String ss = s.substring(i).toLowerCase();
                if (ss.startsWith("&lt;")) {
                    c = 60;
                    i += 3;
                } else if (ss.startsWith("&gt;")) {
                    c = 62;
                    i += 3;
                } else if (ss.startsWith("&amp;")) {
                    c = 38;
                    i += 4;
                } else if (ss.startsWith("&quot;")) {
                    c = 34;
                    i += 5;
                } else if (ss.startsWith("&apos;")) {
                    c = 39;
                    i += 5;
                }
            }
            sb.append((char)c);
        }
        return sb.toString();
    }

    public static String xmlEncode(String s) {
        if (s == null) {
            return "";
        }
        int len = s.length();
        StringBuffer sb = new StringBuffer(len);
        block7: for (int i = 0; i < len; ++i) {
            switch (s.charAt(i)) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                default: {
                    sb.append(s.charAt(i));
                }
            }
        }
        return sb.toString();
    }

    public static Node copyNode(Document doc, Node node) {
        Node ret = null;
        switch (node.getNodeType()) {
            case 1: {
                ret = doc.createElement(node.getNodeName());
                NamedNodeMap nnm = node.getAttributes();
                for (int i = 0; i < nnm.getLength(); ++i) {
                    Node a = nnm.item(i);
                    ((Element)ret).setAttribute(a.getNodeName(), a.getNodeValue());
                }
                break;
            }
            case 3: {
                ret = doc.createTextNode(node.getNodeValue());
                break;
            }
            case 4: {
                ret = doc.createCDATASection(node.getNodeValue());
                break;
            }
            case 2: {
                ret = doc.createAttribute(node.getNodeName());
                doc.appendChild(ret);
                break;
            }
            case 7: {
                ret = doc.createProcessingInstruction(node.getNodeName(), node.getNodeValue());
                break;
            }
            case 8: {
                ret = doc.createComment(node.getNodeValue());
                break;
            }
            case 5: {
                ret = doc.createEntityReference(node.getNodeName());
                break;
            }
            case 9: {
                ret = node;
                break;
            }
            default: {
                String msgf = prAccessor.getString("XMLUTIL_UNKNOWN_NODE");
                Object[] obj = new Object[]{Integer.toString(node.getNodeType())};
                throw new RuntimeException(prMessageFormat.format(msgf, obj));
            }
        }
        if (ret != null && node.hasChildNodes()) {
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                ret.insertBefore(XMLUtils.copyNode(doc, child), null);
            }
        }
        return ret;
    }

    public static String nodeToString(Node node) {
        StringWriter sw = new StringWriter();
        XMLUtils.serializeAsXML(node, sw);
        return sw.toString();
    }

    public static void serializeAsXML(Node node, Writer writer) {
        XMLUtils.print(node, null, new PrintWriter(writer));
    }

    private static void print(Node node, ObjectRegistry namespaceStackParam, PrintWriter out) {
        ObjectRegistry namespaceStack = namespaceStackParam;
        if (node == null) {
            return;
        }
        boolean hasChildren = false;
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                out.println("<?xml version=\"1.0\"?>");
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int numChildren = children.getLength();
                XMLUtils.printChildrenItems(children, namespaceStack, numChildren, out);
                break;
            }
            case 1: {
                namespaceStack = new ObjectRegistry(namespaceStack);
                out.print('<' + node.getNodeName());
                XMLUtils.processNameSpace(node, namespaceStack, out);
                NamedNodeMap attrs = node.getAttributes();
                int len = attrs != null ? attrs.getLength() : 0;
                for (int i = 0; i < len; ++i) {
                    Attr attr = (Attr)attrs.item(i);
                    out.print(' ' + attr.getNodeName() + "=\"" + XMLUtils.normalize(attr.getValue()) + '\"');
                    XMLUtils.processNameSpace(attr, namespaceStack, out);
                }
                NodeList children = node.getChildNodes();
                if (children != null) {
                    int numChildren = children.getLength();
                    boolean bl = hasChildren = numChildren > 0;
                    if (hasChildren) {
                        out.print('>');
                    }
                    XMLUtils.printChildrenItems(children, namespaceStack, numChildren, out);
                } else {
                    hasChildren = false;
                }
                if (hasChildren) break;
                out.print("/>");
                break;
            }
            case 5: {
                out.print('&');
                out.print(node.getNodeName());
                out.print(';');
                break;
            }
            case 4: {
                out.print("<![CDATA[");
                out.print(node.getNodeValue());
                out.print("]]>");
                break;
            }
            case 3: {
                out.print(XMLUtils.normalize(node.getNodeValue()));
                break;
            }
            case 8: {
                out.print("<!--");
                out.print(node.getNodeValue());
                out.print("-->");
                break;
            }
            case 7: {
                out.print("<?");
                out.print(node.getNodeName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    out.print(' ');
                    out.print(data);
                }
                out.println("?>");
                break;
            }
        }
        if (type == 1 && hasChildren) {
            out.print("</");
            out.print(node.getNodeName());
            out.print('>');
            hasChildren = false;
        }
    }

    private static <T0 extends Node> void processNameSpace(T0 attr, ObjectRegistry namespaceStack, PrintWriter out) {
        String attrPrefix = attr.getPrefix();
        String attrNamespaceURI = attr.getNamespaceURI();
        if (attrPrefix != null && attrNamespaceURI != null) {
            boolean prefixIsDeclared = false;
            try {
                String namespaceURI = (String)namespaceStack.lookup(attrPrefix);
                if (attrNamespaceURI.equals(namespaceURI)) {
                    prefixIsDeclared = true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (!prefixIsDeclared) {
                XMLUtils.printNamespaceDecl(attr, namespaceStack, out);
            }
        }
    }

    private static void printChildrenItems(NodeList children, ObjectRegistry namespaceStack, int numChildren, PrintWriter out) {
        for (int i = 0; i < numChildren; ++i) {
            XMLUtils.print(children.item(i), namespaceStack, out);
        }
    }

    private static void printNamespaceDecl(Node node, ObjectRegistry namespaceStack, PrintWriter out) {
        switch (node.getNodeType()) {
            case 2: {
                XMLUtils.printNamespaceDecl(((Attr)node).getOwnerElement(), node, namespaceStack, out);
                break;
            }
            case 1: {
                XMLUtils.printNamespaceDecl((Element)node, node, namespaceStack, out);
                break;
            }
        }
    }

    private static void printNamespaceDecl(Element owner, Node node, ObjectRegistry namespaceStack, PrintWriter out) {
        String namespaceURI = node.getNamespaceURI();
        String prefix = node.getPrefix();
        if (!namespaceURI.equals(NS_URI_XMLNS) || !prefix.equals("xmlns")) {
            if (XMLUtils.getAttributeNS(owner, NS_URI_XMLNS, prefix) == null) {
                out.print(" xmlns:" + prefix + "=\"" + namespaceURI + '\"');
            }
        } else {
            prefix = node.getLocalName();
            namespaceURI = node.getNodeValue();
        }
        namespaceStack.register(prefix, namespaceURI);
    }

    private static String normalize(String s) {
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        block7: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    continue block7;
                }
                case '>': {
                    str.append("&gt;");
                    continue block7;
                }
                case '&': {
                    str.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    str.append("&quot;");
                    continue block7;
                }
                case '\n': {
                    if (i > 0) {
                        char lastChar = str.charAt(str.length() - 1);
                        if (lastChar != '\r') {
                            str.append(lineSeparator);
                            continue block7;
                        }
                        str.append('\n');
                        continue block7;
                    }
                    str.append(lineSeparator);
                    continue block7;
                }
                default: {
                    str.append(ch);
                }
            }
        }
        return str.toString();
    }

    public static String getAttribute(Element el, String attrName) {
        String sRet = null;
        Attr attr = el.getAttributeNode(attrName);
        if (attr != null) {
            sRet = attr.getValue();
        }
        return sRet;
    }

    public static String getAttributeNS(Element el, String namespaceURI, String localPart) {
        String sRet = null;
        Attr attr = el.getAttributeNodeNS(namespaceURI, localPart);
        if (attr != null) {
            sRet = attr.getValue();
        }
        return sRet;
    }
}

