/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v24;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.msg.v24.DynamicHeader;
import progress.message.msg.v24.Mgram;
import progress.message.msg.v24.SecureDynamicHeader;
import progress.message.util.ArrayUtil;
import progress.message.util.StreamUtil;
import progress.message.zclient.IMessageProtection;

public final class DefaultDynamicHeader
extends DynamicHeader {
    private int m_messageLen = 0;
    private static final int DEFAULT_DYNAMIC_HEADER_LEN = 4;

    @Override
    public Object clone(Mgram m) throws CloneNotSupportedException {
        return super.clone(m);
    }

    @Override
    public Object shallowClone(Mgram m) throws CloneNotSupportedException {
        return super.shallowClone(m);
    }

    public DefaultDynamicHeader(Mgram m) {
        super(m);
    }

    @Override
    void initDynamicHeaderFromStream(InputStream is) throws IOException {
        this.m_messageLen = StreamUtil.readInt(is);
        this.m_mgram.setStatus(2);
    }

    @Override
    public void setMessageLength(int length) {
        this.m_messageLen = length;
    }

    @Override
    public int getMessageLength() {
        int length;
        if (this.m_mgram == null || this.m_mgram.getStatus() < 3) {
            return this.m_messageLen;
        }
        this.m_messageLen = length = this.m_mgram.getPayloadLength();
        return this.m_messageLen;
    }

    @Override
    byte[] toByteArray() {
        byte[] result = new byte[4];
        ArrayUtil.writeInt(result, 0, this.m_mgram.getPayloadLength());
        return result;
    }

    @Override
    int length() {
        return 4;
    }

    @Override
    public void writeToStream(OutputStream os) throws IOException {
        StreamUtil.writeInt(this.getMessageLength(), os);
    }

    @Override
    public void writeToStream(OutputStream os, IMessageProtection m_mp) throws IOException {
        this.writeToStream(os);
    }

    @Override
    void sync() {
    }

    @Override
    DynamicHeader getSecureDynamicHeader(IMessageProtection mp) {
        SecureDynamicHeader sdh = new SecureDynamicHeader(mp, this);
        return sdh;
    }

    @Override
    DynamicHeader getNonSecureDynamicHeader() {
        return this;
    }
}

