/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v24;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.msg.IMgram;
import progress.message.msg.IMgramStatusListener;
import progress.message.util.ArrayUtil;
import progress.message.util.EAssertFailure;
import progress.message.util.StreamUtil;
import progress.message.zclient.EMgramVersionMismatch;
import progress.message.zclient.prAccessor;

public final class StaticHeader
implements Cloneable {
    private static final byte JMS_PERSIST_MASK = 4;
    private static final byte TXN_MASK = 8;
    private static final byte SUCSR_MASK = 16;
    private static final byte TXNPUBLISH_MASK = 32;
    private static final int RTE_MASK1 = 3;
    private static final int RTE_SHIFT1 = 1;
    private static final byte GUAR_MASK = 4;
    private static final byte TTE_MASK = 8;
    private static final int SECURITY_MASK = 16;
    private static final byte DISCARDABLE_MASK = 32;
    private static final byte ID_MASK = 64;
    private static final byte RRS_MASK = 3;
    private static final int RTE_MASK2 = 128;
    private static final int RTE_SHIFT2 = 7;
    private byte m_type = (byte)2;
    private byte m_priority = 0;
    private byte m_version = (byte)24;
    private byte m_bitField1;
    private byte m_bitField2;
    private byte m_afByte;
    private int m_daf;
    private int m_saf;
    private long m_tte = 0L;
    private int m_channel;
    private int m_rrs;
    private boolean m_isGuarenteed;
    private boolean m_isTxn;
    private boolean m_isTxnPublish;
    private boolean m_isSuccessor;
    private boolean m_isJMSPersistent = false;
    private boolean m_isDiscardable = false;
    private boolean m_isSecure = false;
    private boolean m_hasTTE = false;
    private boolean m_isTTE_TTL = false;
    private boolean m_idPresent;
    private boolean m_isPostSV22;
    private byte m_sessionVers = (byte)22;
    private boolean m_hasSessionVers = false;
    private static final byte POST_V22_MASK = 1;
    private static final byte HAS_SESSION_VER_MASK = 2;
    private int m_routeLimit = 7;
    public static final int HEADER_LEN = 20;
    private static final int s_versionLoc = 0;
    private static final int s_typeLoc = 1;
    private static final int s_priorityLoc = 2;
    private static final int s_postSV22Loc = 2;
    private static final int s_sessionVersByteLoc = 2;
    private static final int s_bitField1Loc = 5;
    private static final int s_bitField2Loc = 6;
    private static final int s_afByteLoc = 7;
    private static final int s_tteLoc = 8;
    private static final int s_channelLoc = 16;
    private byte[] m_staticHeaderBuffer = null;
    private boolean m_staticHeaderDirty = false;
    private static byte[] s_initialStaticBuffer = null;
    private IMgramStatusListener m_listener = null;
    private IMgram m_mgram;

    StaticHeader() {
        this(true);
    }

    private StaticHeader(boolean initialize) {
        if (initialize) {
            this.m_staticHeaderBuffer = new byte[20];
            System.arraycopy(s_initialStaticBuffer, 0, this.m_staticHeaderBuffer, 0, 20);
        } else {
            this.m_staticHeaderDirty = true;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        StaticHeader sh = (StaticHeader)super.clone();
        if (this.m_staticHeaderBuffer != null) {
            sh.m_staticHeaderBuffer = new byte[sh.m_staticHeaderBuffer.length];
            System.arraycopy(this.m_staticHeaderBuffer, 0, sh.m_staticHeaderBuffer, 0, sh.m_staticHeaderBuffer.length);
        } else {
            sh.m_staticHeaderBuffer = null;
        }
        return sh;
    }

    public Object shallowClone() throws CloneNotSupportedException {
        StaticHeader sh = (StaticHeader)super.clone();
        return sh;
    }

    public StaticHeader(IMgramStatusListener ml, IMgram m) {
        this.m_listener = ml;
        this.m_mgram = m;
        this.m_staticHeaderBuffer = new byte[20];
        this.m_staticHeaderDirty = true;
    }

    public void initStaticHeaderFromStream(InputStream is, boolean tteTTLConvert) throws IOException, EMgramVersionMismatch {
        if (this.m_listener != null) {
            this.m_listener.setStatus((byte)0);
        }
        StreamUtil.readBytes(is, this.m_staticHeaderBuffer, 0, 1);
        if (this.m_listener != null) {
            this.m_listener.setStatus((byte)1);
        }
        StreamUtil.readBytes(is, this.m_staticHeaderBuffer, 1, 19);
        this.m_version = this.m_staticHeaderBuffer[0];
        this.m_type = this.m_staticHeaderBuffer[1];
        if (this.m_type == 4) {
            this.initVersionMgram(is);
        } else {
            this.initStaticHeader(is, tteTTLConvert);
        }
        if (this.m_mgram != null) {
            this.m_mgram.setStatus(1);
        }
    }

    void initVersionMgram(InputStream is) throws IOException {
        boolean bl = this.m_isPostSV22 = (this.m_staticHeaderBuffer[2] & 1) > 0;
        if ((this.m_staticHeaderBuffer[2] & 2) > 0) {
            this.m_sessionVers = StreamUtil.readByte(is);
            this.m_hasSessionVers = true;
        }
    }

    private void initStaticHeader(InputStream is, boolean tteTTLConvert) throws EMgramVersionMismatch {
        if (this.m_type != 4 && this.m_version != 24) {
            throw new EMgramVersionMismatch(this.m_version);
        }
        this.m_priority = this.m_staticHeaderBuffer[2];
        this.m_bitField1 = this.m_staticHeaderBuffer[5];
        this.m_bitField2 = this.m_staticHeaderBuffer[6];
        this.m_afByte = this.m_staticHeaderBuffer[7];
        this.m_daf = this.m_afByte & 0xF;
        this.m_saf = (this.m_afByte & 0xF0) >>> 4;
        this.m_channel = ArrayUtil.readInt(this.m_staticHeaderBuffer, 16);
        this.m_rrs = this.m_bitField2 & 3 & 0xFF;
        this.m_isGuarenteed = (this.m_bitField2 & 4) > 0;
        this.m_isTxn = (this.m_bitField1 & 8) != 0;
        this.m_isTxnPublish = (this.m_bitField1 & 0x20) != 0;
        this.m_isSuccessor = (this.m_bitField1 & 0x10) != 0;
        this.m_isJMSPersistent = (this.m_bitField1 & 4) != 0;
        this.m_hasTTE = (this.m_bitField2 & 8) != 0;
        this.m_isTTE_TTL = tteTTLConvert;
        this.m_isSecure = (this.m_bitField2 & 0x10) != 0;
        this.m_isDiscardable = (this.m_bitField2 & 0x20) != 0;
        this.m_idPresent = (this.m_bitField2 & 0x40) != 0;
        this.m_routeLimit = (this.m_bitField1 & 3) << 1 | (this.m_bitField2 & 0x80) >>> 7;
        this.m_staticHeaderDirty = false;
    }

    public void writeToStream(OutputStream os, int channel, boolean tteTTLConvert) throws IOException {
        if (this.m_staticHeaderDirty) {
            this.syncBitFields();
            os.write(this.m_version);
            os.write(this.m_type);
            os.write(this.m_priority);
            os.write(0);
            os.write(0);
            os.write(this.m_bitField1);
            os.write(this.m_bitField2);
            os.write(this.m_afByte);
            if (tteTTLConvert && this.m_hasTTE) {
                StreamUtil.writeLong(this.m_tte - System.currentTimeMillis(), os);
            } else {
                StreamUtil.writeLong(this.m_tte, os);
            }
            if (channel == -1) {
                StreamUtil.writeInt(this.m_channel, os);
            } else {
                StreamUtil.writeInt(channel, os);
            }
            if (this.m_hasSessionVers) {
                os.write(this.m_sessionVers);
            }
        } else {
            if (tteTTLConvert && this.m_hasTTE) {
                ArrayUtil.writeLong(this.m_staticHeaderBuffer, 8, this.m_tte - System.currentTimeMillis());
            }
            os.write(this.m_staticHeaderBuffer);
            if (this.m_hasSessionVers) {
                os.write(this.m_sessionVers);
            }
        }
    }

    public void setPostV22(boolean value) {
        this.checkIsVersionType();
        this.m_isPostSV22 = value;
        this.m_staticHeaderBuffer[2] = value ? (byte)(this.m_staticHeaderBuffer[2] | 1) : (byte)(this.m_staticHeaderBuffer[2] & 0xFFFFFFFE);
    }

    public void setSessionVer(byte ver) {
        this.checkIsVersionType();
        this.m_sessionVers = ver;
        this.m_hasSessionVers = true;
        this.m_staticHeaderBuffer[2] = (byte)(this.m_staticHeaderBuffer[2] | 2);
    }

    public boolean hasSessionVer() {
        return this.m_hasSessionVers;
    }

    public boolean isRequest() {
        return this.getRequestReplyFieldType() == 2;
    }

    public boolean isSend() {
        return this.getRequestReplyFieldType() == 0;
    }

    public boolean isPostSV22() {
        return this.m_isPostSV22;
    }

    public boolean isReply() {
        return this.getRequestReplyFieldType() == 3;
    }

    public boolean isSecure() {
        return this.m_isSecure;
    }

    public void setMgramSecure(boolean value) {
        if (value != this.m_isSecure) {
            this.m_isSecure = value;
            this.m_staticHeaderDirty = true;
        }
    }

    public void setPriority(byte value) {
        if (value != this.m_priority) {
            this.m_priority = value;
            if (!this.m_staticHeaderDirty) {
                this.m_staticHeaderBuffer[2] = this.m_priority;
            }
        }
    }

    public boolean hasID() {
        return this.m_idPresent;
    }

    public void enableID() {
        this.m_idPresent = true;
        this.syncBitFields();
    }

    public boolean hasTTE() {
        return this.m_hasTTE;
    }

    public void enableTTE(boolean value) {
        if (this.m_hasTTE != value) {
            this.m_hasTTE = value;
            this.m_staticHeaderDirty = true;
        }
    }

    public boolean isGuarenteed() {
        return this.m_isGuarenteed;
    }

    public void setGuarenteed(boolean val) {
        this.m_isGuarenteed = val;
        this.syncBitFields();
    }

    public boolean hasTxn() {
        return this.m_isTxn;
    }

    public boolean isTxnPublish() {
        return this.m_isTxnPublish;
    }

    public void setTxnPublish(boolean val) {
        this.m_isTxnPublish = val;
        this.syncBitFields();
    }

    public void setTTE(long value) {
        if (this.m_tte != value) {
            this.m_hasTTE = value != 0L;
            this.m_tte = value;
            this.m_staticHeaderDirty = true;
            this.m_isTTE_TTL = false;
        }
    }

    void isTTE_TTL(boolean value) {
        this.m_isTTE_TTL = false;
    }

    public void setTxn(boolean val) {
        this.m_isTxn = val;
        this.syncBitFields();
    }

    public int getDestinationAddressFormat() {
        return this.m_daf;
    }

    void clearAddresses() {
        this.setDestinationAddressFormat(0);
    }

    public int getSourceAddressFormat() {
        return this.m_saf;
    }

    public int getRequestReplyFieldType() {
        return this.m_rrs;
    }

    public int getRouteLimit() {
        return this.m_routeLimit;
    }

    public long getTTE() {
        if (this.hasTTE() && this.m_tte == 0L) {
            this.m_tte = ArrayUtil.readLong(this.m_staticHeaderBuffer, 8);
            if (this.m_isTTE_TTL) {
                this.m_tte = System.currentTimeMillis() + this.m_tte;
                this.m_isTTE_TTL = false;
            }
        }
        return this.m_tte;
    }

    public void setRouteLimit(int routeLimit) {
        if (routeLimit != this.m_routeLimit) {
            this.m_routeLimit = routeLimit;
            this.syncBitFields();
        }
    }

    public boolean isSuccessor() {
        return this.m_isSuccessor;
    }

    public void setSuccessor(boolean value) {
        if (value != this.m_isSuccessor) {
            this.m_isSuccessor = value;
            this.syncBitFields();
        }
    }

    public boolean isJMSPersistent() {
        return this.m_isJMSPersistent;
    }

    public void setJMSPersistent(boolean value) {
        if (value != this.m_isJMSPersistent) {
            this.m_isJMSPersistent = value;
            this.syncBitFields();
        }
    }

    public void setDiscardable(boolean value) {
        if (value != this.m_isDiscardable) {
            this.m_isDiscardable = value;
            this.syncBitFields();
        }
    }

    public boolean isDiscardable() {
        return this.m_isDiscardable;
    }

    public byte getType() {
        return this.m_type;
    }

    public void setType(byte type) {
        if (this.m_type != type) {
            this.m_staticHeaderBuffer[1] = this.m_type = type;
        }
    }

    public int getChannel() {
        return this.m_channel;
    }

    public void setChannel(int channel) {
        if (this.m_channel != channel) {
            this.m_channel = channel;
            ArrayUtil.writeInt(this.m_staticHeaderBuffer, 16, this.m_channel);
        }
    }

    public byte getPriority() {
        return this.m_priority;
    }

    public void setRequestReplyType(int value) {
        this.m_rrs = value;
        this.syncBitFields();
    }

    public void setDestinationAddressFormat(int daf) {
        this.m_daf = daf;
        this.syncBitFields();
    }

    boolean canHaveReplyTracking() {
        return this.m_rrs == 3 && this.m_daf == 3;
    }

    public void sync() {
        if (this.m_staticHeaderDirty) {
            byte[] newStaticHeader = new byte[20];
            ByteArrayOutputStream bos = new ByteArrayOutputStream(20);
            try {
                this.writeToStream(bos, -1, false);
                bos.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.m_staticHeaderBuffer = bos.toByteArray();
            this.m_staticHeaderDirty = false;
        }
    }

    public byte[] toByteArray() {
        this.sync();
        byte[] result = new byte[20];
        System.arraycopy(this.m_staticHeaderBuffer, 0, result, 0, 20);
        return result;
    }

    public byte[] getRawHeader() {
        this.sync();
        return this.m_staticHeaderBuffer;
    }

    int length() {
        return 20;
    }

    public byte getVersion() {
        return this.m_version;
    }

    public void setVersion(byte version) {
        this.m_version = version;
        this.m_staticHeaderBuffer[0] = version;
    }

    private void syncBitFields() {
        this.m_bitField1 = (byte)((this.m_isTxnPublish ? 1 : 0) << 5 | (this.m_isSuccessor ? 1 : 0) << 4 | (this.m_isTxn ? 1 : 0) << 3 | (this.m_isJMSPersistent ? 1 : 0) << 2 | (this.m_routeLimit & 6) >> 1);
        this.m_bitField2 = (byte)((this.m_routeLimit & 1) << 7 | (this.m_idPresent ? 1 : 0) << 6 | (this.m_isDiscardable ? 1 : 0) << 5 | (this.m_isSecure ? 1 : 0) << 4 | (this.m_hasTTE ? 1 : 0) << 3 | (this.m_isGuarenteed ? 1 : 0) << 2 | this.m_rrs & 3);
        this.m_afByte = (byte)((this.m_saf & 0xF) << 4 | this.m_daf & 0xF);
        if (!this.m_staticHeaderDirty && this.m_staticHeaderBuffer != null) {
            this.m_staticHeaderBuffer[5] = this.m_bitField1;
            this.m_staticHeaderBuffer[6] = this.m_bitField2;
            this.m_staticHeaderBuffer[7] = this.m_afByte;
            if (this.m_hasSessionVers) {
                this.m_staticHeaderBuffer[2] = (byte)(this.m_staticHeaderBuffer[2] | 2);
            }
        } else {
            this.m_staticHeaderDirty = true;
        }
    }

    public byte getSessionVersion() {
        this.checkIsVersionType();
        return this.m_sessionVers;
    }

    private void checkIsVersionType() throws EAssertFailure {
        if (this.m_type != 4) {
            throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
        }
    }

    static {
        StaticHeader header = new StaticHeader(false);
        header.sync();
        s_initialStaticBuffer = header.m_staticHeaderBuffer;
    }
}

