/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v25;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import progress.message.msg.IAckHandle;
import progress.message.msg.IWindowAckHandle;
import progress.message.msg.StreamUtilCounter;
import progress.message.msg.v25.Mgram;
import progress.message.msg.v25.Payload;
import progress.message.util.ArrayUtil;
import progress.message.util.EAssertFailure;
import progress.message.util.MemoryUtil;
import progress.message.util.StreamUtil;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.SessionConfig;

public final class AckPayload
extends Payload
implements IAckHandle,
IWindowAckHandle {
    static final int s_ackMemSize = MemoryUtil.estimateBaseSize(AckPayload.class);
    static final byte ACK_PAYLOAD_LENGTH = 16;
    private static int s_trackingPos = 0;
    private static int s_errPos = s_trackingPos + 6;
    private static int s_clientIdPos = s_errPos + 2;
    private boolean m_preBodyDirty = false;
    private byte[] m_preBodyBuffer = null;
    private long m_guarTrackingNum = -1L;
    private boolean m_isGuarenteedInit = false;
    private long m_trackingNum;
    private short m_err;
    private long m_longField;
    private int m_txnId;
    private boolean m_hasTxnIdInit = false;
    private byte[] m_bodyBuffer = new byte[16];

    public AckPayload(Mgram m) {
        super(m);
    }

    @Override
    protected boolean isDirty() {
        return this.m_preBodyDirty;
    }

    @Override
    public Object clone(Mgram m) throws CloneNotSupportedException {
        AckPayload ap = (AckPayload)super.clone();
        ap.m_mgram = m;
        if (this.m_preBodyBuffer != null && !this.m_preBodyDirty) {
            ap.m_preBodyBuffer = new byte[this.m_preBodyBuffer.length];
            System.arraycopy(this.m_preBodyBuffer, 0, ap.m_preBodyBuffer, 0, this.m_preBodyBuffer.length);
        } else {
            ap.m_preBodyBuffer = null;
        }
        ap.m_bodyBuffer = new byte[this.m_bodyBuffer.length];
        System.arraycopy(this.m_bodyBuffer, 0, ap.m_bodyBuffer, 0, this.m_bodyBuffer.length);
        return ap;
    }

    @Override
    protected void initPayloadFromStream(InputStream is, StreamUtilCounter sc) throws IOException, EMgramFormatError {
        if (this.m_mgram.isGuarenteed()) {
            this.m_guarTrackingNum = StreamUtil.read6ByteLong(is);
            this.m_preBodyDirty = true;
        }
        if (this.m_mgram.hasTxn()) {
            this.m_txnId = StreamUtil.readInt(is);
            this.m_preBodyDirty = true;
        }
        StreamUtil.readBytes(is, this.m_bodyBuffer, 0, 16);
        this.m_trackingNum = ArrayUtil.read6ByteLong(this.m_bodyBuffer, s_trackingPos);
        this.m_err = ArrayUtil.readShort(this.m_bodyBuffer, s_errPos);
        this.m_longField = ArrayUtil.readLong(this.m_bodyBuffer, s_clientIdPos);
        this.m_mgram.setStatus(3);
    }

    @Override
    public void setGuarenteed(long tracking) {
        if (this.m_isGuarenteedInit && !this.m_preBodyDirty) {
            ArrayUtil.write6ByteLong(this.m_preBodyBuffer, 0, tracking);
        } else {
            this.m_preBodyDirty = true;
        }
        this.m_guarTrackingNum = tracking;
    }

    @Override
    public long getGuarenteedTrackingNum() {
        return this.m_guarTrackingNum;
    }

    @Override
    protected byte[] toByteArray() {
        int offset = 0;
        int preBodyLength = 0;
        if (this.m_preBodyBuffer != null) {
            preBodyLength += this.m_preBodyBuffer.length;
        }
        byte[] result = new byte[16 + preBodyLength];
        this.sync();
        if (preBodyLength > 0) {
            System.arraycopy(this.m_preBodyBuffer, 0, result, 0, preBodyLength);
            offset += preBodyLength;
        }
        System.arraycopy(this.m_bodyBuffer, 0, result, offset, 16);
        return result;
    }

    static byte[] createWindowAckPayload(long receiptTracking, long storageTracking, short err, boolean guaranteed, long ackTracking, boolean txn, int tid) {
        return AckPayload.createPayload(receiptTracking, storageTracking, err, guaranteed, ackTracking, txn, tid);
    }

    static byte[] createPayload(long msgTracking, long clientID, short err, boolean guaranteed, long ackTracking, boolean txn, int tid) {
        int preBodyCount = 0;
        if (guaranteed) {
            preBodyCount += 6;
        }
        if (txn) {
            preBodyCount += 4;
        }
        byte[] result = new byte[16 + preBodyCount];
        if (guaranteed) {
            ArrayUtil.write6ByteLong(result, 0, ackTracking);
        }
        if (txn) {
            ArrayUtil.writeInt(result, preBodyCount - 4, tid);
        }
        AckPayload.setLongField(clientID, result, preBodyCount);
        AckPayload.setErr(err, result, preBodyCount);
        AckPayload.setTrackingNumber(msgTracking, result, preBodyCount);
        return result;
    }

    @Override
    protected void sync() {
        if (this.m_preBodyDirty) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                this.writePreBodyToStream(bos);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.m_preBodyBuffer = bos.toByteArray();
            if (this.m_mgram.isGuarenteed()) {
                this.m_isGuarenteedInit = true;
            }
            if (this.m_mgram.hasTxn()) {
                this.m_hasTxnIdInit = true;
            }
            this.m_preBodyDirty = false;
        }
    }

    private void writePreBodyToStream(OutputStream os) throws IOException {
        if (this.m_preBodyDirty) {
            boolean isGuarenteed = this.m_mgram.isGuarenteed();
            boolean isTxn = this.m_mgram.hasTxn();
            if (isGuarenteed) {
                StreamUtil.write6ByteLong(this.m_guarTrackingNum, os);
            }
            if (isTxn) {
                StreamUtil.writeInt(this.m_txnId, os);
            }
        } else if (this.m_preBodyBuffer != null) {
            os.write(this.m_preBodyBuffer);
        }
    }

    @Override
    public void writeToStream(OutputStream os) throws IOException {
        this.writePreBodyToStream(os);
        os.write(this.m_bodyBuffer);
    }

    @Override
    public void setTxn(int tid) {
        if (this.m_hasTxnIdInit && !this.m_preBodyDirty) {
            if (this.m_isGuarenteedInit) {
                ArrayUtil.write6ByteLong(this.m_preBodyBuffer, 6, tid);
            } else {
                ArrayUtil.write6ByteLong(this.m_preBodyBuffer, 0, tid);
            }
        } else {
            this.m_preBodyDirty = true;
        }
        this.m_txnId = tid;
    }

    @Override
    void removeTxn() {
        this.m_preBodyDirty = true;
        this.m_txnId = 0;
    }

    @Override
    public int getTxnId() {
        return this.m_txnId;
    }

    @Override
    public int length() {
        this.sync();
        int length = 0;
        if (this.m_preBodyBuffer != null) {
            length += this.m_preBodyBuffer.length;
        }
        return length + 16;
    }

    @Override
    protected int memoryLength() {
        this.sync();
        return s_ackMemSize + this.length();
    }

    @Override
    public long getClientID() {
        return this.m_longField;
    }

    @Override
    public void setClientID(long id) {
        this.m_longField = id;
        AckPayload.setLongField(id, this.m_bodyBuffer, 0);
    }

    private static void setLongField(long id, byte[] buffer, int offset) {
        ArrayUtil.writeLong(buffer, offset + s_clientIdPos, id);
    }

    @Override
    public short getErr() {
        return this.m_err;
    }

    @Override
    public void setErr(short err) {
        this.m_err = err;
        AckPayload.setErr(err, this.m_bodyBuffer, 0);
    }

    private static void setErr(short err, byte[] buffer, int offset) {
        ArrayUtil.writeShort(buffer, offset + s_errPos, err);
    }

    @Override
    public long getTrackingNumber() {
        return this.m_trackingNum;
    }

    @Override
    public boolean isEncrypted() {
        return false;
    }

    @Override
    public void setTrackingNumber(long number) {
        this.m_trackingNum = number;
        AckPayload.setTrackingNumber(number, this.m_bodyBuffer, 0);
    }

    static void setTrackingNumber(long number, byte[] buffer, int offset) {
        ArrayUtil.write6ByteLong(buffer, offset + s_trackingPos, number);
    }

    @Override
    public long getReceiptTrackingNumber() {
        return this.getTrackingNumber();
    }

    @Override
    public void setReceiptTrackingNumber(long number) {
        this.setTrackingNumber(number);
    }

    @Override
    public long getStorageTrackingNumber() {
        return this.m_longField;
    }

    @Override
    public void setStorageTrackingNumber(long number) {
        this.m_longField = number;
        AckPayload.setLongField(number, this.m_bodyBuffer, 0);
    }

    public IWindowAckHandle getWindowAckHandle() {
        return this;
    }

    @Override
    public boolean isSubjectAck() {
        return false;
    }

    @Override
    public short getSubjectTracking() {
        return -1;
    }

    @Override
    public void setSubjectTracking(short subjectTracking) {
        throw new EAssertFailure("INVALID_OPERATION");
    }

    @Override
    public IAckHandle getAckHandle() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump() {
        PrintStream log;
        PrintStream printStream = log = SessionConfig.getLog();
        synchronized (printStream) {
            log.print("Guaranteed Tracking Number: ");
            if (this.m_mgram.isGuarenteed()) {
                log.println(this.getTrackingNumber());
            } else {
                log.println("NONE");
            }
            log.println("Acknowledged Message Tracking Number: " + this.getTrackingNumber());
            log.println("Error Code: " + this.getErr());
            log.println("Client ID: " + this.getClientID());
        }
    }

    @Override
    public HashMap getPayloadProperties() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("ACK_BODY_BUFFER", this.m_bodyBuffer);
        result.put("ACK_CLIENT_ID", new Long(this.m_longField));
        result.put("ACK_ERR", new Short(this.m_err));
        result.put("ACK_GUAR_TRACKING_NUMBER", new Long(this.m_guarTrackingNum));
        result.put("ACK_HAS_TXN_ID", new Boolean(this.m_hasTxnIdInit));
        result.put("ACK_IS_GUAR_INIT", new Boolean(this.m_isGuarenteedInit));
        result.put("ACK_PRE_BODY_BUFFER", this.m_preBodyBuffer);
        result.put("ACK_PRE_BODY_DIRTY", new Boolean(this.m_preBodyDirty));
        result.put("ACK_TRACKING_NUMBER", new Long(this.m_trackingNum));
        result.put("ACK_TXN_ID", new Integer(this.m_txnId));
        result.put("ACK_SUBJECT_TRACKING", new Short(-1));
        return result;
    }

    @Override
    public void setPayloadProperties(HashMap map) {
        this.m_bodyBuffer = (byte[])map.get("ACK_BODY_BUFFER");
        this.m_longField = (Long)map.get("ACK_CLIENT_ID");
        this.m_err = (Short)map.get("ACK_ERR");
        this.m_guarTrackingNum = (Long)map.get("ACK_GUAR_TRACKING_NUMBER");
        this.m_hasTxnIdInit = (Boolean)map.get("ACK_HAS_TXN_ID");
        this.m_isGuarenteedInit = (Boolean)map.get("ACK_IS_GUAR_INIT");
        this.m_preBodyBuffer = (byte[])map.get("ACK_PRE_BODY_BUFFER");
        this.m_preBodyDirty = (Boolean)map.get("ACK_PRE_BODY_DIRTY");
        this.m_trackingNum = (Long)map.get("ACK_TRACKING_NUMBER");
        this.m_txnId = (Integer)map.get("ACK_TXN_ID");
    }

    @Override
    public String windowAckSummaryString() {
        return "received=" + this.getReceiptTrackingNumber() + ",stored=" + this.getStorageTrackingNumber() + ",txn=" + this.getTxnId() + ",err=" + this.getErr();
    }
}

