/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v25;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import progress.message.msg.IMgram;
import progress.message.msg.IMgramConverter;
import progress.message.msg.IMgramConverterHandle;
import progress.message.msg.IMgramStatusListener;
import progress.message.msg.MgramConstants;
import progress.message.msg.MgramDeliveryContext;
import progress.message.msg.StreamUtilCounter;
import progress.message.msg.v24.SecureDynamicHeader;
import progress.message.msg.v25.AckPayload;
import progress.message.msg.v25.DefaultDynamicHeader;
import progress.message.msg.v25.DefaultPayload;
import progress.message.msg.v25.DynamicHeader;
import progress.message.msg.v25.Mgram;
import progress.message.msg.v25.Payload;
import progress.message.msg.v25.SidebandData;
import progress.message.msg.v25.StaticHeader;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.util.StreamUtil;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.DebugObject;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.EMgramVersionMismatch;
import progress.message.zclient.IMessageProtection;
import progress.message.zclient.ISecureInputStream;
import progress.message.zclient.ISecureOutputStream;
import progress.message.zclient.SecurityLogic;

public class MgramConverter24
extends DebugObject
implements IMgramConverter {
    private IMgramConverter m_converter;
    private ClientSecurityContext m_csc;
    private ISecureInputStream m_sis;
    private ISecureOutputStream m_sos;
    private boolean m_tteTTLConvert;
    private IMessageProtection m_mp;
    private IMgramStatusListener m_listener;
    private boolean m_canBeEncrypted;
    private byte[] m_encryptedMessageKey;
    private StreamUtilCounter m_counter = null;

    public MgramConverter24() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        super(DebugState.GLOBAL_DEBUG_ON ? "MgramConverter24" : null);
        Class<?> converterClass = Class.forName("progress.message.msg.v24.MgramCreator");
        this.m_converter = (IMgramConverter)converterClass.newInstance();
    }

    @Override
    public IMgram createMgram(InputStream is) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        if (this.m_counter != null) {
            this.m_counter.resetCounter();
        }
        Mgram result = new Mgram(false);
        progress.message.msg.v24.StaticHeader oldSh = new progress.message.msg.v24.StaticHeader(this.m_listener, result);
        oldSh.initStaticHeaderFromStream(is, this.m_tteTTLConvert);
        if (this.m_tteTTLConvert) {
            result.setTTE_TTL(true);
        }
        byte[] oldShArray = oldSh.getRawHeader();
        byte[] newSh = this.createV25sh(oldShArray);
        result.setStaticHeader(newSh);
        if (this.m_tteTTLConvert) {
            result.getTTE();
        }
        if (StaticHeader.getType(newSh) != 4) {
            DynamicHeader newDh = Mgram.initDynamicHeaderFromStream(is, StaticHeader.isSecure(newSh), this.m_mp, result);
            result.setDynamicHeader(newDh);
            Payload newPayload = Mgram.initPayloadFromStream(is, this.m_sis, this.m_mp, this.m_csc, oldShArray, newDh, result, this.m_counter);
            result.setPayload(newPayload);
        } else if (StaticHeader.hasSessionVer(newSh)) {
            result.setSessionVer(StreamUtil.readByte(is));
        }
        return result;
    }

    @Override
    public IMgram createMgram(byte version, InputStream is) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        return null;
    }

    public void writeMgramToNetworkStream(IMgram m, int channel, OutputStream os) throws IOException {
        if (m.getVersion() != 24) {
            progress.message.msg.v24.StaticHeader oldSh = this.createV24sh(m, channel);
            oldSh.writeToStream(os, -1, this.m_tteTTLConvert);
            IMgramConverterHandle.IDynamicHeader newDh = m.getMgramConverterHandle().getInternalDynamicHeader();
            boolean isSecure = m.isSecure();
            if (isSecure) {
                m.getMgramConverterHandle().recalculatePad(this.m_mp);
            }
            progress.message.msg.v24.DynamicHeader oldDh = this.createV24dh(isSecure, this.m_mp, newDh, null, null);
            oldDh.writeToStream(os, this.m_mp);
            m.writePayloadToStream(os, this.m_sos);
        } else {
            m.writeMgramToStream(os, this.m_csc, this.m_sos, this.m_mp, this.m_tteTTLConvert);
        }
    }

    public void messageKeySlicedDelivery(IMgram m, int channel, OutputStream os) throws IOException {
        IMgramConverterHandle mch = m.getMgramConverterHandle();
        progress.message.msg.v24.StaticHeader sh = this.createV24sh(m, channel);
        sh.writeToStream(os, channel, true);
        m.getBrokerHandle().encryptMessageKey(this.m_encryptedMessageKey, this.m_mp);
        mch.recalculatePad(this.m_mp);
        byte[] headerDigest = null;
        if (SecurityLogic.isMKeyMacHeader(m.getSecurity())) {
            headerDigest = m.getBrokerHandle().macByteArray(sh.getRawHeader(), 8, m.getMessageKey(), m.getMessageKey().length, this.m_mp);
        }
        IMgramConverterHandle.IDynamicHeader newDh = mch.getInternalDynamicHeader();
        progress.message.msg.v24.DynamicHeader dh = this.createV24dh(m.isSecure(), this.m_mp, newDh, this.m_encryptedMessageKey, headerDigest);
        dh.writeToStream(os, this.m_mp);
        mch.getInternalPayload().writeToStream(os);
    }

    public void sessionKeySlicedDelivery(IMgram m, int channel, ClientSecurityContext csc, OutputStream os) throws IOException {
        IMgramConverterHandle mch = m.getMgramConverterHandle();
        progress.message.msg.v24.StaticHeader sh = this.createV24sh(m, channel);
        sh.writeToStream(os, channel, true);
        byte[] mac = null;
        if (SecurityLogic.isSKeyDigest(m.getSecurity())) {
            mac = mch.calculateMac(csc.getDigestKey(), this.m_mp);
        }
        IMgramConverterHandle.IDynamicHeader newDh = m.getMgramConverterHandle().getInternalDynamicHeader();
        mch.recalculatePad(this.m_mp);
        progress.message.msg.v24.DynamicHeader dh = this.createV24dh(m.isSecure(), this.m_mp, newDh, null, mac);
        dh.writeToStream(os, this.m_mp);
        m.writePayloadToStream(os, this.m_sos);
    }

    @Override
    public void secureDeliver(IMgram m, int channel, ClientSecurityContext csc, OutputStream os, MgramDeliveryContext ctx) throws IOException {
        this.assertOperationMgram(m);
        if (m.isSecure() && (SecurityLogic.isMKeyMacHeader(m.getSecurity()) || SecurityLogic.isMKeyDigest(m.getSecurity()))) {
            this.messageKeySlicedDelivery(m, channel, os);
        } else if (m.isSecure() && (SecurityLogic.isSKeyDigest(m.getSecurity()) || SecurityLogic.isSKeyEncryption(m.getSecurity()))) {
            this.sessionKeySlicedDelivery(m, channel, csc, os);
        } else {
            this.writeMgramToNetworkStream(m, channel, os);
        }
    }

    public void writeMgramToStreamNonSecure(OutputStream os, IMgram m, boolean tteTTLConvert) throws IOException {
    }

    @Override
    public void deliver(IMgram m, OutputStream os) throws IOException {
        this.deliver(m, -1, os, null);
    }

    @Override
    public void deliver(IMgram m, int channel, OutputStream os, MgramDeliveryContext ctx) throws IOException {
        this.assertOperationMgram(m);
        this.writeMgramToNetworkStream(m, channel, os);
    }

    @Override
    public IMgram unserialize(InputStream os, boolean tteTTLConvert) throws IOException {
        return this.unserialize(os);
    }

    public IMgram unserialize(InputStream in) throws IOException {
        Mgram result = new Mgram(false);
        try {
            DynamicHeader dh = new DefaultDynamicHeader(result);
            result.setDynamicHeader(dh);
            byte[] sh = StaticHeader.getDefaultByteArray();
            result.setStaticHeader(sh);
            result.setSenderID(StreamUtil.readLong(in));
            StreamUtil.readBoolean(in);
            result.setChannel(StreamUtil.readInt(in));
            StreamUtil.readInt(in);
            StreamUtil.readShort(in);
            StreamUtil.readShort(in);
            int messageLen = StreamUtil.readInt(in);
            byte requestProtection = StreamUtil.readByte(in);
            byte type = StreamUtil.readByte(in);
            result.setType(type);
            int daf = StreamUtil.readInt(in);
            int saf = StreamUtil.readInt(in);
            Payload payload = null;
            switch (result.getType()) {
                case 3: 
                case 14: {
                    payload = new AckPayload(result);
                    break;
                }
                case -2: {
                    payload = new DefaultPayload(result);
                    result.setPayload(payload);
                    return result;
                }
                default: {
                    payload = new DefaultPayload(result);
                }
            }
            result.setPayload(payload);
            result.setDestinationAddressFormat(daf);
            int raf = StreamUtil.readInt(in);
            boolean isRequest = StreamUtil.readBoolean(in);
            boolean isReply = StreamUtil.readBoolean(in);
            if (isRequest) {
                result.setRequestReplyType(2);
            }
            if (isReply) {
                payload.setReplyToAddressFormat(raf);
                result.setRequestReplyType(3);
            }
            long trackingNum = StreamUtil.readLong(in);
            StreamUtil.readByte(in);
            byte replyPrio = StreamUtil.readByte(in);
            if (isReply) {
                result.setReplyPriority(replyPrio);
            }
            result.setJMSPersistent(StreamUtil.readBoolean(in));
            int messageLenLoc = StreamUtil.readInt(in);
            StreamUtil.readInt(in);
            StreamUtil.readInt(in);
            StreamUtil.readInt(in);
            StreamUtil.readInt(in);
            StreamUtil.readInt(in);
            StreamUtil.readInt(in);
            int guarLoc = StreamUtil.readInt(in);
            if (guarLoc != 0) {
                result.setGuarenteed(trackingNum);
            }
            StreamUtil.readInt(in);
            StreamUtil.readInt(in);
            int subjectLocation = StreamUtil.readInt(in);
            if (subjectLocation != 0) {
                result.setSubject(StreamUtil.readUTF(in));
            }
            StreamUtil.readInt(in);
            long tte = StreamUtil.readLong(in);
            if (tte > 0L) {
                result.setTTE(tte);
            }
            StreamUtil.readInt(in);
            int pad = StreamUtil.readInt(in);
            StreamUtil.readInt(in);
            StreamUtil.readInt(in);
            result.setSequenceNumber(StreamUtil.readLong(in));
            int sidebandLength = StreamUtil.readInt(in);
            SidebandData sbData = null;
            if (sidebandLength > -1) {
                byte[] sidebandBytes = new byte[sidebandLength];
                StreamUtil.readBytes(in, sidebandBytes, 0, sidebandLength);
                sbData = new SidebandData();
                sbData.fromByteArray(sidebandBytes, 0);
            }
            int dataLength = StreamUtil.readInt(in);
            progress.message.msg.v24.StaticHeader oldSh = new progress.message.msg.v24.StaticHeader(this.m_listener, result);
            oldSh.initStaticHeaderFromStream(in, false);
            byte[] oldShArray = oldSh.getRawHeader();
            byte[] staticHeader = this.createV25sh(oldShArray);
            result.setStaticHeader(staticHeader);
            if (StaticHeader.isSecure(staticHeader)) {
                dh = dh.getSecureDynamicHeader(null);
                result.setDynamicHeader(dh);
            }
            result.setTTE_TTL(false);
            int dynamicHeaderLength = messageLenLoc + 4 - 20;
            dh.initDynamicHeaderFromStream(in);
            if (StaticHeader.isSecure(staticHeader)) {
                dh.setMessagePad(pad);
                byte security = result.getSecurity();
                if (SecurityLogic.isMKeyEncryption(security) && this.m_canBeEncrypted) {
                    DefaultPayload defaultPayload = (DefaultPayload)payload;
                    int preBodyLength = messageLen - (sidebandLength == -1 ? 0 : sidebandLength);
                    byte[] preBody = new byte[preBodyLength];
                    StreamUtil.readBytes(in, preBody, 0, preBodyLength);
                    defaultPayload.setPreBodyBuffer(preBody);
                    if (sidebandLength > -1) {
                        byte[] sidebandData = new byte[sidebandLength];
                        StreamUtil.readBytes(in, sidebandData, 0, sidebandLength);
                        sbData.setSidebandBuffer(sidebandData);
                        result.setSidebandData(sbData);
                    }
                    int bodyLength = messageLen - (sidebandLength == -1 ? 0 : sidebandLength) - preBodyLength;
                    byte[] body = null;
                    if (bodyLength > 0) {
                        body = new byte[bodyLength];
                        StreamUtil.readBytes(in, body, 0, bodyLength);
                    }
                    defaultPayload.setBody(body, bodyLength);
                    byte[] padArray = new byte[pad];
                    StreamUtil.readBytes(in, padArray, 0, pad);
                    defaultPayload.setPadBuffer(padArray);
                    defaultPayload.setEncrypted();
                } else {
                    payload.initPayloadFromStream(in);
                }
            } else {
                payload.initPayloadFromStream(in);
            }
            if (result.isTransactionalPublish()) {
                result.setTxnPublish(StreamUtil.readInt(in), StreamUtil.readInt(in));
            }
            if (this.CALLBACK) {
                this.callback("Mgram unserialized", 0, result);
            }
            return result;
        }
        catch (EMgramVersionMismatch e) {
            throw new EAssertFailure("Invalid Mgram version in log");
        }
        catch (EMgramFormatError e) {
            throw new EAssertFailure("Mgram format is corrupt");
        }
    }

    @Override
    public void serialize(OutputStream os, IMgram m, boolean tteTTLConvert) throws IOException {
        throw new EAssertFailure("Unable to serialize v24 mgrams to the log or database");
    }

    @Override
    public void initializeConverter(Hashtable properties) {
        this.m_csc = (ClientSecurityContext)properties.get(MgramConstants.CLIENT_SECURITY_CONTEXT);
        this.m_sis = (ISecureInputStream)properties.get(MgramConstants.SECURE_INPUT_STREAM);
        this.m_sos = (ISecureOutputStream)properties.get(MgramConstants.SECURE_OUTPUT_STREAM);
        this.m_mp = (IMessageProtection)properties.get(MgramConstants.MESSAGE_PROTECTION);
        if (this.m_mp != null) {
            this.m_encryptedMessageKey = new byte[this.m_mp.getOutputSize(this.m_mp.getSecretKeyLength())];
        }
        this.m_listener = (IMgramStatusListener)properties.get(MgramConstants.MGRAM_STATUS_LISTENER);
        Boolean tteTTL = (Boolean)properties.get(MgramConstants.TTE_TTL_CONVERT);
        this.m_tteTTLConvert = tteTTL != null ? tteTTL : false;
        Boolean canBeEncrypted = (Boolean)properties.get(MgramConstants.CAN_BE_ENCRYPTED);
        this.m_canBeEncrypted = canBeEncrypted != null ? canBeEncrypted : false;
        this.m_counter = new StreamUtilCounter(true);
        this.m_converter.initializeConverter(properties);
    }

    private progress.message.msg.v24.StaticHeader createV24sh(IMgram m, int channel) {
        progress.message.msg.v24.StaticHeader v24 = new progress.message.msg.v24.StaticHeader(null, null);
        if (m.getType() == 4) {
            if (m.hasSessionVer()) {
                v24.setSessionVer(m.getSessionVersion());
            }
            v24.setPostV22(m.isPostSV22());
        } else {
            if (channel != -1) {
                v24.setChannel(channel);
            } else {
                v24.setChannel(m.getChannel());
            }
            if (m.hasID()) {
                v24.enableID();
            }
            v24.enableTTE(m.isTTE());
            v24.setDestinationAddressFormat(m.getSubjectFormat());
            v24.setDiscardable(m.isDiscardable());
            v24.setGuarenteed(m.isGuarenteed());
            v24.setJMSPersistent(m.isJMSPersistent());
            v24.setMgramSecure(m.isSecure());
            v24.setPriority(m.getPriority());
            v24.setRequestReplyType(m.getRequestReplyFieldType());
            v24.setRouteLimit(m.getRouteLimit());
            v24.setSuccessor(m.isSuccessor());
            v24.setTTE(m.getTTE());
            v24.setTxn(m.hasTxn());
            v24.setType(m.getType());
            v24.setTxnPublish(m.getBrokerHandle().isTransactionalPublish());
            v24.sync();
        }
        return v24;
    }

    private progress.message.msg.v24.DynamicHeader createV24dh(boolean isSecure, IMessageProtection mp, IMgramConverterHandle.IDynamicHeader newDh, byte[] encryptedMessageKey, byte[] digest) throws IOException {
        progress.message.msg.v24.DynamicHeader dh = new progress.message.msg.v24.DefaultDynamicHeader(null);
        dh.setMessageLength(newDh.getMessageLength());
        if (isSecure) {
            dh = new SecureDynamicHeader(mp, dh);
            if (digest != null) {
                dh.setMessageDigest(digest);
            } else {
                dh.setMessageDigest(newDh.getDigest());
            }
            if (encryptedMessageKey != null) {
                dh.setMessageKey(encryptedMessageKey);
            } else {
                dh.setMessageKey(newDh.getMessageKey());
            }
            dh.setMessagePad(newDh.getMessagePad());
            dh.setSecurityAttributeByte(newDh.getSecurity());
        }
        return dh;
    }

    private byte[] createV25sh(byte[] oldSh) {
        byte[] result = new byte[oldSh.length];
        System.arraycopy(oldSh, 0, result, 0, oldSh.length);
        StaticHeader.setVersion((byte)25, result);
        return result;
    }

    private void assertOperationMgram(IMgram m) {
        if (m.supportsOperationHandle()) {
            throw new EAssertFailure("Unable to send Operation Mgram to version 24 client");
        }
    }

    @Override
    public byte getVersion() {
        return 24;
    }
}

