/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v25;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UTFDataFormatException;
import java.util.HashMap;
import progress.message.msg.IQueueFlowControlHandle;
import progress.message.msg.StreamUtilCounter;
import progress.message.msg.v25.Mgram;
import progress.message.msg.v25.Payload;
import progress.message.util.EAssertFailure;
import progress.message.util.MemoryUtil;
import progress.message.util.StreamUtil;
import progress.message.util.StringUtil;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.prAccessor;

public final class QueueFlowControlPayload
extends Payload
implements IQueueFlowControlHandle {
    private boolean m_isRouting = false;
    private boolean m_isDirty = true;
    private byte[] m_utfDestination = null;
    private String m_stringDestination = null;
    private boolean m_stringDestDirty = false;
    private int m_utfLength = 0;
    static final int s_qfcMemSize = MemoryUtil.estimateBaseSize(QueueFlowControlPayload.class);

    public QueueFlowControlPayload(Mgram m) {
        super(m);
    }

    @Override
    protected boolean isDirty() {
        return this.m_isDirty;
    }

    @Override
    protected void initPayloadFromStream(InputStream is, StreamUtilCounter sc) throws IOException, EMgramFormatError {
        byte type = this.m_mgram.getType();
        switch (type) {
            case 18: 
            case 19: {
                this.m_isRouting = StreamUtil.readByte(is) > 0;
                this.m_utfDestination = StreamUtil.readUTFString(is);
                this.m_utfLength = this.m_utfDestination.length;
                this.m_stringDestDirty = true;
                break;
            }
            default: {
                throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
            }
        }
    }

    @Override
    protected byte[] toByteArray() {
        this.sync();
        return QueueFlowControlPayload.createPayload(this.m_isRouting, this.m_utfDestination, this.m_utfLength);
    }

    @Override
    protected void sync() {
    }

    @Override
    public void writeToStream(OutputStream os) throws IOException {
        this.sync();
        os.write(this.m_isRouting ? 1 : 0);
        os.write(this.m_utfDestination, 0, this.m_utfLength);
    }

    @Override
    public int length() {
        return this.m_utfLength + 1;
    }

    @Override
    protected int memoryLength() {
        this.sync();
        return s_qfcMemSize + (this.m_stringDestination == null ? 0 : this.m_stringDestination.length()) + (this.m_utfDestination == null ? 0 : this.m_utfDestination.length);
    }

    public static byte[] createPayload(boolean isRouting, byte[] utfDestination, int utfLength) {
        byte[] result = new byte[utfLength + 1];
        result[0] = (byte)(isRouting ? 1 : 0);
        System.arraycopy(utfDestination, 0, result, 1, utfLength);
        return result;
    }

    @Override
    public IQueueFlowControlHandle getQueueFlowControlHandle() {
        return this;
    }

    @Override
    public String getFlowDestination() {
        if (this.m_stringDestDirty) {
            try {
                this.m_stringDestination = StringUtil.UTFToString(this.m_utfDestination, 0);
            }
            catch (UTFDataFormatException uTFDataFormatException) {
                // empty catch block
            }
            this.m_stringDestDirty = false;
        }
        return this.m_stringDestination;
    }

    @Override
    public void setFlowDestination(byte[] utf, int utfLength) {
        this.m_stringDestDirty = true;
        this.m_isDirty = true;
        this.m_utfDestination = utf;
        this.m_utfLength = utfLength;
    }

    @Override
    public boolean getFlowRoutingBit() {
        return this.m_isRouting;
    }

    @Override
    public void setFlowRoutingBit(boolean value) {
        this.m_isRouting = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump() {
        PrintStream log;
        PrintStream printStream = log = SessionConfig.getLog();
        synchronized (printStream) {
            log.print("Flow Destination: " + this.getFlowDestination());
            log.print("Flow Routing: " + this.getFlowRoutingBit());
        }
    }

    @Override
    public HashMap getPayloadProperties() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("QFC_IS_DIRTY", new Boolean(this.m_isDirty));
        result.put("QFC_IS_ROUTING", new Boolean(this.m_isRouting));
        result.put("QFC_STRING_DESTINATION", this.m_stringDestination);
        result.put("QFC_STRING_DESTINATION_DIRTY", new Boolean(this.m_stringDestDirty));
        result.put("QFC_UTF_DESTINATION", this.m_utfDestination);
        result.put("QFC_UTF_LENGTH", new Integer(this.m_utfLength));
        return result;
    }

    @Override
    public void setPayloadProperties(HashMap map) {
        this.m_isDirty = (Boolean)map.get("QFC_IS_DIRTY");
        this.m_isRouting = (Boolean)map.get("QFC_IS_ROUTING");
        this.m_stringDestination = (String)map.get("QFC_STRING_DESTINATION");
        this.m_stringDestDirty = (Boolean)map.get("QFC_STRING_DESTINATION_DIRTY");
        this.m_utfDestination = (byte[])map.get("QFC_UTF_DESTINATION");
        this.m_utfLength = (Integer)map.get("QFC_UTF_LENGTH");
    }
}

