/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v26.broker;

import progress.message.msg.IMgram;
import progress.message.msg.v26.DefaultDynamicHeader;
import progress.message.msg.v26.DynamicHeader;
import progress.message.msg.v26.IBrokerMgramCreator;
import progress.message.msg.v26.Mgram;
import progress.message.msg.v26.NackPayload;
import progress.message.msg.v26.PTPFlowControlPayload;
import progress.message.msg.v26.Payload;
import progress.message.msg.v26.QueueFlowControlPayload;
import progress.message.msg.v26.StaticHeader;
import progress.message.msg.v26.broker.ReplicatedMgramPayload;
import progress.message.msg.v26.broker.SaverOpPayload;
import progress.message.msg.v26.broker.StateEventPayload;
import progress.message.util.ArrayUtil;
import progress.message.zclient.ISaverOp;
import progress.message.zclient.IStateEvent;
import progress.message.zclient.ISubject;

public class MgramCreator
implements IBrokerMgramCreator {
    private static byte[] m_nackStaticHeader;
    private static byte[] m_nackDynamicHeader;
    private static byte[] m_nackPayload;
    private static byte[] m_resumeStaticHeader;
    private static byte[] m_resumeDynamicHeader;
    private static byte[] m_blockStaticHeader;
    private static byte[] m_blockDynamicHeader;
    private static byte[] m_flowControlStaticHeader;
    private static byte[] m_flowControlDynamicHeader;
    private static int GR_CONVERT_LENGTH;
    private static int IB_CONVERT_LENGTH;

    @Override
    public IMgram buildGRConvertMgram(long code, long clientid, int channel, long token) {
        Mgram result = new Mgram(true);
        result.setType((byte)16);
        result.setRequestReplySend();
        result.setChannel(channel);
        byte[] body = new byte[GR_CONVERT_LENGTH];
        ArrayUtil.writeLong(body, 0, code);
        ArrayUtil.writeLong(body, 8, clientid);
        ArrayUtil.writeLong(body, 16, token);
        result.setBody(body);
        return result;
    }

    @Override
    public IMgram buildTxnEOFMarker() {
        Mgram m = new Mgram(true);
        m.setType((byte)-2);
        m.setBody(new byte[0]);
        return m;
    }

    @Override
    public IMgram buildTxnSavePointMarker() {
        Mgram m = new Mgram(true);
        m.setType((byte)-3);
        m.setBody(new byte[0]);
        return m;
    }

    @Override
    public IMgram buildResumeMgram(int channel, byte[] utfDestination, int utfLength, boolean routing) {
        Mgram resume = new Mgram(false);
        byte[] staticHeader = new byte[m_resumeStaticHeader.length];
        System.arraycopy(m_resumeStaticHeader, 0, staticHeader, 0, m_resumeStaticHeader.length);
        byte[] dynamicHeader = new byte[m_resumeDynamicHeader.length];
        System.arraycopy(m_resumeDynamicHeader, 0, dynamicHeader, 0, m_resumeDynamicHeader.length);
        StaticHeader.setChannel(channel, staticHeader);
        resume.setStaticHeader(staticHeader);
        resume.setDynamicHeaderCache(dynamicHeader);
        byte[] payload = MgramCreator.setupQueueFlowControlPayload(resume, channel, routing, utfDestination, utfLength);
        DefaultDynamicHeader.setMessageLength(payload.length, dynamicHeader);
        return resume;
    }

    private static byte[] setupQueueFlowControlPayload(Mgram m, int channel, boolean routing, byte[] utfDestination, int utfLength) {
        m.setChannel(channel);
        byte[] payload = QueueFlowControlPayload.createPayload(routing, utfDestination, utfLength);
        m.setPayloadCache(payload);
        return payload;
    }

    @Override
    public IMgram buildPTPFlowControlMgram(int channel, String routing, ISubject subject, boolean isPubSub, byte subType) {
        Mgram ptpFlowControl = new Mgram(false);
        byte[] staticHeader = new byte[m_flowControlStaticHeader.length];
        System.arraycopy(m_flowControlStaticHeader, 0, staticHeader, 0, m_flowControlStaticHeader.length);
        byte[] dynamicHeader = new byte[m_flowControlDynamicHeader.length];
        System.arraycopy(m_flowControlDynamicHeader, 0, dynamicHeader, 0, m_flowControlDynamicHeader.length);
        StaticHeader.setChannel(channel, staticHeader);
        ptpFlowControl.setStaticHeader(staticHeader);
        ptpFlowControl.setDynamicHeaderCache(dynamicHeader);
        byte[] payload = PTPFlowControlPayload.createPayload(subject, routing, isPubSub, subType);
        ptpFlowControl.setPayloadCache(payload);
        DefaultDynamicHeader.setMessageLength(payload.length, dynamicHeader);
        return ptpFlowControl;
    }

    @Override
    public IMgram buildBlockMgram(int channel, byte[] utfDestination, int utfLength, boolean routing) {
        Mgram block = new Mgram(false);
        byte[] staticHeader = new byte[m_blockStaticHeader.length];
        System.arraycopy(m_blockStaticHeader, 0, staticHeader, 0, m_blockStaticHeader.length);
        byte[] dynamicHeader = new byte[m_blockDynamicHeader.length];
        System.arraycopy(m_blockDynamicHeader, 0, dynamicHeader, 0, m_blockDynamicHeader.length);
        StaticHeader.setChannel(channel, staticHeader);
        block.setStaticHeader(staticHeader);
        block.setDynamicHeaderCache(dynamicHeader);
        byte[] payload = MgramCreator.setupQueueFlowControlPayload(block, channel, routing, utfDestination, utfLength);
        DefaultDynamicHeader.setMessageLength(payload.length, dynamicHeader);
        return block;
    }

    @Override
    public IMgram buildNack(long tracking, int channel) {
        Mgram nack = null;
        nack = new Mgram(false);
        byte[] staticHeader = new byte[m_nackStaticHeader.length];
        System.arraycopy(m_nackStaticHeader, 0, staticHeader, 0, m_nackStaticHeader.length);
        byte[] dynamicHeader = new byte[m_nackDynamicHeader.length];
        System.arraycopy(m_nackDynamicHeader, 0, dynamicHeader, 0, m_nackDynamicHeader.length);
        byte[] payload = new byte[m_nackPayload.length];
        System.arraycopy(m_nackPayload, 0, payload, 0, m_nackPayload.length);
        StaticHeader.setChannel(channel, staticHeader);
        nack.setStaticHeader(staticHeader);
        nack.setDynamicHeaderCache(dynamicHeader);
        NackPayload.setTrackingNumber(tracking, payload);
        nack.setPayloadCache(payload);
        return nack;
    }

    @Override
    public IMgram buildRouteRequest(int channel, int requestType, long requestTime, int infoCount, byte[] routeInfo) {
        Mgram result = new Mgram(true);
        result.setType((byte)17);
        result.setPriority((byte)12);
        result.setRequestReplySend();
        result.setChannel(channel);
        byte[] body = new byte[16 + routeInfo.length];
        int p = 0;
        ArrayUtil.writeInt(body, 0, requestType);
        ArrayUtil.writeLong(body, p += 4, requestTime);
        ArrayUtil.writeInt(body, p += 8, infoCount);
        System.arraycopy(routeInfo, 0, body, p += 4, routeInfo.length);
        result.setBody(body);
        return result;
    }

    @Override
    public IMgram buildStateEventMgram(IStateEvent event, boolean tteTTLConvert) {
        Mgram result = new Mgram(true);
        result.setType((byte)24);
        result.setPriority((byte)0);
        StateEventPayload payload = new StateEventPayload(result, event, tteTTLConvert);
        result.setPayload(payload);
        return result;
    }

    @Override
    public IMgram buildDatabaseMgram(ISaverOp op) {
        Mgram result = new Mgram(true);
        result.setType((byte)29);
        result.setPriority((byte)0);
        SaverOpPayload payload = new SaverOpPayload(result);
        payload.setSaverOp(op);
        result.setPayload(payload);
        return result;
    }

    @Override
    public IMgram buildReplicatedMgram(IMgram replicatedMgram, boolean tteTTLConvert) {
        Mgram result = new Mgram(true);
        result.setType((byte)35);
        result.setPriority((byte)0);
        ReplicatedMgramPayload payload = new ReplicatedMgramPayload(result, replicatedMgram, tteTTLConvert);
        result.setPayload(payload);
        return result;
    }

    @Override
    public IMgram buildIBConvertMgram(long token, int channel) {
        Mgram result = new Mgram(true);
        result.setType((byte)5);
        result.setRequestReplySend();
        result.setChannel(channel);
        byte[] body = new byte[IB_CONVERT_LENGTH];
        ArrayUtil.writeLong(body, 0, token);
        result.setBody(body);
        return result;
    }

    @Override
    public IMgram buildDisconnectReply(int channel, boolean reject) {
        Mgram result = new Mgram(true);
        result.setType((byte)7);
        result.setPriority((byte)11);
        result.setRequestReplyType(3);
        result.setChannel(channel);
        byte[] body = new byte[]{(byte)(reject ? 1 : 0)};
        result.setBody(body);
        return result;
    }

    @Override
    public Payload getPayloadObject(int type, Mgram m) {
        switch (type) {
            case 24: {
                return new StateEventPayload(m);
            }
            case 29: {
                return new SaverOpPayload(m);
            }
            case 35: {
                return new ReplicatedMgramPayload(m);
            }
        }
        return null;
    }

    static {
        GR_CONVERT_LENGTH = 24;
        IB_CONVERT_LENGTH = 8;
        m_resumeStaticHeader = StaticHeader.getDefaultByteArray();
        m_resumeDynamicHeader = new DefaultDynamicHeader(null).toByteArray();
        StaticHeader.setType((byte)19, m_resumeStaticHeader);
        StaticHeader.setPriority((byte)12, m_resumeStaticHeader);
        StaticHeader.setRequestReplyType(2, m_resumeStaticHeader);
        m_blockStaticHeader = StaticHeader.getDefaultByteArray();
        m_blockDynamicHeader = new DefaultDynamicHeader(null).toByteArray();
        StaticHeader.setType((byte)18, m_blockStaticHeader);
        StaticHeader.setPriority((byte)12, m_blockStaticHeader);
        StaticHeader.setRequestReplyType(0, m_blockStaticHeader);
        m_flowControlStaticHeader = StaticHeader.getDefaultByteArray();
        m_flowControlDynamicHeader = new DefaultDynamicHeader(null).toByteArray();
        StaticHeader.setType((byte)37, m_flowControlStaticHeader);
        StaticHeader.setPriority((byte)12, m_flowControlStaticHeader);
        m_nackStaticHeader = StaticHeader.getDefaultByteArray();
        DefaultDynamicHeader dh = new DefaultDynamicHeader(null);
        ((DynamicHeader)dh).setMessageLength(6);
        m_nackDynamicHeader = ((DynamicHeader)dh).toByteArray();
        m_nackPayload = new NackPayload(null).toByteArray();
        StaticHeader.setType((byte)20, m_nackStaticHeader);
        StaticHeader.setPriority((byte)12, m_nackStaticHeader);
    }
}

