/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.http.server.tunnel;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.server.Request;
import progress.message.net.ProgressInetAddress;
import progress.message.net.http.server.IHttpRequestHandler;
import progress.message.net.http.server.SonicHttpServer;
import progress.message.net.http.server.tunnel.HttpConnectionSocket;

public class HttpTunnelHandler
implements IHttpRequestHandler {
    static int CONNECTION_CLEANUP_INTERVAL = 60000;
    static int CLIENT_WRITE_MAX_CONTENTLENGTH = 0x100000;
    static boolean DEBUG = false;
    private static HttpTunnelHandler s_httpTunnelHandler = null;
    private static Object _sync = new Object();
    private static Hashtable m_connections = new Hashtable();
    private static int m_nextConnectionId = 0;

    private HttpTunnelHandler(Properties props) {
        String cleanupInterval;
        if (props != null && (cleanupInterval = props.getProperty("HTTP_CONNECTION_CLEANUP_INTERVAL")) != null) {
            CONNECTION_CLEANUP_INTERVAL = Integer.parseInt(cleanupInterval);
        }
        DEBUG = SonicHttpServer.getDebug();
        this.startConnectionCleaner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpTunnelHandler getTunnelHandler(Properties props) {
        Object object = _sync;
        synchronized (object) {
            if (s_httpTunnelHandler == null) {
                s_httpTunnelHandler = new HttpTunnelHandler(props);
            }
            return s_httpTunnelHandler;
        }
    }

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response, SonicHttpServer server, Socket socket) throws IOException {
        if (!HttpMethod.POST.asString().equals(request.getMethod())) {
            return;
        }
        String path = request.getRequestURI();
        if (DEBUG) {
            response.setHeader("AgentId", Thread.currentThread().getName());
            int id = request.getIntHeader("SequenceNumber");
            System.out.println(Thread.currentThread() + " handling " + path + ", sequence number = " + id);
        }
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        if (path.equals("/SC/Exist")) {
            this.handleExistingConnection(request, response);
        } else if (path.equals("/SC/ReqData")) {
            this.retrieveData(request, response);
        } else if (path.equals("/SC/New")) {
            this.handleNewConnection(request, response, server, socket);
        } else if (path.equals("/SC/Close")) {
            this.closeConnection(request, response);
        } else {
            this.closeConnection(request, response);
        }
        response.getOutputStream().flush();
        if (request instanceof Request) {
            ((Request)request).setHandled(true);
        }
    }

    private void handleExistingConnection(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            int id = request.getIntHeader("ConnectionId");
            if (id == -1) {
                if (DEBUG) {
                    System.out.println("HTTP Connection " + id + ": Invalid ConnectionId received by broker. Setting response: " + HttpConnectionSocket.NO_DATA_STATUS);
                }
                HttpConnectionSocket.sendReplyCode(response, HttpConnectionSocket.NO_DATA_STATUS);
                return;
            }
            HttpConnectionSocket sSocket = (HttpConnectionSocket)m_connections.get(new Integer(id));
            if (sSocket == null || sSocket.m_closedByClient) {
                if (DEBUG) {
                    System.out.println("HTTP Connection " + id + ": non-existent or inactive socket. Setting response: " + HttpConnectionSocket.FAIL_STATUS);
                }
                HttpConnectionSocket.sendReplyCode(response, HttpConnectionSocket.FAIL_STATUS);
                return;
            }
            int sequenceNo = request.getIntHeader("SequenceNumber");
            if (sequenceNo == -1) {
                if (DEBUG) {
                    System.out.println("HTTP Connection " + id + ": invalid sequence number, timestamp = " + System.currentTimeMillis() + " Setting response: " + HttpConnectionSocket.FAIL_STATUS);
                }
                HttpConnectionSocket.sendReplyCode(response, HttpConnectionSocket.FAIL_STATUS);
                return;
            }
            int bWritten = -1;
            int contentLength = request.getIntHeader("Content-length");
            if (DEBUG) {
                System.out.println("HTTP Connection " + id + ": content length " + contentLength);
            }
            if (contentLength == -1) {
                if (DEBUG) {
                    System.out.println("HTTP Connection " + id + ": content length unknown.");
                }
                bWritten = sSocket.clientWrite((InputStream)request.getInputStream(), sequenceNo);
            } else {
                if (contentLength < 0 || contentLength > CLIENT_WRITE_MAX_CONTENTLENGTH) {
                    String msg = "HTTP Connection " + id + ": Content-Length header had an invalid size of " + contentLength + " Setting response: " + HttpConnectionSocket.FAIL_STATUS;
                    BrokerComponent.getComponentContext().logMessage(msg, 1);
                    HttpConnectionSocket.sendReplyCode(response, HttpConnectionSocket.FAIL_STATUS);
                    sSocket.close();
                    return;
                }
                byte[] buf = new byte[contentLength];
                int len = 0;
                int off = 0;
                while ((len = request.getInputStream().read(buf, off, contentLength - off)) >= 0) {
                    off += len;
                }
                if (DEBUG) {
                    System.out.println("HTTP Connection " + id + ": size of data read " + buf);
                }
                bWritten = sSocket.clientWrite(new ByteArrayInputStream(buf), sequenceNo);
            }
            if (bWritten >= 0) {
                if (DEBUG) {
                    System.out.println("HTTP Connection " + id + ": client written " + bWritten + " bytes to the broker. Setting response: " + HttpConnectionSocket.SUCCESS_STATUS);
                }
                HttpConnectionSocket.sendReplyCode(response, HttpConnectionSocket.SUCCESS_STATUS);
            } else {
                if (DEBUG) {
                    System.out.println("HTTP Connection " + id + ": error reading client data. Setting response: " + HttpConnectionSocket.FAIL_STATUS);
                }
                HttpConnectionSocket.sendReplyCode(response, HttpConnectionSocket.FAIL_STATUS);
            }
        }
        catch (Exception e) {
            if (DEBUG) {
                System.out.println("HTTP Connection error " + e.getMessage() + " Setting response: " + HttpConnectionSocket.FAIL_STATUS);
                e.printStackTrace();
            }
            HttpConnectionSocket.sendReplyCode(response, HttpConnectionSocket.FAIL_STATUS);
        }
    }

    private void handleNewConnection(HttpServletRequest request, HttpServletResponse response, SonicHttpServer server, Socket socket) throws IOException {
        int id = -1;
        id = request.getIntHeader("SONIC_CLIENT_PING");
        if (id != -1) {
            if (DEBUG) {
                System.out.println("HTTP Connection " + id + " pinging at " + new Date(System.currentTimeMillis()));
            }
            HttpConnectionSocket sSocket = null;
            sSocket = (HttpConnectionSocket)m_connections.get(new Integer(id));
            if (sSocket == null || sSocket.m_closedByBroker) {
                if (DEBUG) {
                    System.out.println("HTTP Connection " + id + ": non-existent or socket closed by broker, response = " + HttpConnectionSocket.CLOSING_STATUS);
                }
                HttpConnectionSocket.sendReplyCode(response, HttpConnectionSocket.CLOSING_STATUS);
            } else {
                sSocket.setLastReqTime(System.currentTimeMillis());
                HttpConnectionSocket.sendReplyCode(response, HttpConnectionSocket.SUCCESS_STATUS);
            }
            return;
        }
        id = this.getNextConnectionId();
        response.setIntHeader("ConnectionId", id);
        response.setIntHeader("SonicPingInterval", HttpConnectionSocket.getClientIdleTimeout());
        HttpConnectionSocket sSocket = null;
        ProgressInetAddress pinet = null;
        pinet = new ProgressInetAddress(socket.getInetAddress());
        sSocket = new HttpConnectionSocket(pinet, id);
        sSocket.setLastReqTime(System.currentTimeMillis());
        m_connections.put(new Integer(id), sSocket);
        if (DEBUG) {
            System.out.println("HTTP Connection " + id + ": created. Setting response: " + HttpConnectionSocket.SUCCESS_STATUS);
        }
        server.addHttpConnection(sSocket);
        HttpConnectionSocket.sendReplyCode(response, HttpConnectionSocket.SUCCESS_STATUS);
    }

    private void closeConnection(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            int id = request.getIntHeader("ConnectionId");
            HttpConnectionSocket sSocket = (HttpConnectionSocket)m_connections.remove(new Integer(id));
            if (sSocket == null) {
                if (DEBUG) {
                    System.out.println("HTTP Connection " + id + ": non-existent socket. Setting response: " + HttpConnectionSocket.FAIL_STATUS);
                }
                HttpConnectionSocket.sendReplyCode(response, HttpConnectionSocket.FAIL_STATUS);
            } else {
                sSocket.clientClose();
                if (DEBUG) {
                    System.out.println("HTTP Connection " + id + ": closed by the client, timestamp = " + System.currentTimeMillis() + " Setting response: " + HttpConnectionSocket.SUCCESS_STATUS);
                }
                HttpConnectionSocket.sendReplyCode(response, HttpConnectionSocket.SUCCESS_STATUS);
            }
        }
        catch (Exception e) {
            if (DEBUG) {
                System.out.println("HTTP Connection error: " + e.getMessage() + " Setting response: " + HttpConnectionSocket.FAIL_STATUS);
            }
            HttpConnectionSocket.sendReplyCode(response, HttpConnectionSocket.FAIL_STATUS);
        }
    }

    private void retrieveData(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            int id = request.getIntHeader("ConnectionId");
            if (id == -1) {
                if (DEBUG) {
                    System.out.println("HTTP Connection error. Invalid ConnectionId received by broker. Setting response: " + HttpConnectionSocket.NO_DATA_STATUS);
                }
                HttpConnectionSocket.sendReplyCode(response, HttpConnectionSocket.NO_DATA_STATUS);
                return;
            }
            HttpConnectionSocket sSocket = null;
            sSocket = (HttpConnectionSocket)m_connections.get(new Integer(id));
            if (sSocket == null || sSocket.m_closedByClient) {
                if (DEBUG) {
                    System.out.println("HTTP Connection " + id + ": non-existent or inactive socket. Setting response: " + HttpConnectionSocket.CLOSING_STATUS);
                }
                HttpConnectionSocket.sendReplyCode(response, HttpConnectionSocket.CLOSING_STATUS);
            } else {
                int bRead = sSocket.clientRead(response);
                if (DEBUG) {
                    System.out.println("HTTP Connection " + id + ": client read " + bRead + " bytes from the broker, agent = " + Thread.currentThread());
                }
            }
        }
        catch (Exception e) {
            if (DEBUG) {
                System.out.println("HTTP Connection error " + e.getMessage() + " Setting response: " + HttpConnectionSocket.FAIL_STATUS);
            }
            HttpConnectionSocket.sendReplyCode(response, HttpConnectionSocket.FAIL_STATUS);
        }
    }

    private synchronized int getNextConnectionId() throws IOException {
        m_nextConnectionId = m_nextConnectionId == Integer.MAX_VALUE ? 0 : ++m_nextConnectionId;
        int save = m_nextConnectionId;
        while (m_connections.get(new Integer(m_nextConnectionId)) != null) {
            m_nextConnectionId = m_nextConnectionId == Integer.MAX_VALUE ? 0 : ++m_nextConnectionId;
            if (m_nextConnectionId != save) continue;
            throw new IOException("Max connections exceeded.");
        }
        return m_nextConnectionId;
    }

    private void startConnectionCleaner() {
        Thread connectionCleaner = null;
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                block4: while (true) {
                    try {
                        Thread.sleep(CONNECTION_CLEANUP_INTERVAL);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (DEBUG) {
                        System.out.println(Thread.currentThread() + ": starts connection cleaning at " + new Date());
                    }
                    Enumeration conns = m_connections.keys();
                    while (true) {
                        if (!conns.hasMoreElements()) continue block4;
                        Integer id = (Integer)conns.nextElement();
                        HttpConnectionSocket socket = (HttpConnectionSocket)m_connections.get(id);
                        if (socket.isActive()) continue;
                        if (DEBUG) {
                            System.out.println("HTTP Connection " + id + ": closing orphaned socket");
                        }
                        m_connections.remove(id);
                        try {
                            socket.cleanup();
                        }
                        catch (IOException iOException) {
                        }
                    }
                    break;
                }
            }
        };
        connectionCleaner = new Thread(runner);
        connectionCleaner.setName("HTTP connection cleaner");
        connectionCleaner.setDaemon(true);
        connectionCleaner.start();
    }
}

