/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.https.server;

import com.sonicsw.security.ssl.JSSEConfigManager;
import com.sonicsw.security.ssl.SSLUtil;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import javax.net.ssl.SSLContext;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import progress.message.net.ESocketConfigException;
import progress.message.net.ProgressInetAddress;
import progress.message.net.http.server.HttpConnectionHandler;
import progress.message.net.http.server.SonicHttpServer;
import progress.message.net.https.ProgressHttpsSocketFactory;
import progress.message.net.https.server.SonicHttpsServerConnector;
import progress.message.net.https.server.SonicJettyHttpsConnectionFactory;
import progress.message.net.https.server.SonicJettyHttpsServer;
import progress.message.net.https.server.tunnel.HttpsConnectionSocket;
import progress.message.net.https.server.tunnel.HttpsTunnelHandlerFactory;
import progress.message.net.prAccessor;
import progress.message.net.ssl.ISSLControl;
import progress.message.net.ssl.ISSLImpl;
import progress.message.net.ssl.jsafe.jsafeSSLServerControl;
import progress.message.net.ssl.jsse.jsseSSLControl;

public class SonicHttpsServer
extends SonicHttpServer {
    private static final long serialVersionUID = 3256438088602695733L;
    private int m_acceptTimeout = -1;
    private boolean m_stopped = false;
    private static int _connectionCount = 0;
    private static Object _mutex = new Object();
    private transient SonicJettyHttpsConnectionFactory sonicJettyHttpsConnectionFactory;
    private transient SonicHttpsServerConnector sonicHttpsServerConnector;

    public SonicHttpsServer(ProgressInetAddress bindAddr, int port, int backlog) throws IOException {
        this(bindAddr, port, backlog, null);
    }

    public SonicHttpsServer(ProgressInetAddress bindAddr, int port, int backlog, Properties properties) throws IOException {
        super(bindAddr, port, properties, false);
        HttpsTunnelHandlerFactory https = new HttpsTunnelHandlerFactory(null, null);
        this.m_httpConnectionHandler.insertProtocolFactory(https, 0);
        this.sonicJettyHttpsConnectionFactory = new SonicJettyHttpsConnectionFactory(this);
        SslConnectionFactory ssl = new SslConnectionFactory((SslContextFactory)this.getServerSSLContextFactory(), this.sonicJettyHttpsConnectionFactory.getProtocol());
        this.m_server = new SonicJettyHttpsServer(this, (ThreadPool)this.m_thread_pool);
        this.sonicHttpsServerConnector = new SonicHttpsServerConnector(this.m_server, this.sonicJettyHttpsConnectionFactory, ssl, TCP_NODELAY);
        this.sonicHttpsServerConnector.setPort(port);
        this.m_server.addConnector((Connector)this.sonicHttpsServerConnector);
    }

    private SslContextFactory.Server getServerSSLContextFactory() throws ESocketConfigException {
        ISSLImpl sslFactory = ProgressHttpsSocketFactory.getSSLFactory();
        ISSLControl control = sslFactory.createSSLServerControl();
        if (control instanceof jsafeSSLServerControl) {
            throw new ESocketConfigException("JSafe implementation is no longer supported for HTTPS Direct");
        }
        String pwd = SSLUtil.getProperty(this.m_props, "SSL_PRIVATE_KEY_PASSWORD", null);
        if (!control.configureKeyAndCertificate(SSLUtil.getProperty(this.m_props, "SSL_CERTIFICATE_CHAIN", null), SSLUtil.getProperty(this.m_props, "SSL_CERTIFICATE_CHAIN_FORM", "LIST"), SSLUtil.getProperty(this.m_props, "SSL_PRIVATE_KEY", null), SSLUtil.getProperty(this.m_props, "SSL_PRIVATE_KEY_FORM", "PKCS8"), pwd)) {
            throw new ESocketConfigException(prAccessor.getString("CertLoadFailure"));
        }
        String cipherSuites = SSLUtil.getProperty(this.m_props, "SSL_CIPHER_SUITES", null);
        Vector cs = SSLUtil.getCipherSuites(cipherSuites, DEBUG);
        if (!control.configureCipherSuites(cs)) {
            throw new ESocketConfigException(prAccessor.getString("CipherSuiteConfig") + cipherSuites);
        }
        if (SSLUtil.getProperty(this.m_props, "SSL_CLIENT_AUTHENTICATION", "false").equalsIgnoreCase("true")) {
            String caCertsDir = SSLUtil.getProperty(this.m_props, "SSL_CA_CERTIFICATES_DIR", null);
            try {
                if (caCertsDir != null && !control.configureTrustDecider(caCertsDir, null)) {
                    throw new ESocketConfigException(prAccessor.getString("CACertLoadFailure"));
                }
            }
            catch (Exception ex) {
                throw new ESocketConfigException(ex.getMessage());
            }
        }
        try {
            String protocols;
            jsseSSLControl jsseControl = (jsseSSLControl)control;
            JSSEConfigManager configManager = new JSSEConfigManager(this.m_props, true, DEBUG, jsseControl);
            SSLContext sslCtx = jsseControl.getSSLContext(configManager);
            SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
            sslContextFactory.setSslContext(sslCtx);
            String[] csStr = jsseControl.getEnabledCipherSuites();
            sslContextFactory.setNeedClientAuth(SSLUtil.getBooleanProperty(this.m_props, "SSL_CLIENT_AUTHENTICATION", false).booleanValue());
            if (csStr != null) {
                sslContextFactory.setIncludeCipherSuites(csStr);
            }
            if ((protocols = SSLUtil.getProperty(this.m_props, "SSL_TLS_PREFERRED_PROTOCOLS", null)) != null) {
                sslContextFactory.setIncludeProtocols(new String[]{protocols});
            }
            return sslContextFactory;
        }
        catch (Exception ex) {
            throw new ESocketConfigException(ex.getMessage());
        }
    }

    public SonicHttpsServerConnector sonicHttpsServerConnector() {
        return this.sonicHttpsServerConnector;
    }

    public QueuedThreadPool getThreadPool() {
        return this.m_thread_pool;
    }

    public void start() throws Exception {
        this.m_server.start();
    }

    @Override
    public void stop() throws Exception {
        if (this.m_stopped) {
            return;
        }
        this.m_stopped = true;
        super.stop();
    }

    HttpConnectionHandler getHandler() {
        return this.m_httpConnectionHandler;
    }

    public void addHttpsConnection(HttpsConnectionSocket socket) {
        this.m_connectionQueue.add(socket);
    }

    public HttpsConnectionSocket acceptHttpsConnection() throws IOException {
        if (this.m_stopped) {
            throw new ESocketConfigException("SonicHttpsServer no longer accepting connection.");
        }
        try {
            HttpsConnectionSocket socket = (HttpsConnectionSocket)this.m_connectionQueue.remove();
            return socket;
        }
        catch (InterruptedException ie) {
            return null;
        }
    }
}

