/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.https.server;

import java.io.IOException;
import java.net.Socket;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.SocketChannelEndPoint;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import progress.message.net.https.server.SonicHttpsServer;

public class SonicJettyHttpsConnectionHandler
extends AbstractHandler {
    private final SonicHttpsServer sonicHttpsServer;
    private final boolean tcpNoDelay;

    SonicJettyHttpsConnectionHandler(SonicHttpsServer aSonicHttpsServer, boolean tcpNoDelay) {
        this.sonicHttpsServer = aSonicHttpsServer;
        this.tcpNoDelay = tcpNoDelay;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        EndPoint endPoint = HttpConnection.getCurrentConnection().getEndPoint();
        if (endPoint instanceof SslConnection.DecryptedEndPoint) {
            endPoint = ((SslConnection.DecryptedEndPoint)endPoint).getSslConnection().getEndPoint();
        }
        if (endPoint instanceof SocketChannelEndPoint) {
            Socket socket = ((SocketChannelEndPoint)endPoint).getSocket();
            socket.setTcpNoDelay(this.tcpNoDelay);
            socket.setSoTimeout(this.sonicHttpsServer.getThreadPool().getIdleTimeout());
            this.sonicHttpsServer.getHandler().handle(this.sonicHttpsServer, request, response, socket);
        }
    }
}

