/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.ssl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import progress.message.net.ssl.CRLCache;
import progress.message.net.ssl.CRLCacheUpdateException;

public class CRLCachePolicy {
    private static boolean DEBUG = false;
    private static Hashtable s_policies = new Hashtable();
    private static volatile CRLCache m_listener = null;
    private static final Comparator s_comparator = new Comparator(){

        public int compare(Object x, Object y) {
            long update2;
            long update1 = ((CRLCachePolicy)x).getNextUpdate();
            if (update1 > (update2 = ((CRLCachePolicy)y).getNextUpdate())) {
                return 1;
            }
            if (update1 == update2) {
                return 0;
            }
            return -1;
        }
    };
    public static String UNKNOWN_CA = "Unknown CA";
    private String m_issuerName = UNKNOWN_CA;
    private String m_distributionPoint = null;
    private long m_refreshInterval = 86400L;
    private long m_cacheLifeTime = -1L;
    private long m_lastUpdated = -1L;
    private long m_nextUpdate = -1L;

    public static void setDebug(boolean on) {
        DEBUG = on;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CRLCachePolicy addPolicy(String issuer, String distributionPoint, long refreshInterval, long lifeTime) {
        CRLCachePolicy policy = null;
        Hashtable hashtable = s_policies;
        synchronized (hashtable) {
            policy = new CRLCachePolicy(distributionPoint);
            policy.setRefreshInterval(refreshInterval);
            policy.setCacheLifeTime(lifeTime);
            s_policies.put(policy.getDistributionPoint(), policy);
            if (DEBUG) {
                System.out.println("Adding " + policy);
            }
        }
        if (m_listener != null) {
            try {
                m_listener.addPolicy(policy);
            }
            catch (CRLCacheUpdateException cRLCacheUpdateException) {
                // empty catch block
            }
        }
        return policy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deletePolicy(String distributionPoint) {
        CRLCachePolicy policy = null;
        Hashtable hashtable = s_policies;
        synchronized (hashtable) {
            policy = (CRLCachePolicy)s_policies.remove(distributionPoint);
            if (policy == null) {
                return false;
            }
        }
        if (m_listener != null) {
            m_listener.deletePolicy(policy);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateCacheLifetime(String distributionPoint, long lifetime) {
        CRLCachePolicy policy = null;
        Hashtable hashtable = s_policies;
        synchronized (hashtable) {
            policy = (CRLCachePolicy)s_policies.get(distributionPoint);
            if (policy == null) {
                return false;
            }
        }
        if (DEBUG) {
            System.out.println("Updating cache lifetime for CRL " + distributionPoint + ", new cache lifetime = " + lifetime);
        }
        policy.setCacheLifeTime(lifetime);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateRefreshInterval(String distributionPoint, long interval) {
        CRLCachePolicy policy = null;
        Hashtable hashtable = s_policies;
        synchronized (hashtable) {
            policy = (CRLCachePolicy)s_policies.get(distributionPoint);
            if (policy == null) {
                return false;
            }
        }
        if (DEBUG) {
            System.out.println("Updating refresh interval for CRL " + distributionPoint + ", new interval = " + interval);
        }
        policy.setRefreshInterval(interval);
        if (m_listener != null) {
            m_listener.forceUpdate(distributionPoint);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CRLCachePolicy[] register(CRLCache cache) {
        Hashtable hashtable = s_policies;
        synchronized (hashtable) {
            CRLCachePolicy.addListener(cache);
            if (s_policies.isEmpty()) {
                return null;
            }
            CRLCachePolicy[] policies = new CRLCachePolicy[s_policies.size()];
            int i = 0;
            Enumeration elms = s_policies.elements();
            while (elms.hasMoreElements()) {
                policies[i++] = (CRLCachePolicy)elms.nextElement();
            }
            return policies;
        }
    }

    private static void addListener(CRLCache store) {
        m_listener = store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getCAList() {
        Hashtable hashtable = s_policies;
        synchronized (hashtable) {
            if (s_policies.isEmpty()) {
                return null;
            }
            String[] list = new String[s_policies.size()];
            int i = 0;
            Enumeration elms = s_policies.elements();
            while (elms.hasMoreElements()) {
                list[i++] = ((CRLCachePolicy)elms.nextElement()).getDistributionPoint();
            }
            return list;
        }
    }

    public static void forceCRLUpdate(String distributionPoint) {
        if (m_listener != null) {
            m_listener.forceUpdate(distributionPoint);
            if (DEBUG) {
                System.out.println("Updating CRL " + distributionPoint);
            }
        }
    }

    public static CRLCachePolicy nextUpdate(CRLCachePolicy[] policyList) {
        Arrays.sort(policyList, s_comparator);
        return policyList[0];
    }

    public CRLCachePolicy(String issuerName, String distributionPoint) {
        this.m_issuerName = issuerName;
        this.m_distributionPoint = distributionPoint;
    }

    public CRLCachePolicy(String distributionPoint) {
        this.m_distributionPoint = distributionPoint;
    }

    public void setIssuerName(String issuer) {
        this.m_issuerName = issuer;
    }

    public synchronized void setRefreshInterval(long refreshInterval) {
        this.m_refreshInterval = refreshInterval;
    }

    public void setNextUpdate(long nextUpdate) {
        this.m_nextUpdate = nextUpdate;
    }

    public void setLastUpdated(long lastUpdated) {
        this.m_lastUpdated = lastUpdated;
    }

    public synchronized void setCacheLifeTime(long cacheLifeTime) {
        this.m_cacheLifeTime = cacheLifeTime;
    }

    public String getIssuerName() {
        return this.m_issuerName;
    }

    public String getDistributionPoint() {
        return this.m_distributionPoint;
    }

    public synchronized long getRefreshInterval() {
        return this.m_refreshInterval;
    }

    public synchronized long getCacheLifeTime() {
        return this.m_cacheLifeTime;
    }

    public long getNextUpdate() {
        return this.m_nextUpdate;
    }

    public long getLastUpdated() {
        return this.m_lastUpdated;
    }

    public String toString() {
        return "CRL cache policy: dp = " + this.m_distributionPoint + ", interval = " + this.m_refreshInterval + ", lifetime = " + this.m_cacheLifeTime;
    }
}

