/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.ssl;

import progress.message.net.ssl.ICRLStoreParameters;

public class LDAPCRLStoreParameters
implements ICRLStoreParameters {
    public static final int LDAP_AUTH_NONE = 1;
    public static final int LDAP_AUTH_SIMPLE = 2;
    public static final int LDAP_AUTH_EXTERNAL_SSL = 3;
    public static final int LDAP_DEFAULT_AUTH_TYPE = 1;
    public static final int LDAP_DEFAULT_SIZE_LIMIT = 200;
    public static final int LDAP_DEFAULT_TIME_LIMIT = 0;
    public static final String LDAP_DEFAULT_BASE_DN_ATTRS = "o,ou";
    public static final String LDAP_DEFAULT_SEARCH_FILTER_ATTRS = "cn";
    public static final String LDAP_DEFAULT_CERTIFICATE_ATTRS = "usercertificate;binary,caCertificate;binary";
    public static final String LDAP_DEFAULT_CERTIFICATE_REVOCATION_ATTRS = "authorityRevocationList;binary,certificateRevocationList;binary";
    public static final int LDAP_DEFAULT_SEARCH_PRIORITY = 2;
    public static final boolean LDAP_DEFAULT_DISCONNECT_BEFORE_CONNECT = true;
    static boolean DEBUG = false;
    private int sizeLimit = 200;
    private int timeLimit = 0;
    private String baseDNAttrs = "o,ou";
    private String searchRoot = null;
    private String searchFilterAttrs = "cn";
    private String certificateAttrs = "usercertificate;binary,caCertificate;binary";
    private String certificateRevocationAttrs = "authorityRevocationList;binary,certificateRevocationList;binary";
    private int searchPriority = 2;
    private boolean disconnectBeforeConnect = true;
    private String m_url = null;
    private String m_protocol = null;
    private boolean m_isLdaps = false;
    private String m_principal = null;
    private String m_credentials = null;
    private int m_authType = 1;
    private String m_trustStore = null;
    private String m_trustStorePassword = null;
    private String m_keyStoreType = null;
    private String m_keyStore = null;
    private String m_keyStorePassword = null;

    public static void setDebug(boolean on) {
        DEBUG = on;
    }

    public String toString() {
        return "url = " + this.m_url + ", auth type = " + this.m_authType + ", bind princiapl/password  = " + this.m_principal + "/" + this.m_credentials;
    }

    public LDAPCRLStoreParameters(String url) {
        if (url.startsWith("ldaps")) {
            this.m_url = "ldap" + url.substring(5);
            this.m_protocol = "ssl";
            this.m_isLdaps = true;
        } else if (url.startsWith("ldap")) {
            this.m_url = url;
        }
    }

    public void setAuthType(int auth) {
        this.m_authType = auth;
    }

    public void setSimpleAuth() {
        this.m_authType = 2;
    }

    public void setExternalAuth() {
        this.m_authType = 3;
    }

    public void setPrincipal(String principal) {
        this.m_principal = principal;
    }

    public void setCredentials(String credentials) {
        this.m_credentials = credentials;
    }

    public void setTrustStore(String trustStore) {
        this.m_trustStore = trustStore;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.m_trustStorePassword = trustStorePassword;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.m_keyStoreType = keyStoreType;
    }

    public void setKeyStore(String keyStore) {
        this.m_keyStore = keyStore;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.m_keyStorePassword = keyStorePassword;
    }

    public void populateSSLProperties() {
        if (!this.m_isLdaps) {
            return;
        }
        if (this.m_trustStore != null) {
            System.setProperty("javax.net.ssl.trustStore", this.m_trustStore);
        }
        if (this.m_trustStorePassword != null) {
            System.setProperty("javax.net.ssl.trustStorePassword", this.m_trustStorePassword);
        }
        if (this.m_keyStoreType != null) {
            System.setProperty("javax.net.ssl.keyStoreType", this.m_keyStoreType);
        }
        if (this.m_keyStore != null) {
            System.setProperty("javax.net.ssl.keyStore", this.m_keyStore);
        }
        if (this.m_keyStorePassword != null) {
            System.setProperty("javax.net.ssl.keyStorePassword", this.m_keyStorePassword);
        }
    }

    public String getURL() {
        return this.m_url;
    }

    public String getProtocol() {
        return this.m_protocol;
    }

    public String getPrincipal() {
        return this.m_principal;
    }

    public String getCredentials() {
        return this.m_credentials;
    }

    public int getAuthType() {
        return this.m_authType;
    }

    public int getSizeLimit() {
        return this.sizeLimit;
    }

    public void setSizeLimit(int sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(int timeLimit) {
        this.timeLimit = timeLimit;
    }

    public String getBaseDNAttrs() {
        return this.baseDNAttrs;
    }

    public void setBaseDNAttrs(String baseDNAttrs) {
        this.baseDNAttrs = baseDNAttrs;
    }

    public String getSearchRoot() {
        return this.searchRoot;
    }

    public void setSearchRoot(String searchRoot) {
        this.searchRoot = searchRoot;
    }

    public String getSearchFilterAttrs() {
        return this.searchFilterAttrs;
    }

    public void setSearchFilterAttrs(String searchFilterAttrs) {
        this.searchFilterAttrs = searchFilterAttrs;
    }

    public String getCertificateAttrs() {
        return this.certificateAttrs;
    }

    public void setCertificateAttrs(String certificateAttrs) {
        this.certificateAttrs = certificateAttrs;
    }

    public String getCertificateRevocationAttrs() {
        return this.certificateRevocationAttrs;
    }

    public void setCertificateRevocationAttrs(String certificateRevocationAttrs) {
        this.certificateRevocationAttrs = certificateRevocationAttrs;
    }

    public int getSearchPriority() {
        return this.searchPriority;
    }

    public void setSearchPriority(int searchPriority) {
        this.searchPriority = searchPriority;
    }

    public boolean getDisconnectBeforeConnect() {
        return this.disconnectBeforeConnect;
    }

    public void setDisconnectBeforeConnect(boolean disconnectBeforeConnect) {
        this.disconnectBeforeConnect = disconnectBeforeConnect;
    }
}

