/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.ssl;

import com.sonicsw.security.ssl.SSLUtil;
import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.Vector;
import progress.message.crypto.DESString;
import progress.message.net.ESocketConfigException;
import progress.message.net.ProgressInetAddress;
import progress.message.net.ProgressSocket;
import progress.message.net.http.client.tunnel.IHttpProxyConfig;
import progress.message.net.ssl.ISSLControl;
import progress.message.net.ssl.ISSLSocket;
import progress.message.net.ssl.ProgressSslSocketFactory;
import progress.message.net.ssl.prAccessor;
import progress.message.security.cert.X509Certificate;
import progress.message.zclient.SessionConfig;

final class ProgressSslSocket
extends ProgressSocket {
    private static final boolean DEBUG = false;
    private static final int DEFAULT_SSL_PORT = 443;
    private Object m_props;
    private ISSLSocket m_socket = null;
    private static StringEncrypter desDecrypter = new StringEncrypter();

    public ProgressSslSocket(Principal principal, String host, int portnum, Object properties, IHttpProxyConfig pConfig) throws UnknownHostException, IOException {
        String esslPassword;
        int port = portnum <= 0 ? 443 : portnum;
        this.m_props = properties;
        ISSLControl control = ProgressSslSocketFactory.getSSLImpl().createSSLClientControl();
        String cipherSuites = SSLUtil.getProperty(this.m_props, "SSL_CIPHER_SUITES", null);
        Vector cs = SSLUtil.getCipherSuites(cipherSuites, false);
        if (!control.configureCipherSuites(cs)) {
            throw new ESocketConfigException(prAccessor.getString("STR008") + cipherSuites);
        }
        String caCerts = SSLUtil.getProperty(this.m_props, "SSL_CA_CERTIFICATES_DIR", null);
        if (caCerts == null) {
            caCerts = SSLUtil.getProperty(this.m_props, "SSL_CA_CERTIFICATES", null);
        }
        if (!control.configureTrustDecider(caCerts, null)) {
            throw new ESocketConfigException(prAccessor.getString("STR001"));
        }
        String certs = SSLUtil.getProperty(this.m_props, "SSL_CERTIFICATE_CHAIN", null);
        String certForm = SSLUtil.getProperty(this.m_props, "SSL_CERTIFICATE_CHAIN_FORM", "PKCS7");
        String key = SSLUtil.getProperty(this.m_props, "SSL_PRIVATE_KEY", null);
        String keyForm = SSLUtil.getProperty(this.m_props, "SSL_PRIVATE_KEY_FORM", "PKCS8");
        String pwd = SSLUtil.getProperty(this.m_props, "SSL_PRIVATE_KEY_PASSWORD", null);
        if (pwd == null && (esslPassword = SSLUtil.getProperty(this.m_props, "ESSL_PRIVATE_KEY_PASSWORD", null)) != null) {
            pwd = desDecrypter.decrypt(esslPassword);
        }
        if (certs != null && pwd != null && !control.configureKeyAndCertificate(certs, certForm, key, keyForm, pwd)) {
            throw new ESocketConfigException(prAccessor.getString("STR007"));
        }
        String proxyHost = SSLUtil.getProperty(this.m_props, "TUNNELING_PROXY_HOST", null);
        String proxyPort = SSLUtil.getProperty(this.m_props, "TUNNELING_PROXY_PORT", null);
        if (pConfig != null && pConfig.getHost() != null && pConfig.getHost().trim().length() > 0) {
            this.m_socket = ProgressSslSocketFactory.getSSLImpl().createSSLSocket(host, port, control, null, -1, this.m_props, pConfig);
        } else if (proxyHost != null && proxyPort != null) {
            try {
                int tPort = Integer.parseInt(proxyPort);
                this.m_socket = ProgressSslSocketFactory.getSSLImpl().createSSLSocket(host, port, control, proxyHost, tPort, this.m_props, null);
            }
            catch (NumberFormatException e) {
                throw new ESocketConfigException(prAccessor.getString("STR009") + proxyPort);
            }
        } else {
            this.m_socket = ProgressSslSocketFactory.getSSLImpl().createSSLSocket(host, port, control, this.m_props);
        }
        this.trySetTcpNoDelay();
    }

    public ProgressSslSocket(Principal principal, String host, int port, IHttpProxyConfig pConfig) throws UnknownHostException, IOException {
        this(principal, host, port, null, pConfig);
    }

    ProgressSslSocket(ISSLSocket s, Object properties) {
        this.m_socket = s;
        this.trySetTcpNoDelay();
        this.m_props = properties;
    }

    private void trySetTcpNoDelay() {
        this.m_impl = this.m_socket.getImpl();
        try {
            this.m_impl.setTcpNoDelay(SessionConfig.TCP_NODELAY);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    @Override
    public void startTransportHandshake() throws IOException {
        this.m_socket.startHandshake();
    }

    @Override
    public void setSoTimeout(int timeout) throws IOException {
        this.m_socket.setSoTimeout(timeout);
    }

    @Override
    public X509Certificate getCertificate() {
        return null;
    }

    @Override
    public X509Certificate getPeerCertificate() {
        try {
            return this.m_socket.getPeerCertificate();
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public X509Certificate[] getPeerCertificateChain() {
        try {
            return this.m_socket.getPeerCertificateChain();
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public ProgressInetAddress getInetAddress() {
        if (this.m_socket.getImpl().getInetAddress() == null) {
            return null;
        }
        return new ProgressInetAddress(this.m_socket.getImpl().getInetAddress());
    }

    private static final class StringEncrypter
    extends DESString {
        private static final byte[] s_data = new byte[]{21, 89, -63, 38, 64, -94, -40, 3, 5, 35, 69, 103, -119, -85, -51, -17};

        private StringEncrypter() {
        }

        @Override
        protected byte[] getSalt() {
            return s_data;
        }

        final String decrypt(String encoded_string) throws IOException {
            return this.DESDecrypt(encoded_string);
        }
    }
}

