/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.ssl.jsafe;

import com.rsa.certj.CertJ;
import com.rsa.certj.Provider;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.provider.path.PKIXCertPath;
import com.rsa.ssl.external.IntegratedCertJVerifier;
import com.rsa.ssl.external.Truster;
import java.text.MessageFormat;
import progress.message.broker.Config;
import progress.message.net.ESocketConfigException;
import progress.message.net.ssl.jsafe.jsafeSSLClientControl;
import progress.message.net.ssl.jsafe.providers.CRLCertStatus;
import progress.message.net.ssl.jsafe.providers.MemoryDB;
import progress.message.net.ssl.prAccessor;
import progress.message.zclient.SessionConfig;

public class jsafeSSLServerControl
extends jsafeSSLClientControl {
    @Override
    public boolean configureTrustDecider(String caCerts, String trustDecider) throws ESocketConfigException {
        if (this.context == null) {
            return false;
        }
        if (caCerts == null) {
            SessionConfig.logMessage(progress.message.net.ssl.jsafe.prAccessor.getString("STR001"), SessionConfig.getLevelInfo());
            return false;
        }
        try {
            X509Certificate[] certs = this.loadCACertificates(caCerts);
            if (certs == null || certs.length == 0) {
                return false;
            }
            if (this.DEBUG) {
                System.out.println("total CA certificate count = " + certs.length + " ");
            }
            for (int i = 0; i < certs.length; ++i) {
                this.context.addCACertificate(certs[i]);
            }
        }
        catch (Exception ex) {
            SessionConfig.logMessage(ex.getMessage(), ex, SessionConfig.getLevelWarning());
            return false;
        }
        if (this.DEBUG) {
            System.out.println("Successfully registered CA certificate(s)");
        }
        if (trustDecider != null) {
            try {
                Class<?> trustClass = Class.forName(trustDecider);
                Object truster = trustClass.newInstance();
                if (!(truster instanceof Truster)) {
                    throw new Exception(trustDecider + " is not an instance of com.rsa.ssl.external.Truster");
                }
                this.context.setTruster((Truster)truster);
            }
            catch (Exception ex) {
                String mf104 = progress.message.net.ssl.jsafe.prAccessor.getString("STR004");
                Object[] ob104 = new Object[]{trustDecider, ex + ex.getMessage()};
                SessionConfig.logMessage(MessageFormat.format(mf104, ob104), SessionConfig.getLevelWarning());
                return false;
            }
            if (this.DEBUG) {
                System.out.println("Successfully installed the custome Truster " + trustDecider);
            }
        } else if (Config.SSL_DO_CRL_CHECKING) {
            SessionConfig.logMessage(prAccessor.getString("CRL_CHECKING_ENABLED"), SessionConfig.getLevelInfo());
            IntegratedCertJVerifier cv = null;
            try {
                cv = this.initializeCertJ();
                this.context.setTruster((Truster)cv);
            }
            catch (Exception ex) {
                throw new ESocketConfigException(ex.getMessage());
            }
        }
        try {
            this.context.setClientAuthentication(2);
        }
        catch (Exception ex) {
            SessionConfig.logMessage(ex.getMessage(), ex, SessionConfig.getLevelWarning());
            return false;
        }
        if (this.DEBUG) {
            System.out.println("Peer authentication is enabled");
        }
        return true;
    }

    private IntegratedCertJVerifier initializeCertJ() throws Exception {
        CertJ certJ = null;
        Object certJVerifier = null;
        try {
            MemoryDB dbProvider = null;
            PKIXCertPath pathProvider = null;
            CRLCertStatus statusProvider = null;
            dbProvider = MemoryDB.getInstance();
            statusProvider = new CRLCertStatus();
            if (this.DEBUG) {
                statusProvider.setDebug(true);
            }
            pathProvider = new PKIXCertPath("PKIX path");
            Provider[] providers = new Provider[]{dbProvider, pathProvider, statusProvider};
            certJ = new CertJ(providers);
            return new IntegratedCertJVerifier(certJ);
        }
        catch (Exception ex) {
            if (this.DEBUG) {
                System.out.println("Caught exception while initializing Cert-J components.");
                ex.printStackTrace();
            }
            throw ex;
        }
    }
}

