/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.ssl.jsafe.providers;

import com.rsa.certj.CertJ;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.NotSupportedException;
import com.rsa.certj.Provider;
import com.rsa.certj.ProviderImplementation;
import com.rsa.certj.ProviderManagementException;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.RevokedCertificates;
import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.certj.spi.revocation.CertRevocationInfo;
import com.rsa.certj.spi.revocation.CertStatusException;
import com.rsa.certj.spi.revocation.CertStatusInterface;
import java.util.Date;
import java.util.Vector;
import progress.message.net.ssl.jsafe.providers.MemoryDB;
import progress.message.net.ssl.prAccessor;
import progress.message.zclient.SessionConfig;

public final class CRLCertStatus
extends Provider {
    private boolean DEBUG = false;

    public void setDebug(boolean on) {
        this.DEBUG = on;
    }

    public CRLCertStatus() throws InvalidParameterException {
        super(2, "CRLStatus");
    }

    public ProviderImplementation instantiate(CertJ certJ) throws ProviderManagementException {
        try {
            return new Implementation(certJ, this.getName());
        }
        catch (InvalidParameterException e) {
            throw new ProviderManagementException("CRLCertStatus.instantiate: " + e.getMessage());
        }
    }

    private final class Implementation
    extends ProviderImplementation
    implements CertStatusInterface {
        private Implementation(CertJ certJ, String name) throws InvalidParameterException {
            super(certJ, name);
        }

        public CertRevocationInfo checkCertRevocation(CertPathCtx pathCtx, Certificate cert) throws NotSupportedException, CertStatusException {
            if (!(cert instanceof X509Certificate)) {
                throw new NotSupportedException("CRLCertStatus$Implementation.checkCertRevocation: does not support certificat types other than X509Certificate.");
            }
            X509Certificate x509Cert = (X509Certificate)cert;
            if (CRLCertStatus.this.DEBUG) {
                System.out.println("CRL checking for " + x509Cert.getSubjectName() + " by CA " + x509Cert.getIssuerName());
            }
            Date validationTime = null;
            try {
                Vector crls = new Vector();
                validationTime = pathCtx.getValidationTime() == null ? new Date() : pathCtx.getValidationTime();
                pathCtx.getDatabase().selectCRLByIssuerAndTime(x509Cert.getIssuerName(), validationTime, crls);
                if (CRLCertStatus.this.DEBUG) {
                    System.out.println(crls.size() + " CRL(s) found.");
                }
                for (int i = 0; i < crls.size(); ++i) {
                    X509CRL crl;
                    X509CRL evidence = crl = (X509CRL)crls.elementAt(i);
                    if (CRLCertStatus.this.DEBUG) {
                        System.out.println("Checking against CRL issued by " + crl.getIssuerName() + " on " + crl.getThisUpdate());
                    }
                    if (crl instanceof MemoryDB.ExpiredCachedCRL) {
                        if (CRLCertStatus.this.DEBUG) {
                            System.out.println("Connection rejected: cached CRL expired");
                        }
                        SessionConfig.logMessage(prAccessor.getString("CACHED_CRL_EXPIRED") + x509Cert.getSubjectName(), SessionConfig.getLevelWarning());
                        return new CertRevocationInfo(1, 1, (Object)evidence);
                    }
                    if (this.isCRLObsolete(crl, validationTime)) continue;
                    if (CRLCertStatus.this.DEBUG) {
                        System.out.println("CRL is valid (not obsolete).");
                    }
                    if (this.findSerialNumberInCrl(x509Cert.getSerialNumber(), crl)) {
                        SessionConfig.logMessage(prAccessor.getString("CERTIFICATE_REVOKED") + x509Cert.getSubjectName(), SessionConfig.getLevelWarning());
                        return new CertRevocationInfo(1, 1, (Object)evidence);
                    }
                    if (CRLCertStatus.this.DEBUG) {
                        System.out.println("Target certificate NOT revoked!!!");
                    }
                    return new CertRevocationInfo(0, 1, (Object)evidence);
                }
                if (CRLCertStatus.this.DEBUG) {
                    System.out.println("Target certificate revocation unknown - no CRL!!!");
                }
                return new CertRevocationInfo(2, 0, null);
            }
            catch (Exception e) {
                if (CRLCertStatus.this.DEBUG) {
                    e.printStackTrace();
                }
                throw new CertStatusException("CRLCertStatus$Implementation.checkCertRevocation: " + e.getMessage());
            }
        }

        private boolean findSerialNumberInCrl(byte[] serialNumber, X509CRL crl) {
            RevokedCertificates entries = crl.getRevokedCertificates();
            if (entries == null) {
                return false;
            }
            for (int i = 0; i < entries.getCertificateCount(); ++i) {
                try {
                    if (!CertJUtils.byteArraysEqual((byte[])serialNumber, (byte[])entries.getSerialNumber(i))) continue;
                    return true;
                }
                catch (CertificateException e) {
                    // empty catch block
                }
            }
            return false;
        }

        private boolean isCRLObsolete(X509CRL crl, Date validationTime) {
            Date nextUpdate = crl.getNextUpdate();
            return nextUpdate != null && validationTime.after(nextUpdate);
        }

        public String toString() {
            return "CRL Certificate Status provider named: " + super.getName();
        }
    }
}

