/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.ssl.jsse;

import com.sonicsw.security.ssl.CipherSuiteUtil;
import com.sonicsw.security.ssl.JSSEConfigManager;
import com.sonicsw.security.ssl.KeyStoreHelper;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;
import javax.net.ssl.SSLContext;
import progress.message.net.ESocketConfigException;
import progress.message.net.ssl.ISSLControl;

public class jsseSSLControl
implements ISSLControl {
    private boolean m_debugEnabled = false;
    public static final String KEYSTORE_ALIAS = "sonic";
    private SSLContext m_context = null;
    private String[] m_enabledCiphers = null;
    private KeyStore m_keyStoreFromPKCS = null;
    private KeyStore m_trustStoreFromCADir = null;
    private String m_keyStoreFromPKCSPassword = null;

    public jsseSSLControl(boolean debugEnabled) throws ESocketConfigException {
        this.m_debugEnabled = debugEnabled;
        try {
            this.m_context = SSLContext.getInstance("TLS");
            this.debug("JSSE provider is " + this.m_context.getProvider());
        }
        catch (Exception ex) {
            if (this.m_debugEnabled) {
                ex.printStackTrace();
            }
            ESocketConfigException sce = new ESocketConfigException(ex.getMessage(), ex);
            sce.fillInStackTrace();
            throw sce;
        }
    }

    @Override
    public Object getContext() {
        return this.m_context;
    }

    public KeyStore getKeyStore() {
        return this.m_keyStoreFromPKCS;
    }

    public String getKeyStorePassword() {
        return this.m_keyStoreFromPKCSPassword;
    }

    public String getKeyStoreAlias() {
        return KEYSTORE_ALIAS;
    }

    public KeyStore getTrustStore() {
        return this.m_trustStoreFromCADir;
    }

    @Override
    public boolean configureKeyAndCertificate(String certificates, String certForm, String key, String keyForm, String password) {
        block8: {
            if (certificates == null || password == null) {
                return false;
            }
            if (certForm.equalsIgnoreCase("PKCS7")) {
                try {
                    this.m_keyStoreFromPKCS = KeyStoreHelper.keyStoreFromPKCS7AndEncryptedPKCS8(certificates, key, password, KEYSTORE_ALIAS);
                    this.m_keyStoreFromPKCSPassword = password;
                }
                catch (Exception ex) {
                    if (this.m_debugEnabled) {
                        System.out.println("Unable to populate PKCS7 & PKCS8 into a key store:" + ex.getMessage());
                    }
                    break block8;
                }
            }
            if (certForm.equalsIgnoreCase("PKCS12")) {
                try {
                    this.m_keyStoreFromPKCS = KeyStoreHelper.keyStoreFromPKCS12(certificates, password, KEYSTORE_ALIAS);
                    this.m_keyStoreFromPKCSPassword = password;
                }
                catch (Exception ex) {
                    if (!this.m_debugEnabled) break block8;
                    System.out.println("Unable to populate PKCS12 into a key store:" + ex.getMessage());
                }
            }
        }
        return true;
    }

    public String[] getEnabledCipherSuites() {
        return this.m_enabledCiphers;
    }

    @Override
    public boolean configureCipherSuites(Vector ciphers) {
        if (ciphers != null && ciphers.size() != 0) {
            this.m_enabledCiphers = new String[ciphers.size()];
            Enumeration csNames = ciphers.elements();
            int i = 0;
            while (csNames.hasMoreElements()) {
                String cipher = (String)csNames.nextElement();
                String jsseCipher = CipherSuiteUtil.getJSSECipherSuiteFromRSA((String)cipher);
                if (jsseCipher != null) {
                    this.m_enabledCiphers[i++] = jsseCipher;
                    if (!this.m_debugEnabled) continue;
                    System.out.println("replacing RSA cipher " + cipher + " with JSSE cipher " + jsseCipher);
                    continue;
                }
                this.m_enabledCiphers[i++] = cipher;
            }
        }
        return true;
    }

    @Override
    public boolean configureTrustDecider(String caDirectory, String trustDecider) throws ESocketConfigException {
        try {
            X509Certificate[] caCerts = KeyStoreHelper.loadCertificatesFromDirectory(caDirectory);
            this.m_trustStoreFromCADir = KeyStoreHelper.trustStoreFromCertificates(caCerts, null);
        }
        catch (Exception ex) {
            ESocketConfigException se = new ESocketConfigException(ex.getMessage(), ex);
            se.fillInStackTrace();
            throw se;
        }
        return true;
    }

    public String toString() {
        return new String("jsseSSLClientControl");
    }

    protected final void debug(String msg) {
        if (this.m_debugEnabled) {
            System.out.println("jsse SSL: " + msg);
        }
    }

    @Override
    public void setDebug(boolean on) {
        this.m_debugEnabled = on;
    }

    public SSLContext getSSLContext(JSSEConfigManager configManager) {
        block8: {
            if (configManager != null) {
                try {
                    if (this.m_context != null) {
                        this.m_context.init(configManager.getKeyManagers(), configManager.getTrustManagers(), null);
                    }
                }
                catch (KeyManagementException e) {
                    this.m_context = null;
                    if (this.m_debugEnabled) {
                        e.printStackTrace();
                    }
                }
                catch (SecurityException e) {
                    this.m_context = null;
                    if (this.m_debugEnabled) {
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {
                    this.m_context = null;
                    if (!this.m_debugEnabled) break block8;
                    e.printStackTrace();
                }
            }
        }
        return this.m_context;
    }
}

